/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.BinaryOp;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class NodeComparison
extends BinaryOp {
    private final int relation;

    public NodeComparison(XQueryContext context, Expression left, Expression right, int relation) {
        super(context);
        this.relation = relation;
        this.add(new DynamicCardinalityCheck(context, 3, left, new Error("D05")));
        this.add(right);
    }

    public int getDependencies() {
        return 3;
    }

    public int getCardinality() {
        return 3;
    }

    public int returnsType() {
        return 23;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        if (!ls.isEmpty() && !rs.isEmpty()) {
            if (!Type.subTypeOf(ls.itemAt(0).getType(), -1)) {
                throw new XPathException(this.getASTNode(), "XPTY0004: left item is not a node; got '" + Type.getTypeName(ls.itemAt(0).getType()) + "'");
            }
            if (!Type.subTypeOf(rs.itemAt(0).getType(), -1)) {
                throw new XPathException(this.getASTNode(), "XPTY0004: right item is not a node; got '" + Type.getTypeName(rs.itemAt(0).getType()) + "'");
            }
            NodeValue lv = (NodeValue)ls.itemAt(0);
            NodeValue rv = (NodeValue)rs.itemAt(0);
            if (lv.getImplementationType() != rv.getImplementationType()) {
                result = BooleanValue.FALSE;
            } else {
                switch (this.relation) {
                    case 14: {
                        result = lv.equals(rv) ? BooleanValue.TRUE : BooleanValue.FALSE;
                        break;
                    }
                    case 15: {
                        result = lv.equals(rv) ? BooleanValue.FALSE : BooleanValue.TRUE;
                        break;
                    }
                    case 16: {
                        result = lv.before(rv, false) ? BooleanValue.TRUE : BooleanValue.FALSE;
                        break;
                    }
                    case 17: {
                        result = lv.after(rv, false) ? BooleanValue.TRUE : BooleanValue.FALSE;
                        break;
                    }
                    default: {
                        throw new XPathException("Illegal argument: unknown relation");
                    }
                }
            }
        } else {
            if (ls.isEmpty() && !rs.isEmpty() && !Type.subTypeOf(rs.getItemType(), -1)) {
                throw new XPathException("XPTY0004 : the empty sequence cant be an atomic value");
            }
            if (!ls.isEmpty() && rs.isEmpty() && !Type.subTypeOf(ls.getItemType(), -1)) {
                throw new XPathException("XPTY0004 : the empty sequence cant be an atomic value");
            }
            result = BooleanValue.EMPTY_SEQUENCE;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        this.getLeft().dump(dumper);
        dumper.display(' ').display(Constants.OPS[this.relation]).display(' ');
        this.getRight().dump(dumper);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getLeft().toString());
        result.append(' ').append(Constants.OPS[this.relation]).append(' ');
        result.append(this.getRight().toString());
        return result.toString();
    }
}

