/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.TreeSet;
import org.exist.xquery.CombiningExpression;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Intersection
extends CombiningExpression {
    public Intersection(XQueryContext context, PathExpr left, PathExpr right) {
        super(context, left, right);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence lval = this.left.eval(contextSequence, contextItem);
        Sequence rval = this.right.eval(contextSequence, contextItem);
        lval.removeDuplicates();
        rval.removeDuplicates();
        if (lval.isEmpty() || rval.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            if (!Type.subTypeOf(lval.getItemType(), -1) || !Type.subTypeOf(rval.getItemType(), -1)) {
                throw new XPathException(this.getASTNode(), "Error XPTY0004 : intersect operand is not a node sequence");
            }
            if (lval.isPersistentSet() && rval.isPersistentSet()) {
                result = lval.toNodeSet().intersection(rval.toNodeSet());
            } else {
                result = new ValueSequence();
                TreeSet<Item> set = new TreeSet<Item>();
                SequenceIterator i = lval.unorderedIterator();
                while (i.hasNext()) {
                    set.add(i.nextItem());
                }
                i = rval.unorderedIterator();
                while (i.hasNext()) {
                    Item next = i.nextItem();
                    if (!set.contains(next)) continue;
                    result.add(next);
                }
                result.removeDuplicates();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        this.left.dump(dumper);
        dumper.display(" intersect ");
        this.right.dump(dumper);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.left.toString());
        result.append(" intersect ");
        result.append(this.right.toString());
        return result.toString();
    }
}

