/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.util.serializer.IndentingXMLWriter;
import org.exist.util.serializer.XMLWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMSerializer {
    protected XMLWriter receiver;
    protected NamespaceSupport nsSupport = new NamespaceSupport();
    protected HashMap namespaceDecls = new HashMap();
    protected Properties outputProperties;

    public DOMSerializer() {
        this.receiver = new IndentingXMLWriter();
    }

    public DOMSerializer(Writer writer, Properties outputProperties) {
        this.outputProperties = outputProperties;
        if (outputProperties == null) {
            outputProperties = new Properties();
        }
        this.receiver = new IndentingXMLWriter(writer);
        this.receiver.setOutputProperties(outputProperties);
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
        this.receiver.setOutputProperties(outputProperties);
    }

    public void setWriter(Writer writer) {
        this.receiver.setWriter(writer);
    }

    public void reset() {
        this.nsSupport.reset();
        this.namespaceDecls.clear();
    }

    public void serialize(Node node) throws TransformerException {
        Node top = node;
        while (node != null) {
            Node nextNode;
            this.startNode(node);
            Node node2 = nextNode = node.getNodeType() == 100 ? null : node.getFirstChild();
            while (nextNode == null) {
                this.endNode(node);
                if (top != null && top.equals(node)) break;
                nextNode = node.getNextSibling();
                if (nextNode != null || (node = node.getParentNode()) != null && (top == null || !top.equals(node))) continue;
                this.endNode(node);
                nextNode = null;
                break;
            }
            node = nextNode;
        }
    }

    protected void startNode(Node node) throws TransformerException {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                break;
            }
            case 1: {
                Attr nextAttr;
                this.namespaceDecls.clear();
                this.nsSupport.pushContext();
                this.receiver.startElement(node.getNodeName());
                String uri = node.getNamespaceURI();
                String prefix = node.getPrefix();
                if (uri == null) {
                    uri = "";
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (this.nsSupport.getURI(prefix) == null) {
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    nextAttr = (Attr)attrs.item(i);
                    String attrName = nextAttr.getName();
                    if (attrName.equals("xmlns")) {
                        String oldURI = this.nsSupport.getURI("");
                        uri = nextAttr.getValue();
                        if (oldURI != null && oldURI.equals(uri)) continue;
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrName.startsWith("xmlns:")) {
                        prefix = attrName.substring(6);
                        if (this.nsSupport.getURI(prefix) != null) continue;
                        uri = nextAttr.getValue();
                        this.namespaceDecls.put(prefix, uri);
                        this.nsSupport.declarePrefix(prefix, uri);
                        continue;
                    }
                    if (attrName.indexOf(58) <= 0) continue;
                    prefix = nextAttr.getPrefix();
                    uri = nextAttr.getNamespaceURI();
                    if (this.nsSupport.getURI(prefix) != null) continue;
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
                Iterator i = this.namespaceDecls.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry nsEntry = i.next();
                    this.receiver.namespace((String)nsEntry.getKey(), (String)nsEntry.getValue());
                }
                for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
                    nextAttr = (Attr)attrs.item(i2);
                    String name = nextAttr.getName();
                    if (name.startsWith("xmlns")) continue;
                    this.receiver.attribute(nextAttr.getName(), nextAttr.getValue());
                }
                break;
            }
            case 3: 
            case 4: {
                this.receiver.characters(((CharacterData)node).getData());
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                this.receiver.comment(((Comment)node).getData());
                break;
            }
        }
    }

    protected void endNode(Node node) throws TransformerException {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1) {
            this.nsSupport.popContext();
            this.receiver.endElement(node.getNodeName());
        }
    }
}

