/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;

public abstract class AbstractHashtable {
    private final int defaultSize = 1031;
    protected static final Object REMOVED = new Object();
    protected int tabSize;
    protected int items = 0;
    protected int maxRehash = 0;

    protected AbstractHashtable() {
        this.tabSize = 1031;
    }

    protected AbstractHashtable(int iSize) {
        if (iSize < 1) {
            this.tabSize = 1031;
        } else {
            if (!AbstractHashtable.isPrime(iSize)) {
                iSize = iSize * 3 / 2;
                iSize = (int)AbstractHashtable.nextPrime(iSize);
            }
            this.tabSize = iSize;
        }
    }

    public int size() {
        return this.items;
    }

    public abstract Iterator iterator();

    public abstract Iterator valueIterator();

    public static final boolean isPrime(long number) {
        if (number < 2L) {
            return false;
        }
        if (number == 2L) {
            return true;
        }
        if (number % 2L == 0L) {
            return false;
        }
        if (number == 3L) {
            return true;
        }
        if (number % 3L == 0L) {
            return false;
        }
        int y = 2;
        int x = (int)Math.sqrt(number);
        int i = 5;
        while (i <= x) {
            if (number % (long)i == 0L) {
                return false;
            }
            i += y;
            y = 6 - y;
        }
        return true;
    }

    public static final long nextPrime(long iVal) {
        long retval = iVal;
        while (!AbstractHashtable.isPrime(++retval)) {
        }
        return retval;
    }

    public int getMaxRehash() {
        return this.maxRehash;
    }

    protected static final class HashtableOverflowException
    extends Exception {
    }

    protected abstract class HashtableIterator
    implements Iterator {
        public static final int KEYS = 0;
        public static final int VALUES = 1;
        int returnType = 0;

        public HashtableIterator(int type) {
            this.returnType = type;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

