/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.NodePath;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FulltextIndexSpec {
    private static final String PATH_ATTRIB = "path";
    private static final String CONTENT_ATTRIB = "content";
    private static final String CONTENT_MIXED = "mixed";
    private static final String PRESERVE_CONTENT_ELEMENT = "preserveContent";
    private static final String EXCLUDE_INTERFACE = "exclude";
    private static final String INCLUDE_ELEMENT = "include";
    private static final String ALPHANUM_ATTRIB = "alphanum";
    private static final String ATTRIBUTES_ATTRIB = "attributes";
    private static final String DEFAULT_ATTRIB = "default";
    private static final String CREATE_ELEMENT = "create";
    private static final String QNAME_ATTRIB = "qname";
    private static final NodePath[] ARRAY_TYPE = new NodePath[0];
    private static final Logger LOG = Logger.getLogger((Class)FulltextIndexSpec.class);
    protected NodePath[] includePath;
    protected NodePath[] excludePath;
    protected NodePath[] mixedPath;
    protected NodePath[] preserveContent;
    protected Map qnameSpecs = new TreeMap();
    protected boolean includeByDefault = true;
    protected boolean includeAttributes = true;
    protected boolean includeAlphaNum = true;

    public FulltextIndexSpec(Map namespaces, Element node) throws DatabaseConfigurationException {
        String indexAlphaNum;
        String indexAttributes;
        ArrayList<NodePath> includeList = new ArrayList<NodePath>();
        ArrayList<NodePath> excludeList = new ArrayList<NodePath>();
        ArrayList<NodePath> preserveList = new ArrayList<NodePath>();
        ArrayList<NodePath> mixedList = new ArrayList<NodePath>();
        String def = node.getAttribute(DEFAULT_ATTRIB);
        if (def != null && def.length() > 0) {
            this.includeByDefault = def.equals("all");
        }
        if ((indexAttributes = node.getAttribute(ATTRIBUTES_ATTRIB)) != null && indexAttributes.length() > 0) {
            boolean bl = this.includeAttributes = indexAttributes.equals("true") || indexAttributes.equals("yes");
        }
        if ((indexAlphaNum = node.getAttribute(ALPHANUM_ATTRIB)) != null && indexAlphaNum.length() > 0) {
            this.setIncludeAlphaNum(indexAlphaNum.equals("true") || indexAlphaNum.equals("yes"));
        }
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            String ps;
            Element elem;
            Node next = children.item(j);
            if (INCLUDE_ELEMENT.equals(next.getLocalName())) {
                elem = (Element)next;
                String content = elem.getAttribute(CONTENT_ATTRIB);
                ps = elem.getAttribute(PATH_ATTRIB);
                if (ps == null || ps.length() == 0) {
                    throw new DatabaseConfigurationException("include element requires an attribute 'path' in collection configuration.");
                }
                if (content != null && content.length() != 0 && CONTENT_MIXED.equals(content)) {
                    mixedList.add(new NodePath(namespaces, ps, false));
                    continue;
                }
                includeList.add(new NodePath(namespaces, ps));
                continue;
            }
            if (EXCLUDE_INTERFACE.equals(next.getLocalName())) {
                ps = ((Element)next).getAttribute(PATH_ATTRIB);
                if (ps == null || ps.length() == 0) {
                    throw new DatabaseConfigurationException("exclude element requires an attribute 'path' in collection configuration.");
                }
                excludeList.add(new NodePath(namespaces, ps));
                continue;
            }
            if (PRESERVE_CONTENT_ELEMENT.equals(next.getLocalName())) {
                ps = ((Element)next).getAttribute(PATH_ATTRIB);
                if (ps == null || ps.length() == 0) {
                    throw new DatabaseConfigurationException("preserveContent element requires an attribute 'path' in collection configuration.");
                }
                preserveList.add(new NodePath(namespaces, ps));
                continue;
            }
            if (!CREATE_ELEMENT.equals(next.getLocalName())) continue;
            elem = (Element)next;
            String name = elem.getAttribute(QNAME_ATTRIB);
            if (name == null || name.length() == 0) {
                throw new DatabaseConfigurationException("create element requires an attribute 'qname' in collection configuration.");
            }
            boolean isAttribute = false;
            if (name.startsWith("@")) {
                isAttribute = true;
                name = name.substring(1);
            }
            String prefix = QName.extractPrefix(name);
            String localName = QName.extractLocalName(name);
            String namespaceURI = "";
            if (prefix != null && (namespaceURI = (String)namespaces.get(prefix)) == null) {
                throw new DatabaseConfigurationException("No namespace defined for prefix: " + prefix + " in index definition");
            }
            QName qname = new QName(localName, namespaceURI, null);
            if (isAttribute) {
                qname.setNameType((byte)1);
            }
            this.qnameSpecs.put(qname, new QNameSpec(qname, elem));
        }
        this.includePath = includeList.toArray(ARRAY_TYPE);
        this.excludePath = excludeList.toArray(ARRAY_TYPE);
        this.preserveContent = preserveList.toArray(ARRAY_TYPE);
        this.mixedPath = mixedList.toArray(ARRAY_TYPE);
    }

    public boolean isSelective() {
        return this.includeByDefault && this.excludePath.length > 0 || !this.includeByDefault && this.includePath.length > 0;
    }

    private void setIncludeAlphaNum(boolean index) {
        this.includeAlphaNum = index;
    }

    public boolean getIncludeAlphaNum() {
        return this.includeAlphaNum;
    }

    public boolean match(NodePath path) {
        if (this.includeByDefault) {
            for (int i = 0; i < this.excludePath.length; ++i) {
                if (!this.excludePath[i].match(path)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.includePath.length; ++i) {
            if (!this.includePath[i].match(path)) continue;
            return true;
        }
        return false;
    }

    public boolean matchAttribute(NodePath path) {
        if (this.includeAttributes) {
            for (int i = 0; i < this.excludePath.length; ++i) {
                if (!this.excludePath[i].match(path)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.includePath.length; ++i) {
            if (!this.includePath[i].match(path)) continue;
            return true;
        }
        return false;
    }

    public boolean matchMixedElement(NodePath path) {
        for (int i = 0; i < this.mixedPath.length; ++i) {
            if (!this.mixedPath[i].match(path)) continue;
            return true;
        }
        return false;
    }

    public boolean hasQNameIndex(QName qname) {
        return this.qnameSpecs.containsKey(qname);
    }

    public boolean preserveMixedContent(QName qname) {
        QNameSpec spec = (QNameSpec)this.qnameSpecs.get(qname);
        if (spec != null) {
            return spec.hasMixedContent();
        }
        return false;
    }

    public boolean preserveContent(NodePath path) {
        for (int i = 0; i < this.preserveContent.length; ++i) {
            if (!this.preserveContent[i].match(path)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        NodePath path;
        int i;
        StringBuffer result = new StringBuffer("Full-text index\n");
        result.append("\tincludeByDefault : ").append(this.includeByDefault).append('\n');
        result.append("\tincludeAttributes : ").append(this.includeAttributes).append('\n');
        result.append("\tincludeAlphaNum : ").append(this.includeAlphaNum).append('\n');
        if (this.includePath != null) {
            for (i = 0; i < this.includePath.length; ++i) {
                path = this.includePath[i];
                if (path == null) continue;
                result.append("\tinclude : ").append(path.toString()).append('\n');
            }
        }
        if (this.excludePath != null) {
            for (i = 0; i < this.excludePath.length; ++i) {
                path = this.excludePath[i];
                if (path == null) continue;
                result.append("\texclude : ").append(path.toString()).append('\n');
            }
        }
        if (this.preserveContent != null) {
            for (i = 0; i < this.preserveContent.length; ++i) {
                path = this.preserveContent[i];
                if (path == null) continue;
                result.append("\tpreserve content : ").append(path.toString()).append('\n');
            }
        }
        Iterator i2 = this.qnameSpecs.values().iterator();
        while (i2.hasNext()) {
            result.append("\tQName : ").append(i2.next()).append('\n');
        }
        return result.toString();
    }

    private static class QNameSpec
    implements Comparable {
        private QName qname;
        private boolean mixedContent = false;
        private Set preserve = new HashSet();

        QNameSpec(QName qname, Element node) {
            this.qname = qname;
            String attr = node.getAttribute(FulltextIndexSpec.CONTENT_ATTRIB);
            if (attr != null && attr.length() > 0) {
                this.mixedContent = FulltextIndexSpec.CONTENT_MIXED.equalsIgnoreCase(attr);
                if (!this.mixedContent && (attr = node.getAttribute("preserve")) != null && attr.length() > 0) {
                    StringTokenizer tok = new StringTokenizer(attr, ",;: \n\t");
                    while (tok.hasMoreTokens()) {
                        this.preserve.add(tok.nextToken());
                    }
                }
            }
        }

        public boolean hasMixedContent() {
            return this.mixedContent;
        }

        public Set getPreserve() {
            return this.preserve;
        }

        public boolean equals(Object obj) {
            return ((QNameSpec)obj).qname.equals(this.qname);
        }

        public int compareTo(Object other) {
            return ((QNameSpec)other).qname.compareTo(this.qname);
        }

        public String toString() {
            return this.qname.toString() + " [" + this.mixedContent + ']';
        }
    }
}

