/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.NativeClusterBroker;
import org.exist.util.Configuration;

public class BrokerFactory {
    public static final String PROPERTY_DATABASE = "database";

    public static DBBroker getInstance(BrokerPool pool, Configuration conf) throws EXistException {
        String dbName = (String)conf.getProperty(PROPERTY_DATABASE);
        if (dbName == null) {
            throw new RuntimeException("no database defined");
        }
        if (dbName.equalsIgnoreCase("NATIVE")) {
            return new NativeBroker(pool, conf);
        }
        if (dbName.equalsIgnoreCase("NATIVE_CLUSTER")) {
            return new NativeClusterBroker(pool, conf);
        }
        throw new EXistException("no database backend found for " + dbName);
    }
}

