/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.xacml.ExistPDP;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeType;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSecurityManager
implements SecurityManager {
    public static final String CONFIGURATION_ELEMENT_NAME = "default-permissions";
    public static final String COLLECTION_ATTRIBUTE = "collection";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String PROPERTY_PERMISSIONS_COLLECTIONS = "indexer.permissions.collection";
    public static final String PROPERTY_PERMISSIONS_RESOURCES = "indexer.permissions.resource";
    public static final String DBA_GROUP = "dba";
    public static final String DBA_USER = "admin";
    public static final String GUEST_GROUP = "guest";
    public static final String GUEST_USER = "guest";
    public static final User SYSTEM_USER = new User("admin", null, "dba");
    private static final Logger LOG = Logger.getLogger((Class)SecurityManager.class);
    private BrokerPool pool;
    private Int2ObjectHashMap groups = new Int2ObjectHashMap(65);
    private Int2ObjectHashMap users = new Int2ObjectHashMap(65);
    private int nextUserId = 0;
    private int nextGroupId = 0;
    private int defCollectionPermissions = 493;
    private int defResourcePermissions = 493;
    private ExistPDP pdp;

    public void attach(BrokerPool pool, DBBroker sysBroker) {
        Boolean enableXACML;
        DBBroker broker;
        block17: {
            this.pool = pool;
            TransactionManager transact = pool.getTransactionManager();
            Txn txn = null;
            broker = sysBroker;
            try {
                Collection sysCollection = broker.getCollection(XmldbURI.SYSTEM_COLLECTION_URI);
                if (sysCollection == null) {
                    txn = transact.beginTransaction();
                    sysCollection = broker.getOrCreateCollection(txn, XmldbURI.SYSTEM_COLLECTION_URI);
                    sysCollection.setPermissions(504);
                    broker.saveCollection(txn, sysCollection);
                    transact.commit(txn);
                }
                DocumentImpl acl = sysCollection.getDocument(broker, ACL_FILE_URI);
                Element docElement = null;
                if (acl != null) {
                    docElement = acl.getDocumentElement();
                }
                if (docElement == null) {
                    LOG.debug((Object)"creating system users");
                    User user = new User(DBA_USER, null);
                    user.addGroup(DBA_GROUP);
                    user.setUID(++this.nextUserId);
                    this.users.put(user.getUID(), user);
                    user = new User("guest", "guest", "guest");
                    user.setUID(++this.nextUserId);
                    this.users.put(user.getUID(), user);
                    this.newGroup(DBA_GROUP);
                    this.newGroup("guest");
                    txn = transact.beginTransaction();
                    this.save(broker, txn);
                    transact.commit(txn);
                    break block17;
                }
                LOG.debug((Object)"loading acl");
                Element root = acl.getDocumentElement();
                Attr version = root.getAttributeNode("version");
                int major = 0;
                int minor = 0;
                if (version != null) {
                    String[] numbers = version.getValue().split("\\.");
                    major = Integer.parseInt(numbers[0]);
                    minor = Integer.parseInt(numbers[1]);
                }
                NodeList nl = root.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node;
                    int j;
                    NodeList ul;
                    String lastId;
                    if (nl.item(i).getNodeType() != 1) continue;
                    Element next = (Element)nl.item(i);
                    if (next.getTagName().equals("users")) {
                        lastId = next.getAttribute("last-id");
                        try {
                            this.nextUserId = Integer.parseInt(lastId);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        ul = next.getChildNodes();
                        for (j = 0; j < ul.getLength(); ++j) {
                            node = ul.item(j);
                            if (node.getNodeType() != 1 || !node.getLocalName().equals("user")) continue;
                            User user = new User(major, minor, (Element)node);
                            this.users.put(user.getUID(), user);
                        }
                        continue;
                    }
                    if (!next.getTagName().equals("groups")) continue;
                    lastId = next.getAttribute("last-id");
                    try {
                        this.nextGroupId = Integer.parseInt(lastId);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    ul = next.getChildNodes();
                    for (j = 0; j < ul.getLength(); ++j) {
                        node = ul.item(j);
                        if (node.getNodeType() != 1 || !node.getLocalName().equals("group")) continue;
                        Group group = new Group((Element)node);
                        this.groups.put(group.getId(), group);
                    }
                }
            }
            catch (Exception e) {
                transact.abort(txn);
                e.printStackTrace();
                LOG.debug((Object)("loading acl failed: " + e.getMessage()));
            }
        }
        Integer defOpt = (Integer)broker.getConfiguration().getProperty(PROPERTY_PERMISSIONS_COLLECTIONS);
        if (defOpt != null) {
            this.defCollectionPermissions = defOpt;
        }
        if ((defOpt = (Integer)broker.getConfiguration().getProperty(PROPERTY_PERMISSIONS_RESOURCES)) != null) {
            this.defResourcePermissions = defOpt;
        }
        if ((enableXACML = (Boolean)broker.getConfiguration().getProperty("xacml.enable")) != null && enableXACML.booleanValue()) {
            this.pdp = new ExistPDP(pool);
            LOG.debug((Object)"XACML enabled");
        }
    }

    public boolean isXACMLEnabled() {
        return this.pdp != null;
    }

    public ExistPDP getPDP() {
        return this.pdp;
    }

    public synchronized void deleteUser(String name) throws PermissionDeniedException {
        this.deleteUser(this.getUser(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteUser(User user) throws PermissionDeniedException {
        if (user == null) {
            return;
        }
        if ((user = (User)this.users.remove(user.getUID())) != null) {
            LOG.debug((Object)("user " + user.getName() + " removed"));
        } else {
            LOG.debug((Object)"user not found");
        }
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(SYSTEM_USER);
            this.save(broker, txn);
            transact.commit(txn);
        }
        catch (EXistException e) {
            transact.abort(txn);
            e.printStackTrace();
        }
        finally {
            this.pool.release(broker);
        }
    }

    public synchronized User getUser(String name) {
        Iterator i = this.users.valueIterator();
        while (i.hasNext()) {
            User user = (User)i.next();
            if (!user.getName().equals(name)) continue;
            return user;
        }
        LOG.debug((Object)("user " + name + " not found"));
        return null;
    }

    public synchronized User getUser(int uid) {
        User user = (User)this.users.get(uid);
        if (user == null) {
            LOG.debug((Object)("user with uid " + uid + " not found"));
        }
        return user;
    }

    public synchronized User[] getUsers() {
        User[] u = new User[this.users.size()];
        int j = 0;
        Iterator i = this.users.valueIterator();
        while (i.hasNext()) {
            u[j] = (User)i.next();
            ++j;
        }
        return u;
    }

    protected void newGroup(String name) {
        Group group = new Group(name, ++this.nextGroupId);
        this.groups.put(group.getId(), group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addGroup(String name) {
        this.newGroup(name);
        DBBroker broker = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(SYSTEM_USER);
            this.save(broker, txn);
            transact.commit(txn);
        }
        catch (EXistException e) {
            transact.abort(txn);
            e.printStackTrace();
        }
        finally {
            this.pool.release(broker);
        }
    }

    public synchronized boolean hasGroup(String name) {
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            if (!group.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized Group getGroup(String name) {
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public synchronized Group getGroup(int gid) {
        return (Group)this.groups.get(gid);
    }

    public synchronized String[] getGroups() {
        ArrayList<String> list = new ArrayList<String>(this.groups.size());
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            list.add(group.getName());
        }
        String[] gl = new String[list.size()];
        list.toArray(gl);
        return gl;
    }

    public synchronized boolean hasAdminPrivileges(User user) {
        return user.hasDbaRole();
    }

    public synchronized boolean hasUser(String name) {
        Iterator i = this.users.valueIterator();
        while (i.hasNext()) {
            User user = (User)i.next();
            if (!user.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private synchronized void save(DBBroker broker, Txn transaction) throws EXistException {
        LOG.debug((Object)"storing acl file");
        StringBuffer buf = new StringBuffer();
        buf.append("<!-- Central user configuration. Editing this document will cause the security to reload and update its internal database. Please handle with care! -->");
        buf.append("<auth version='1.0'>");
        buf.append("<!-- Please do not remove the guest and admin groups -->");
        buf.append("<groups last-id=\"");
        buf.append(Integer.toString(this.nextGroupId));
        buf.append("\">");
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            buf.append(((Group)i.next()).toString());
        }
        buf.append("</groups>");
        buf.append("<!-- Please do not remove the admin user. -->");
        buf.append("<users last-id=\"");
        buf.append(Integer.toString(this.nextUserId));
        buf.append("\">");
        i = this.users.valueIterator();
        while (i.hasNext()) {
            buf.append(((User)i.next()).toString());
        }
        buf.append("</users>");
        buf.append("</auth>");
        broker.flush();
        broker.sync(1);
        try {
            broker.setUser(this.getUser(DBA_USER));
            Collection sysCollection = broker.getCollection(XmldbURI.SYSTEM_COLLECTION_URI);
            String data = buf.toString();
            IndexInfo info = sysCollection.validateXMLResource(transaction, broker, ACL_FILE_URI, data);
            DocumentImpl doc = info.getDocument();
            doc.getMetadata().setMimeType(MimeType.XML_TYPE.getName());
            sysCollection.store(transaction, broker, info, data, false);
            doc.setPermissions(504);
            broker.saveCollection(transaction, doc.getCollection());
        }
        catch (IOException e) {
            throw new EXistException(e.getMessage());
        }
        catch (SAXException e) {
            throw new EXistException(e.getMessage());
        }
        catch (PermissionDeniedException e) {
            throw new EXistException(e.getMessage());
        }
        catch (TriggerException e) {
            throw new EXistException(e.getMessage());
        }
        catch (LockException e) {
            throw new EXistException(e.getMessage());
        }
        broker.flush();
        broker.sync(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setUser(User user) {
        if (user.getUID() < 0) {
            user.setUID(++this.nextUserId);
        }
        this.users.put(user.getUID(), user);
        String[] groups = user.getGroups();
        if (groups.length == 0) {
            user.addGroup("guest");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (this.hasGroup(groups[i])) continue;
            this.newGroup(groups[i]);
        }
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.pool.get(SYSTEM_USER);
            this.save(broker, txn);
            this.createUserHome(broker, txn, user);
            transact.commit(txn);
        }
        catch (EXistException e) {
            transact.abort(txn);
            LOG.debug((Object)"error while creating user", (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(txn);
            LOG.debug((Object)"error while creating home collection", (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(txn);
            LOG.debug((Object)"error while creating home collection", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public int getResourceDefaultPerms() {
        return this.defResourcePermissions;
    }

    public int getCollectionDefaultPerms() {
        return this.defCollectionPermissions;
    }

    private void createUserHome(DBBroker broker, Txn transaction, User user) throws EXistException, PermissionDeniedException, IOException {
        if (user.getHome() == null) {
            return;
        }
        broker.setUser(this.getUser(DBA_USER));
        Collection home = broker.getOrCreateCollection(transaction, user.getHome());
        home.getPermissions().setOwner(user.getName());
        home.getPermissions().setGroup(user.getPrimaryGroup());
        broker.saveCollection(transaction, home);
    }
}

