/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

public class CollectionURI {
    public static final char FRAGMENT_SEPARATOR = '/';
    private char[] uri = null;
    private int length = 0;
    private int hash;

    public CollectionURI(String path) {
        this.append(path);
    }

    public CollectionURI(CollectionURI other) {
        this.uri = new char[other.uri.length];
        System.arraycopy(other.uri, 0, this.uri, 0, other.length);
        this.length = other.length;
        this.hash = other.hash;
    }

    public void append(String segment) {
        int startOffset = 0;
        if (segment.charAt(0) == '/') {
            startOffset = 1;
        }
        if (this.uri == null) {
            this.uri = new char[segment.length() + 1 - startOffset];
            this.uri[0] = 47;
            segment.getChars(startOffset, segment.length(), this.uri, 1);
        } else {
            char[] newURI = new char[this.length + 1 + segment.length() - startOffset];
            System.arraycopy(this.uri, 0, newURI, 0, this.length);
            newURI[this.length] = 47;
            segment.getChars(startOffset, segment.length(), newURI, this.length + 1);
            this.uri = newURI;
        }
        this.length += segment.length() + 1 - startOffset;
        this.hash = 0;
    }

    public void removeLastSegment() {
        char c;
        int pos = this.length - 1;
        while ((c = this.uri[pos]) != '/') {
            --pos;
        }
        this.length = pos;
        this.hash = 0;
    }

    public String toString() {
        return new String(this.uri, 0, this.length);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = 0;
            for (int i = 0; i < this.length; ++i) {
                h = 31 * h + this.uri[off++];
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionURI) {
            CollectionURI otherCollectionURI = (CollectionURI)object;
            if (this.length == otherCollectionURI.length) {
                int pos = this.length - 1;
                while (pos > -1) {
                    if (this.uri[pos] == otherCollectionURI.uri[pos--]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

