/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.util.ArrayList;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.model.GenericPropertyNode;

public class PlexOfCps {
    private int _count;
    private int _offset;
    private int _sizeOfStruct;
    private ArrayList _props;

    public PlexOfCps(int n) {
        this._props = new ArrayList();
        this._sizeOfStruct = n;
    }

    public PlexOfCps(byte[] byArray, int n, int n2, int n3) {
        this._count = (n2 - 4) / (4 + n3);
        this._sizeOfStruct = n3;
        this._props = new ArrayList(this._count);
        for (int i = 0; i < this._count; ++i) {
            this._props.add(this.getProperty(i, byArray, n));
        }
    }

    public GenericPropertyNode getProperty(int n) {
        return (GenericPropertyNode)this._props.get(n);
    }

    public void addProperty(GenericPropertyNode genericPropertyNode) {
        this._props.add(genericPropertyNode);
    }

    public byte[] toByteArray() {
        int n = this._props.size();
        int n2 = (n + 1) * 4;
        int n3 = this._sizeOfStruct * n;
        int n4 = n2 + n3;
        byte[] byArray = new byte[n4];
        GenericPropertyNode genericPropertyNode = null;
        for (int i = 0; i < n; ++i) {
            genericPropertyNode = (GenericPropertyNode)this._props.get(i);
            LittleEndian.putInt((byte[])byArray, (int)(4 * i), (int)genericPropertyNode.getStart());
            System.arraycopy(genericPropertyNode.getBytes(), 0, byArray, n2 + i * this._sizeOfStruct, this._sizeOfStruct);
        }
        LittleEndian.putInt((byte[])byArray, (int)(4 * n), (int)genericPropertyNode.getEnd());
        return byArray;
    }

    private GenericPropertyNode getProperty(int n, byte[] byArray, int n2) {
        int n3 = LittleEndian.getInt((byte[])byArray, (int)(n2 + this.getIntOffset(n)));
        int n4 = LittleEndian.getInt((byte[])byArray, (int)(n2 + this.getIntOffset(n + 1)));
        byte[] byArray2 = new byte[this._sizeOfStruct];
        System.arraycopy(byArray, n2 + this.getStructOffset(n), byArray2, 0, this._sizeOfStruct);
        return new GenericPropertyNode(n3, n4, byArray2);
    }

    private int getIntOffset(int n) {
        return n * 4;
    }

    public int length() {
        return this._props.size();
    }

    private int getStructOffset(int n) {
        return 4 * (this._count + 1) + this._sizeOfStruct * n;
    }
}

