/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.WordVersion;

public class WordExtractorFactory {
    byte[] _header;
    POIFSFileSystem _fsys;
    protected boolean _fastSaved;

    protected void initWordHeader(InputStream inputStream) throws IOException, PasswordProtectedException {
        this._fsys = new POIFSFileSystem(inputStream);
        DocumentEntry documentEntry = (DocumentEntry)this._fsys.getRoot().getEntry("WordDocument");
        DocumentInputStream documentInputStream = this._fsys.createDocumentInputStream("WordDocument");
        this._header = new byte[documentEntry.getSize()];
        documentInputStream.read(this._header);
        documentInputStream.close();
    }

    protected int getVersion() throws PasswordProtectedException {
        short s = LittleEndian.getShort((byte[])this._header, (int)10);
        boolean bl = this._fastSaved = (s & 4) != 0;
        if ((s & 0x100) != 0) {
            throw new PasswordProtectedException("This document is password protected");
        }
        short s2 = LittleEndian.getShort((byte[])this._header, (int)2);
        return WordVersion.getVersion(s2);
    }
}

