/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.sequence;

import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class SequenceSlicer {
    final EventSequence sequence1;
    final EventSequence sequence2;
    EventSequence start = null;
    EventSequence end = null;

    public SequenceSlicer(EventSequence eventSequence, EventSequence eventSequence2) {
        this.sequence1 = eventSequence;
        this.sequence2 = eventSequence2;
    }

    public void slice() throws IllegalStateException {
        this.sliceStart();
        this.sliceEnd();
    }

    public int sliceStart() throws IllegalStateException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        this.start = new EventSequence();
        int n = 0;
        int n2 = 0;
        EventSequence.EventIterator eventIterator = this.sequence1.eventIterator();
        EventSequence.EventIterator eventIterator2 = this.sequence2.eventIterator();
        int n3 = 0;
        while (eventIterator.hasNext() && eventIterator2.hasNext()) {
            DiffXEvent diffXEvent = (DiffXEvent)eventIterator.next();
            if (!eventIterator2.next().equals(diffXEvent)) break;
            ++n3;
            if (diffXEvent instanceof OpenElementEvent) {
                ++n2;
            } else if (diffXEvent instanceof CloseElementEvent) {
                --n2;
            }
            if (n2 != 1 && n2 != 0) continue;
            n = n3;
        }
        for (int i = 0; i < n; ++i) {
            DiffXEvent diffXEvent = this.sequence1.removeEvent(0);
            this.sequence2.removeEvent(0);
            this.start.addEvent(diffXEvent);
        }
        return n;
    }

    public int sliceEnd() throws IllegalStateException {
        int n;
        DiffXEvent diffXEvent;
        if (this.end != null) {
            throw new IllegalStateException("The end buffer already contains a subsequence.");
        }
        this.end = new EventSequence();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.sequence1.size() - 1;
        for (int i = this.sequence2.size() - 1; n5 >= 0 && i >= 0 && (diffXEvent = this.sequence1.getEvent(n5)).equals(this.sequence2.getEvent(i)); --n5, --i) {
            ++n4;
            if (diffXEvent instanceof CloseElementEvent) {
                ++n2;
            } else if (diffXEvent instanceof OpenElementEvent) {
                --n2;
            }
            if (n2 != 1 && n2 != 0) continue;
            n3 = n4;
        }
        int n6 = this.sequence1.size() - n3;
        for (n = this.sequence1.size() - 1; n >= n6; --n) {
            DiffXEvent diffXEvent2 = this.sequence1.removeEvent(n);
            this.end.addEvent(0, diffXEvent2);
        }
        n6 = this.sequence2.size() - n3;
        for (n = this.sequence2.size() - 1; n >= n6; --n) {
            this.sequence2.removeEvent(n);
        }
        return n3;
    }

    public void formatStart(DiffXFormatter diffXFormatter) throws NullPointerException, IOException {
        if (this.start == null) {
            return;
        }
        for (int i = 0; i < this.start.size(); ++i) {
            diffXFormatter.format(this.start.getEvent(i));
        }
        this.start = null;
    }

    public void formatEnd(DiffXFormatter diffXFormatter) throws NullPointerException, IOException {
        if (this.end == null) {
            return;
        }
        for (int i = 0; i < this.end.size(); ++i) {
            diffXFormatter.format(this.end.getEvent(i));
        }
        this.end = null;
    }

    public EventSequence getStart() {
        return this.start;
    }

    public EventSequence getEnd() {
        return this.end;
    }
}

