/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import java.io.FileNotFoundException;

public class SecondaryConfig
extends DatabaseConfig
implements Cloneable {
    public static final SecondaryConfig DEFAULT = new SecondaryConfig();
    private boolean allowPopulate;
    private boolean immutableSecondaryKey;
    private SecondaryKeyCreator keyCreator;
    private SecondaryMultiKeyCreator multiKeyCreator;

    static SecondaryConfig checkNull(SecondaryConfig config) {
        return config == null ? DEFAULT : config;
    }

    public SecondaryConfig() {
    }

    public void setAllowPopulate(boolean allowPopulate) {
        this.allowPopulate = allowPopulate;
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public void setImmutableSecondaryKey(boolean immutableSecondaryKey) {
        this.immutableSecondaryKey = immutableSecondaryKey;
    }

    public boolean getImmutableSecondaryKey() {
        return this.immutableSecondaryKey;
    }

    public void setKeyCreator(SecondaryKeyCreator keyCreator) {
        this.keyCreator = keyCreator;
    }

    public SecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public void setMultiKeyCreator(SecondaryMultiKeyCreator multiKeyCreator) {
        this.multiKeyCreator = multiKeyCreator;
    }

    public SecondaryMultiKeyCreator getMultiKeyCreator() {
        return this.multiKeyCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Db openSecondaryDatabase(DbEnv dbenv, DbTxn txn, String fileName, String databaseName, Db primary) throws DatabaseException, FileNotFoundException {
        int associateFlags = 0;
        associateFlags |= this.allowPopulate ? 1 : 0;
        if (this.getTransactional() && txn == null) {
            associateFlags |= 0x2000000;
        }
        if (this.immutableSecondaryKey) {
            associateFlags |= 0x4000;
        }
        Db db = super.openDatabase(dbenv, txn, fileName, databaseName);
        boolean succeeded = false;
        try {
            db.get_secmultikey_create(this.multiKeyCreator);
            primary.associate(txn, db, this.keyCreator, associateFlags);
            succeeded = true;
            Db db2 = db;
            return db2;
        }
        finally {
            if (!succeeded) {
                try {
                    db.close(0);
                }
                catch (Throwable t) {}
            }
        }
    }

    SecondaryConfig(Db db) throws DatabaseException {
        super(db);
        this.allowPopulate = false;
        this.keyCreator = db.get_seckey_create();
    }
}

