/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class DatabaseEntry {
    byte[] data;
    ByteBuffer data_nio;
    int dlen = 0;
    int doff = 0;
    int flags = 0;
    int offset = 0;
    int size = 0;
    int ulen = 0;
    static final DatabaseEntry IGNORE = new DatabaseEntry();
    static final DatabaseEntry UNUSED;
    static final int INT32SZ = 4;

    public DatabaseEntry() {
    }

    public DatabaseEntry(byte[] data) {
        this.data = data;
        if (data != null) {
            this.size = data.length;
        }
        this.data_nio = null;
    }

    public DatabaseEntry(byte[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
        this.data_nio = null;
    }

    public DatabaseEntry(ByteBuffer data) {
        this.data_nio = data;
        if (data != null) {
            this.size = this.ulen = data.limit();
            this.setUserBuffer(data.limit(), true);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public ByteBuffer getDataNIO() {
        return this.data_nio;
    }

    public void setData(byte[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
        this.data_nio = null;
    }

    public void setData(byte[] data) {
        this.setData(data, 0, data == null ? 0 : data.length);
    }

    public void setDataNIO(ByteBuffer data, int offset, int size) {
        this.data_nio = data;
        this.offset = offset;
        this.size = this.ulen = size;
        this.data = null;
        this.flags = 0;
        this.setUserBuffer(size, true);
    }

    public void setDataNIO(ByteBuffer data) {
        this.setDataNIO(data, 0, data == null ? 0 : data.capacity());
    }

    int getMultiFlag() {
        return 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public boolean getPartial() {
        return (this.flags & 0x20) != 0;
    }

    public void setPartialOffset(int doff) {
        this.doff = doff;
    }

    public void setPartialLength(int dlen) {
        this.dlen = dlen;
    }

    public void setPartial(boolean partial) {
        this.flags = partial ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public void setPartial(int doff, int dlen, boolean partial) {
        this.setPartialOffset(doff);
        this.setPartialLength(dlen);
        this.setPartial(partial);
    }

    public int getRecordNumber() {
        return DbUtil.array2int(this.data, this.offset);
    }

    public void setRecordNumber(int recno) {
        if (this.data == null || this.data.length < 4) {
            this.data = new byte[4];
            this.size = 4;
            this.ulen = 0;
            this.offset = 0;
        }
        DbUtil.int2array(recno, this.data, 0);
    }

    public boolean getReuseBuffer() {
        return 0 == (this.flags & 0x108);
    }

    public void setReuseBuffer(boolean reuse) {
        if (this.data_nio != null) {
            throw new IllegalArgumentException("Can only set the reuse flag on DatabaseEntry classes with a underlying byte[] data");
        }
        if (reuse) {
            this.flags &= 0xFFFFFEF7;
        } else {
            this.flags &= 0xFFFFFEFF;
            this.flags |= 8;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean getUserBuffer() {
        return (this.flags & 0x100) != 0;
    }

    public int getUserBufferLength() {
        return this.ulen;
    }

    public void setUserBuffer(int length, boolean usermem) {
        this.ulen = length;
        if (usermem) {
            this.flags &= 0xFFFFFFF7;
            this.flags |= 0x100;
        } else {
            this.flags &= 0xFFFFFEFF;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatabaseEntry)) {
            return false;
        }
        DatabaseEntry e = (DatabaseEntry)o;
        if ((this.getPartial() || e.getPartial()) && (this.getPartial() != e.getPartial() || this.dlen != e.dlen || this.doff != e.doff)) {
            return false;
        }
        if (this.data == null && e.data == null) {
            return true;
        }
        if (this.data == null || e.data == null) {
            return false;
        }
        if (this.size != e.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] == e.data[e.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        if (this.data != null) {
            for (int i = 0; i < this.size; ++i) {
                hash += this.data[this.offset + i];
            }
        }
        return hash;
    }

    static {
        IGNORE.setUserBuffer(0, true);
        IGNORE.setPartial(0, 0, true);
        UNUSED = new DatabaseEntry();
    }
}

