/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView mapView) {
        super(mapView);
    }

    public boolean add(Object mapEntry) {
        Map.Entry entry = (Map.Entry)mapEntry;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object mapEntry) {
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)mapEntry;
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.findBoth(entry.getKey(), entry.getValue(), true);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public boolean contains(Object mapEntry) {
        boolean bl;
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)mapEntry;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.findBoth(entry.getKey(), entry.getValue(), false);
            bl = status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        StoredIterator i = this.storedIterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (buf.length() > 1) {
                    buf.append(',');
                }
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key != null) {
                    buf.append(key.toString());
                }
                buf.append('=');
                if (val == null) continue;
                buf.append(val.toString());
            }
            buf.append(']');
            String string = buf.toString();
            return string;
        }
        finally {
            i.close();
        }
    }

    Object makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return new StoredMapEntry(this.view.makeKey(keyEntry, priKeyEntry), this.view.makeValue(priKeyEntry, valueEntry), this, iterator);
    }

    boolean hasValues() {
        return true;
    }
}

