/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.MetalEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabListPopup;
import org.netbeans.swing.tabcontrol.plaf.TabListPopupAction;

public final class MetalEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Rectangle scratch = new Rectangle();
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];

    public MetalEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new MetalEditorTabCellRenderer();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(80, 28);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = TabListPopup.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 9;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    protected int createRepaintPolicy() {
        return 164;
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 4, 57);
    }

    public void install() {
        super.install();
        this.displayer.setBackground(UIManager.getColor("control"));
    }

    protected void paintAfterTabs(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        graphics.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets insets = this.getTabAreaInsets();
        graphics.fillRect(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, this.displayer.getHeight() - (rectangle.y + rectangle.height));
        graphics.setColor(UIManager.getColor("controlHighlight"));
        int n = 0;
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 != -1) {
            this.getTabRect(n2, this.scratch);
            if (this.scratch.width != 0) {
                if (rectangle.x < this.scratch.x) {
                    graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, this.scratch.x - 1, this.displayer.getHeight() - insets.bottom);
                }
                if (this.scratch.x + this.scratch.width < rectangle.x + rectangle.width) {
                    n = this.scratch.x + this.scratch.width;
                    graphics.drawLine(n, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
                }
            } else {
                graphics.drawLine(0, this.displayer.getHeight() - insets.bottom, this.displayer.getWidth(), this.displayer.getHeight() - insets.bottom);
            }
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(n, this.displayer.getHeight() - 5, this.displayer.getWidth(), this.displayer.getHeight() - 5);
            return;
        }
        graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
        graphics.setColor(UIManager.getColor("controlDkShadow"));
        graphics.drawLine(0, this.displayer.getHeight() - 5, this.displayer.getWidth(), this.displayer.getHeight() - 5);
    }

    protected LayoutManager createLayout() {
        return new MetalTabLayout();
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] abstractButtonArray = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        MetalEditorTabDisplayerUI.configureButton(abstractButtonArray[0], new LeftIcon());
        MetalEditorTabDisplayerUI.configureButton(abstractButtonArray[1], new RightIcon());
        MetalEditorTabDisplayerUI.configureButton(abstractButtonArray[2], new DownIcon());
        abstractButtonArray[0].setPreferredSize(new Dimension(15, 17));
        abstractButtonArray[1].setPreferredSize(new Dimension(17, 17));
        abstractButtonArray[2].setPreferredSize(new Dimension(17, 17));
        abstractButtonArray[0].setBorder(new PartialEtchedBorder(false));
        abstractButtonArray[1].setBorder(new SpecEtchedBorder(true, true));
        abstractButtonArray[2].setBorder(new SpecEtchedBorder(true, true));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return abstractButtonArray;
    }

    private static void configureButton(JButton jButton, Icon icon) {
        jButton.setIcon(icon);
        jButton.setMargin(null);
        jButton.setText(null);
        jButton.putClientProperty("hideActionText", Boolean.TRUE);
        jButton.setFocusable(false);
    }

    private static class SpecEtchedBorder
    implements Border {
        private boolean fillRight;
        private boolean fillLeft;

        public SpecEtchedBorder(boolean bl, boolean bl2) {
            this.fillRight = bl;
            this.fillLeft = bl2;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.drawLine(this.fillLeft ? n + 1 : n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - (this.fillRight ? 0 : 3));
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(n, n2, n + n3 + (this.fillRight ? -2 : -1), n2);
            graphics.drawLine(n, n2 + (this.fillLeft ? 1 : 2), n, n2 + n4 - (this.fillLeft ? 2 : 3));
            graphics.drawLine(n + 2, n2 + n4 - 2, n + n3 - (this.fillRight ? 2 : 3), n2 + n4 - 2);
            graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 2);
        }
    }

    private static class PartialEtchedBorder
    implements Border {
        private boolean leftSide = false;

        public PartialEtchedBorder(boolean bl) {
            this.leftSide = bl;
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(2, this.leftSide ? 0 : 2, 2, this.leftSide ? 2 : 0);
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(this.leftSide ? n : n + 1, n2 + 1, this.leftSide ? n + n3 - 3 : n + n3 - 1, n2 + 1);
            graphics.drawLine(this.leftSide ? n : n + 1, n2 + --n4, n + n3, n2 + n4);
            if (this.leftSide) {
                graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4);
            } else {
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
            }
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(n, n2, this.leftSide ? n + n3 - 2 : n + n3 - 1, n2);
            graphics.drawLine(this.leftSide ? n : n + 2, n2 + n4 - 1, this.leftSide ? n + n3 - 2 : n + n3, n2 + n4 - 1);
            if (this.leftSide) {
                graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 2);
            } else {
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
            }
        }
    }

    private static class DownIcon
    extends LeftIcon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 14;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            n2 -= 2;
            ++n;
            int n3 = this.getIconWidth() - 2;
            if (n3 % 2 == 0) {
                --n3;
            }
            int n4 = this.getIconHeight();
            xpoints[0] = n + 1;
            ypoints[0] = n2 + n4 / 2;
            xpoints[1] = n + n3 - 1;
            ypoints[1] = ypoints[0];
            xpoints[2] = n + n3;
            ypoints[2] = ypoints[0];
            xpoints[3] = n + n3 / 2;
            ypoints[3] = n2 + n4 - 1;
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            graphics.fillPolygon(xpoints, ypoints, 4);
        }
    }

    private static class RightIcon
    extends LeftIcon {
        private RightIcon() {
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight() + 1;
            xpoints[0] = n + 3;
            ypoints[0] = (n2 -= 2) + 1;
            xpoints[1] = n + 3;
            ypoints[1] = n2 + n4 + 1;
            xpoints[2] = n + (n3 - 4) + 1;
            ypoints[2] = n2 + n4 / 2 + 1;
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        private LeftIcon() {
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight() + 1;
            xpoints[0] = n + (n3 - 4);
            ypoints[0] = (n2 -= 2) + 1;
            xpoints[1] = xpoints[0];
            ypoints[1] = n2 + n4 + 1;
            xpoints[2] = n + 2;
            ypoints[2] = n2 + n4 / 2 + 1;
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private class MetalTabLayout
    implements LayoutManager {
        private MetalTabLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Insets insets = MetalEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] componentArray = container.getComponents();
            int n = container.getWidth() - insets.right + 3;
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                n2 = insets.top + 3;
                int n3 = Math.min(dimension.width, container.getWidth() - n);
                componentArray[i].setBounds(n, n2, n3, Math.min(dimension.height, container.getHeight()));
                n += dimension.width;
                if (i != 1) continue;
                n += 3;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return MetalEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return MetalEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

