/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.openide.awt.HtmlRenderer;

public final class AquaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();
    private Rectangle pinButtonRect = new Rectangle();
    private static final ChicletWrapper chiclet = new ChicletWrapper();
    private boolean containsMouse = false;

    private AquaViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(Integer.MAX_VALUE, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    protected void installPinButton() {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 21 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 2;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Color color = jComponent.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        ColorUtil.setupAntialiasing(graphics);
        super.paint(graphics, jComponent);
        this.paintBottomBorder(graphics, jComponent);
    }

    private void paintBottomBorder(Graphics graphics, JComponent jComponent) {
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        Object var9_9 = null;
        graphics.setFont(this.getTxtFont());
        int n9 = n4;
        if (this.isContainsMouse()) {
            int n10;
            n8 = 5;
            n7 = 5;
            n6 = n7 > n5 ? -1 * ((n7 - n5) / 2) : n5 / 2 - n7 / 2;
            int n11 = 2;
            int n12 = n2 + n4 - (n8 + n11);
            if (n == this.getDataModel().size() - 1) {
                n12 -= 3;
                n9 -= 3;
            }
            graphics.setColor(this.isSelected(n) && this.isActive() ? new Color(80, 80, 123) : new Color(110, 120, 120));
            graphics.drawLine(n12 -= 2, n6 -= 2, n12 + n8, n6 + n7);
            graphics.drawLine(n12, n6 + n7, n12 + n8, n6);
            graphics.drawLine(n12, ++n6, n12 + n8, n6 + n7);
            graphics.drawLine(n12, n6 + n7, n12 + n8, n6);
            AbstractViewTabDisplayerUI.PinButton pinButton = this.getPinButton(n);
            int n13 = n10 = pinButton != null ? pinButton.getWidth() + 1 : 0;
            if (pinButton != null && this.isSelected(n)) {
                Icon icon = pinButton.getIcon();
                this.pinButtonRect.setBounds(n12 - n10, n6 - 4, icon.getIconWidth(), icon.getIconHeight());
                if (icon != null) {
                    icon.paintIcon(this.displayer, graphics, this.pinButtonRect.x, this.pinButtonRect.y);
                }
            }
            n9 -= n8 + 7 + n10;
        }
        if (string.length() == 0) {
            return;
        }
        n8 = fontMetrics.getHeight();
        n6 = n2 + 5;
        n7 = n8 > n5 ? -1 * ((n8 - n5) / 2) + fontMetrics.getAscent() - 1 : n5 / 2 - n8 / 2 + fontMetrics.getAscent() - 1;
        HtmlRenderer.renderString(string, graphics, n6, n7, n9 -= 5, n5, this.getTxtFont(), UIManager.getColor("textText"), 1, true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = n == 0;
        boolean bl2 = n == this.getDataModel().size() - 1;
        int n6 = 0;
        if (this.isActive()) {
            n6 |= 4;
        }
        if (this.isSelected(n)) {
            n6 |= 2;
        }
        chiclet.setState(n6);
        chiclet.setBounds(n2, n3, n4, n5);
        chiclet.setArcs(bl ? 0.5f : 0.0f, bl2 ? 0.5f : 0.0f, bl ? 0.0f : 0.0f, bl2 ? 0.0f : 0.0f);
        chiclet.setNotch(false, false);
        graphics.translate(n2, n3);
        chiclet.draw((Graphics2D)graphics);
        graphics.translate(-n2, -n3);
    }

    private Rectangle getCloseIconRect(Rectangle rectangle, int n) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        Object var4_4 = null;
        int n2 = this.getLayoutModel().getW(n);
        int n3 = this.getLayoutModel().getX(n);
        int n4 = this.getLayoutModel().getH(n);
        int n5 = 5;
        int n6 = 5;
        int n7 = n6 > n4 ? -1 * ((n6 - n4) / 2) : n4 / 2 - n6 / 2 - 1;
        int n8 = 2;
        int n9 = n3 + n2 - (n5 + n8);
        if (n == this.getDataModel().size() - 1) {
            n9 -= 3;
        }
        rectangle.x = n9;
        rectangle.y = n7;
        rectangle.width = 5;
        rectangle.height = 5;
        return rectangle;
    }

    private void setContainsMouse(boolean bl) {
        if (bl != this.containsMouse) {
            this.containsMouse = bl;
            this.getDisplayer().repaint();
        }
    }

    private boolean isContainsMouse() {
        return this.containsMouse;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        return super.createPinButton();
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            int n = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n < 0) {
                return -1;
            }
            Rectangle rectangle = AquaViewTabDisplayerUI.this.getCloseIconRect(AquaViewTabDisplayerUI.this.tempRect, n);
            rectangle.width += 6;
            rectangle.height += 6;
            rectangle.x -= 3;
            rectangle.y -= 3;
            int n2 = rectangle.contains(point) ? n : -1;
            return n2;
        }

        private boolean inPinButtonRect(Point point) {
            return AquaViewTabDisplayerUI.this.pinButtonRect.contains(point);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            int n2 = this.inCloseIconRect(point);
            if (n != -1 && n2 == -1) {
                AquaViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(n);
            }
            if (this.shouldReact(mouseEvent) && n2 != -1) {
                this.setClosePressed(n2);
                return;
            }
            if (AquaViewTabDisplayerUI.this.pinButton != null && this.inPinButtonRect(point)) {
                AquaViewTabDisplayerUI.this.performPinAction();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.shouldReact(mouseEvent)) {
                int n = this.isClosePressed();
                this.setClosePressed(-1);
                Point point = mouseEvent.getPoint();
                if (this.inCloseIconRect(point) >= 0) {
                    int n2 = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
                    if (n2 == n) {
                        this.performAction(mouseEvent);
                    }
                    this.setMouseInCloseButton(point);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AquaViewTabDisplayerUI.this.setContainsMouse(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AquaViewTabDisplayerUI.this.setContainsMouse(false);
        }
    }
}

