/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class NamespaceUriFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 0) {
            return NamespaceUriFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (list.size() == 1) {
            return NamespaceUriFunction.evaluate(list, context.getNavigator());
        }
        throw new FunctionCallException("namespace-uri() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator navigator) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object e = list.get(0);
            if (e instanceof List) {
                return NamespaceUriFunction.evaluate((List)e, navigator);
            }
            if (navigator.isElement(e)) {
                return navigator.getElementNamespaceUri(e);
            }
            if (navigator.isAttribute(e)) {
                String string = navigator.getAttributeNamespaceUri(e);
                if (string == null) {
                    return "";
                }
                return string;
            }
            if (navigator.isProcessingInstruction(e)) {
                return "";
            }
            if (navigator.isNamespace(e)) {
                return "";
            }
            if (navigator.isDocument(e)) {
                return "";
            }
            if (navigator.isComment(e)) {
                return "";
            }
            if (navigator.isText(e)) {
                return "";
            }
            throw new FunctionCallException("The argument to the namespace-uri function must be a node-set");
        }
        return "";
    }
}

