/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;

public class FtpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final FtpFileSystemConfigBuilder builder = new FtpFileSystemConfigBuilder();
    private static final String FACTORY_KEY = FTPFileEntryParserFactory.class.getName() + ".KEY";
    private static final String PASSIVE_MODE = FtpFileSystemConfigBuilder.class.getName() + ".PASSIVE";
    private static final String USER_DIR_IS_ROOT = FtpFileSystemConfigBuilder.class.getName() + ".USER_DIR_IS_ROOT";
    private static final String DATA_TIMEOUT = FtpFileSystemConfigBuilder.class.getName() + ".DATA_TIMEOUT";
    private static final String SERVER_LANGUAGE_CODE = FtpFileSystemConfigBuilder.class.getName() + ".SERVER_LANGUAGE_CODE";
    private static final String DEFAULT_DATE_FORMAT = FtpFileSystemConfigBuilder.class.getName() + ".DEFAULT_DATE_FORMAT";
    private static final String RECENT_DATE_FORMAT = FtpFileSystemConfigBuilder.class.getName() + ".RECENT_DATE_FORMAT";
    private static final String SERVER_TIME_ZONE_ID = FtpFileSystemConfigBuilder.class.getName() + ".SERVER_TIME_ZONE_ID";
    private static final String SHORT_MONTH_NAMES = FtpFileSystemConfigBuilder.class.getName() + ".SHORT_MONTH_NAMES";

    public static FtpFileSystemConfigBuilder getInstance() {
        return builder;
    }

    private FtpFileSystemConfigBuilder() {
    }

    public void setEntryParserFactory(FileSystemOptions fileSystemOptions, FTPFileEntryParserFactory fTPFileEntryParserFactory) {
        this.setParam(fileSystemOptions, FTPFileEntryParserFactory.class.getName(), fTPFileEntryParserFactory);
    }

    public FTPFileEntryParserFactory getEntryParserFactory(FileSystemOptions fileSystemOptions) {
        return (FTPFileEntryParserFactory)this.getParam(fileSystemOptions, FTPFileEntryParserFactory.class.getName());
    }

    public void setEntryParser(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, FACTORY_KEY, string);
    }

    public String getEntryParser(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, FACTORY_KEY);
    }

    protected Class getConfigClass() {
        return FtpFileSystem.class;
    }

    public void setPassiveMode(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, PASSIVE_MODE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getPassiveMode(FileSystemOptions fileSystemOptions) {
        return (Boolean)this.getParam(fileSystemOptions, PASSIVE_MODE);
    }

    public void setUserDirIsRoot(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, USER_DIR_IS_ROOT, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions fileSystemOptions) {
        return (Boolean)this.getParam(fileSystemOptions, USER_DIR_IS_ROOT);
    }

    public Integer getDataTimeout(FileSystemOptions fileSystemOptions) {
        return (Integer)this.getParam(fileSystemOptions, DATA_TIMEOUT);
    }

    public void setDataTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, DATA_TIMEOUT, n);
    }

    public String getServerLanguageCode(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, SERVER_LANGUAGE_CODE);
    }

    public void setServerLanguageCode(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, SERVER_LANGUAGE_CODE, string);
    }

    public String getDefaultDateFormat(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, DEFAULT_DATE_FORMAT);
    }

    public void setDefaultDateFormat(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, DEFAULT_DATE_FORMAT, string);
    }

    public String getRecentDateFormat(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, RECENT_DATE_FORMAT);
    }

    public void setRecentDateFormat(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, RECENT_DATE_FORMAT, string);
    }

    public String getServerTimeZoneId(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, SERVER_TIME_ZONE_ID);
    }

    public void setServerTimeZoneId(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, SERVER_TIME_ZONE_ID, string);
    }

    public String[] getShortMonthNames(FileSystemOptions fileSystemOptions) {
        return (String[])this.getParam(fileSystemOptions, SHORT_MONTH_NAMES);
    }

    public void setShortMonthNames(FileSystemOptions fileSystemOptions, String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        this.setParam(fileSystemOptions, SHORT_MONTH_NAMES, stringArray2);
    }
}

