/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

final class PlasticXPBorders {
    private static Border buttonBorder;
    private static Border comboBoxArrowButtonBorder;
    private static Border comboBoxEditorBorder;
    private static Border scrollPaneBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new XPButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    static Border getComboBoxArrowButtonBorder() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new XPComboBoxArrowButtonBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new XPComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new XPScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new XPTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new XPButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    private static class XPScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPScrollPaneBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticXPUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = XPScrollPaneBorder.INSETS.top;
            insets.left = XPScrollPaneBorder.INSETS.left;
            insets.bottom = XPScrollPaneBorder.INSETS.bottom;
            insets.right = XPScrollPaneBorder.INSETS.right;
            return insets;
        }
    }

    private static class XPTextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPTextFieldBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = component instanceof JTextComponent && component.isEnabled() && ((JTextComponent)component).isEditable() || component.isEnabled();
            graphics.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticXPUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = XPTextFieldBorder.INSETS.top;
            insets.left = XPTextFieldBorder.INSETS.left;
            insets.bottom = XPTextFieldBorder.INSETS.bottom;
            insets.right = XPTextFieldBorder.INSETS.right;
            return insets;
        }
    }

    private static class XPComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 0);

        private XPComboBoxEditorBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticXPUtils.drawRect(graphics, n, n2, n3 + 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static class XPComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(1, 1, 1, 1);

        private XPComboBoxArrowButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)component;
            JComboBox jComboBox = plasticComboBoxButton.getComboBox();
            ButtonModel buttonModel = plasticComboBoxButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticXPUtils.drawDisabledButtonBorder(graphics, n, n2, n3, n4);
            } else {
                boolean bl = buttonModel.isPressed() && buttonModel.isArmed();
                boolean bl2 = jComboBox.hasFocus();
                if (bl) {
                    PlasticXPUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
                } else if (bl2) {
                    PlasticXPUtils.drawFocusedButtonBorder(graphics, n, n2, n3, n4);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
                }
            }
            if (jComboBox.isEditable()) {
                graphics.setColor(buttonModel.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n, n2, 1, 1);
                graphics.fillRect(n, n2 + n4 - 1, 1, 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static class XPButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = LookUtils.IS_LOW_RESOLUTION ? new Insets(3, 2, 3, 2) : new Insets(2, 2, 2, 2);

        private XPButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticXPUtils.drawDisabledButtonBorder(graphics, n, n2, n3, n4);
                return;
            }
            boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl3 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
            boolean bl4 = bl = abstractButton.isFocusPainted() && abstractButton.hasFocus();
            if (bl2) {
                PlasticXPUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl) {
                PlasticXPUtils.drawFocusedButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl3) {
                PlasticXPUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = XPButtonBorder.INSETS.top;
            insets.left = XPButtonBorder.INSETS.left;
            insets.bottom = XPButtonBorder.INSETS.bottom;
            insets.right = XPButtonBorder.INSETS.right;
            return insets;
        }
    }
}

