/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath;

public class FastVector {
    Object[] elementData;
    int elementCount;
    int capacityIncrement;

    public FastVector(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public FastVector(int n) {
        this(n, 0);
    }

    public FastVector() {
        this(5);
    }

    public final boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(Object object, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public final void ensureCapacity(int n) {
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new Object[n2];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public final int size() {
        return this.elementCount;
    }

    public final int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public final int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final Object get(int n) {
        return this.elementData[n];
    }

    public final Object elementAt(int n) {
        return this.elementData[n];
    }

    public final boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public final void addElement(Object object) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = object;
    }
}

