/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.ComponentFactory;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.helper.model.AbstractDescriptor;
import com.japisoft.xmlpad.helper.model.CommonDescriptorRenderer;
import com.japisoft.xmlpad.helper.model.Descriptor;
import com.japisoft.xmlpad.helper.ui.TitledPanelHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class ContentAssistantUI
implements FocusListener,
MouseListener,
ListSelectionListener,
KeyListener {
    private XMLEditor currentEditor = null;
    private int currentOffset;
    private String currentActivatorString = null;
    private JPanel panel = null;
    private CustomList list = null;
    private TitledPanelHelper label = null;
    private HelpPanel helpPanel = null;
    private AdaptingListModel listModel = null;

    public void show(String string, XMLEditor xMLEditor, int n, String string2, ArrayList arrayList) {
        try {
            Rectangle rectangle = xMLEditor.modelToView(n);
            int n2 = rectangle.x;
            int n3 = rectangle.y + rectangle.height;
            Point point = xMLEditor.getLocationOnScreen();
            this.panel = this.getPanel(string, arrayList);
            this.currentActivatorString = string2;
            this.currentEditor = xMLEditor;
            this.currentOffset = n;
            xMLEditor.add(this.panel);
            int n4 = (Integer)xMLEditor.getXMLContainer().getProperty("dxHelper", new Integer(0));
            int n5 = (Integer)xMLEditor.getXMLContainer().getProperty("dyHelper", new Integer(0));
            int n6 = this.list.getFontMetrics(this.list.getFont()).getHeight();
            int n7 = this.panel.getPreferredSize().height;
            n7 += n5 + Math.min(8, arrayList.size()) * n6;
            this.panel.setSize(this.list.getPreferredSize().width + 25 + n4, this.panel.getPreferredSize().height);
            if (this.panel.getWidth() < 5 && this.panel.getHeight() < 5) {
                this.panel.setSize(this.list.getPreferredSize().width + 30, 100);
            }
            int n8 = n3;
            n2 += xMLEditor.getFontMetrics(xMLEditor.getFont()).charWidth(' ');
            rectangle = xMLEditor.getVisibleRect();
            if (this.panel.getHeight() + n8 > rectangle.y + rectangle.height) {
                n8 = rectangle.y + rectangle.height - this.panel.getHeight();
            }
            if (this.panel.getWidth() + n2 > rectangle.x + rectangle.width) {
                n2 = rectangle.x + rectangle.width - this.panel.getWidth();
            }
            this.panel.setLocation(n2, n8);
            xMLEditor.invalidate();
            xMLEditor.validate();
            xMLEditor.repaint();
            this.disposeHelpPanel();
            this.selectTheFirst();
            this.panel.setVisible(true);
            this.list.requestFocus();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void selectTheFirst() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = 0;
                for (int i = 0; i < ContentAssistantUI.this.list.getModel().getSize(); ++i) {
                    Descriptor descriptor = (Descriptor)ContentAssistantUI.this.list.getModel().getElementAt(i);
                    if (!descriptor.isEnabled()) continue;
                    n = i;
                    break;
                }
                ContentAssistantUI.this.list.setSelectedIndex(n);
            }
        });
    }

    private void showHelpPanel(String string) {
        if (!SharedProperties.HELPER_PANEL) {
            return;
        }
        if (this.helpPanel == null) {
            this.helpPanel = new HelpPanel();
            this.helpPanel.setSize(200, this.panel.getHeight());
            if (this.currentEditor == null) {
                Debug.debug("Wrong state for the ContentAssistantUI : no current editor for help");
                return;
            }
            Rectangle rectangle = this.currentEditor.getVisibleRect();
            int n = 0;
            int n2 = this.panel.getY();
            n = this.panel.getX() + this.panel.getWidth() + 5 + this.helpPanel.getWidth() > rectangle.width ? this.panel.getX() - this.helpPanel.getWidth() - 5 : this.panel.getX() + this.panel.getWidth() + 5;
            if (n < 0) {
                this.helpPanel.setSize(this.helpPanel.getWidth() - Math.abs(n), this.helpPanel.getHeight());
                if (this.helpPanel.getWidth() < 50) {
                    return;
                }
                n = 0;
            }
            this.helpPanel.setLocation(n, n2);
            this.currentEditor.add(this.helpPanel);
            this.currentEditor.invalidate();
            this.currentEditor.validate();
            this.currentEditor.repaint();
        }
        this.helpPanel.updateComment(string);
        this.helpPanel.setVisible(true);
    }

    private void hideHelpPanel() {
        if (!SharedProperties.HELPER_PANEL) {
            return;
        }
        if (this.helpPanel != null) {
            this.helpPanel.setVisible(false);
        }
    }

    private JPanel getPanel(String string, ArrayList arrayList) {
        if (this.panel == null) {
            Font font;
            String string2;
            Color color;
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.list = new CustomList();
            this.list.setCellRenderer(CommonDescriptorRenderer.getRenderer());
            this.panel.add(new JScrollPane(this.list));
            this.label = ComponentFactory.getFactory().getNewTitledPanelHelper();
            this.panel.add((Component)this.label.getView(), "North");
            TitledPanelHelper titledPanelHelper = ComponentFactory.getFactory().getNewFooterPanelHelper();
            if (titledPanelHelper != null) {
                this.panel.add((Component)titledPanelHelper.getView(), "South");
            }
            if ((color = UIManager.getColor((string2 = "xmlpad.helper.") + "backgroundColor")) != null) {
                this.list.setBackground(color);
            }
            if ((color = UIManager.getColor(string2 + "foregroundColor")) != null) {
                this.list.setForeground(color);
            }
            if ((color = UIManager.getColor(string2 + "selectionBackgroundColor")) != null) {
                this.list.setSelectionBackground(color);
            }
            if ((color = UIManager.getColor(string2 + "selectionForegroundColor")) != null) {
                this.list.setSelectionForeground(color);
            }
            if ((font = UIManager.getFont(string2 + "font")) != null) {
                this.list.setFont(font);
            } else {
                font = this.list.getFont();
            }
            this.label.getView().setFont(new Font(font.getName(), 2, font.getSize()));
            this.label.getView().setOpaque(true);
            this.label.getView().setBackground(this.list.getSelectionBackground());
            this.label.getView().setForeground(this.list.getSelectionForeground());
            this.label.getView().setBorder(new EtchedBorder(this.list.getSelectionForeground(), this.list.getSelectionBackground()));
            this.list.setCellRenderer(CommonDescriptorRenderer.getRenderer());
            this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "itemSelection");
            this.list.getActionMap().put("itemSelection", new SelectionAction());
            this.list.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "noSelection");
            this.list.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "noSelection");
            this.list.getActionMap().put("noSelection", new NoSelectionAction());
            this.list.addFocusListener(this);
            this.list.addMouseListener(this);
            this.list.addListSelectionListener(this);
            this.list.addKeyListener(this);
        }
        this.label.setTitle(string);
        this.listModel = new AdaptingListModel();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.listModel.addElement(arrayList.get(i));
        }
        this.list.setVisibleRowCount(Math.min(8, arrayList.size()));
        this.list.setModel(this.listModel);
        this.panel.setVisible(false);
        this.list.requestFocus();
        return this.panel;
    }

    public void dispose() {
        this.removePanel();
        this.list.getActionMap().remove("itemSelection");
        this.list.getActionMap().remove("noSelection");
        this.list.removeFocusListener(this);
        this.list.removeMouseListener(this);
        this.list.removeListSelectionListener(this);
        this.list.removeKeyListener(this);
        this.list = null;
        this.panel = null;
        this.label = null;
        this.listModel = null;
        this.disposeHelpPanel();
    }

    public void disposeHelpPanel() {
        this.helpPanel = null;
    }

    public void removePanel() {
        if (this.currentEditor != null) {
            this.currentEditor.remove(this.panel);
            if (this.helpPanel != null) {
                this.currentEditor.remove(this.helpPanel);
            }
            this.currentEditor.invalidate();
            this.currentEditor.validate();
            this.currentEditor.repaint();
            this.currentEditor.requestFocus();
        }
        this.disposeDescriptors();
        this.currentEditor = null;
    }

    private void disposeDescriptors() {
        for (int i = 0; i < this.listModel.size(); ++i) {
            ((Descriptor)this.listModel.get(i)).dispose();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.list) {
            this.removePanel();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.list.getActionMap().get("itemSelection").actionPerformed(null);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '+' && keyEvent.isControlDown()) {
            this.panel.setSize(this.panel.getWidth(), this.panel.getHeight() + 20);
            this.panel.invalidate();
            this.panel.validate();
            this.panel.repaint();
            Integer n = (Integer)this.currentEditor.getXMLContainer().getProperty("dyHelper", new Integer(0));
            this.currentEditor.getXMLContainer().setProperty("dyHelper", new Integer(n + 20));
            return;
        }
        if (keyEvent.getKeyChar() == '-' && keyEvent.isControlDown()) {
            this.panel.setSize(this.panel.getWidth(), Math.max(20, this.panel.getHeight() - 20));
            this.panel.invalidate();
            this.panel.validate();
            this.panel.repaint();
            Integer n = (Integer)this.currentEditor.getXMLContainer().getProperty("dyHelper", new Integer(0));
            this.currentEditor.getXMLContainer().setProperty("dyHelper", new Integer(n - 20));
            return;
        }
        if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 65483 || keyEvent.getKeyCode() == 12 || keyEvent.getKeyCode() == 8) {
            this.listModel.removingLastFilteringChar();
            this.selectTheFirst();
        } else if (keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 38 && (keyEvent.getKeyCode() > 40 || keyEvent.getKeyChar() == ':')) {
            this.listModel.addFilteringChar(keyEvent.getKeyChar());
            this.selectTheFirst();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    class HelpPanel
    extends JPanel {
        JTextArea ta;

        HelpPanel() {
            this.setLayout(new BorderLayout());
            this.ta = new JTextArea();
            this.ta.setWrapStyleWord(true);
            this.ta.setLineWrap(true);
            this.ta.setBackground(new Color(250, 252, 199));
            this.ta.setForeground(Color.BLACK);
            this.ta.setEditable(false);
            this.add(this.ta);
            this.setBorder(new LineBorder(Color.black));
        }

        public void updateComment(String string) {
            this.ta.setText(string);
        }
    }

    class CustomList
    extends JList {
        CustomList() {
        }

        public void setSelectedIndex(int n) {
            super.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
            int n2 = ContentAssistantUI.this.list.getSelectedIndex();
            Descriptor descriptor = (Descriptor)ContentAssistantUI.this.list.getModel().getElementAt(n2);
            if (descriptor != null && descriptor.getComment() != null) {
                ContentAssistantUI.this.showHelpPanel(descriptor.getComment());
            } else {
                ContentAssistantUI.this.hideHelpPanel();
            }
        }
    }

    class SelectionAction
    extends AbstractAction {
        SelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object;
            Object object2;
            Descriptor descriptor = (Descriptor)ContentAssistantUI.this.list.getSelectedValue();
            if (descriptor instanceof AbstractDescriptor && ((AbstractDescriptor)(object2 = (AbstractDescriptor)descriptor)).getSpecificAction() != null) {
                ((AbstractDescriptor)object2).getSpecificAction().putValue("descriptor", object2);
                object = ContentAssistantUI.this.currentEditor;
                ((AbstractDescriptor)object2).getSpecificAction().actionPerformed(actionEvent);
                ContentAssistantUI.this.currentEditor = (XMLEditor)object;
                if (((AbstractDescriptor)object2).getSpecificAction().getValue("descriptor") != null) {
                    descriptor = (Descriptor)((AbstractDescriptor)object2).getSpecificAction().getValue("descriptor");
                }
            }
            object2 = ContentAssistantUI.this.currentEditor.getXMLContainer().getCurrentElementNode();
            if (descriptor != null) {
                object = descriptor.toExternalForm();
                n = ((String)object).indexOf(164);
                if (n > -1) {
                    object = ((String)object).replaceAll("\u00a4", "");
                }
                if (descriptor.getSource() != null && descriptor.getSource().hasDelegateForInsertingResult()) {
                    descriptor.getSource().insertResult(ContentAssistantUI.this.currentEditor.getXMLDocument(), ContentAssistantUI.this.currentOffset, (String)object);
                } else {
                    ContentAssistantUI.this.currentEditor.getXMLDocument().insertStringWithoutHelper(ContentAssistantUI.this.currentOffset, (String)object, null);
                }
                int n2 = ContentAssistantUI.this.currentOffset + ((String)object).length();
                if (n == -1) {
                    for (int i = 0; i < ((String)object).length(); ++i) {
                        if (!Character.isWhitespace(((String)object).charAt(i))) continue;
                        n2 = ContentAssistantUI.this.currentOffset + i;
                        break;
                    }
                } else {
                    n2 = ContentAssistantUI.this.currentOffset + n;
                }
                ContentAssistantUI.this.currentEditor.setCaretPosition(n2);
            }
            object = ContentAssistantUI.this.currentEditor.getXMLContainer().getHelperManager();
            n = ContentAssistantUI.this.currentEditor.getCaretPosition();
            XMLDocument xMLDocument = ContentAssistantUI.this.currentEditor.getXMLDocument();
            ContentAssistantUI.this.removePanel();
            if (descriptor != null && descriptor.hasAutomaticNextHelper()) {
                ContentAssistantUI.this.panel = null;
                xMLDocument.manageCompletion((SimpleNode)object2, true, n, null);
            }
        }
    }

    class NoSelectionAction
    extends AbstractAction {
        NoSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContentAssistantUI.this.currentEditor.getXMLDocument().insertStringWithoutHelper(ContentAssistantUI.this.currentOffset, ContentAssistantUI.this.currentActivatorString, null);
            ContentAssistantUI.this.removePanel();
        }
    }

    class AdaptingListModel
    extends DefaultListModel {
        private StringBuffer filteringBuffer = null;

        public void addFilteringChar(char c) {
            if (this.filteringBuffer == null) {
                this.filteringBuffer = new StringBuffer();
            }
            if (this.getSize() > 0) {
                this.filteringBuffer.append(c);
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void removingLastFilteringChar() {
            if (this.filteringBuffer != null && this.filteringBuffer.length() > 0) {
                this.filteringBuffer.deleteCharAt(this.filteringBuffer.length() - 1);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public Object getElementAt(int n) {
            int n2 = super.getSize();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (this.filteringBuffer != null && !super.getElementAt(i).toString().startsWith(this.filteringBuffer.toString())) continue;
                if (n3 == n) {
                    return super.getElementAt(i);
                }
                ++n3;
            }
            return null;
        }

        public int getSize() {
            int n = super.getSize();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (this.filteringBuffer != null && !super.getElementAt(i).toString().startsWith(this.filteringBuffer.toString())) continue;
                ++n2;
            }
            return n2;
        }
    }
}

