/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.job.FastJob;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.SwingEventSynchro;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.editor.EditorContext;
import com.japisoft.xmlpad.editor.ExpressionHighlighterManager;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditorKit;
import com.japisoft.xmlpad.editor.XMLEntityResolver;
import com.japisoft.xmlpad.editor.renderer.BasicLineRenderer;
import com.japisoft.xmlpad.editor.renderer.LineRenderer;
import com.japisoft.xmlpad.editor.renderer.PlainLineRenderer;
import com.japisoft.xmlpad.editor.renderer.SimpleLineRenderer;
import com.japisoft.xmlpad.error.ErrorListener;
import com.japisoft.xmlpad.error.ErrorSelectionListener;
import com.japisoft.xmlpad.look.LookManager;
import com.japisoft.xmlpad.tree.TreeListeners;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class XMLEditor
extends JEditorPane
implements CaretListener,
FocusListener,
ErrorListener,
ErrorSelectionListener,
MouseMotionListener {
    private Color errorHighlightColor = Color.red;
    private Color selectionHighlightColor = new Color(180, 180, 220);
    private Color xpathHighlightColor = new Color(0, 100, 0);
    Object selectionHighlight;
    Object errorHighlightTag;
    private Segment lineSegment;
    private int lastLine = -1;
    private Keymap map;
    private UndoManager um;
    private static int DEFAULT_FONT_HEIGHT = 10;
    private XMLDocument document;
    private EditorKit EDITOR_KIT;
    private boolean disableCaretListeners = false;
    private EditorUndoableListener editorUndoableListener = new EditorUndoableListener();
    private PopupMouseAdapter popupMouseAdapter;
    private boolean initOnce = false;
    private XMLContainer container;
    private boolean autoResetAction = true;
    private boolean focusView = false;
    private boolean delayedStructuredDamaged = false;
    private boolean realTimeStructureChanged = true;
    boolean documentModified = false;
    private EditorContext editorContext;
    private int minErrorLineFound = -1;
    private Color colorTagUnderline = null;
    private Color colorEntity = null;
    private Color colorComment = null;
    private Color colorCommentStart = null;
    private Color colorCommentEnd = null;
    private Color colorDeclaration = null;
    private Color colorDeclarationStart = null;
    private Color colorDeclarationEnd = null;
    private Color colorDocType = null;
    private Color colorDocTypeStart = null;
    private Color colorDocTypeEnd = null;
    private Color colorLiteral = null;
    private Color colorTag = null;
    private Color colorInvalid = null;
    private Color colorText = null;
    private Color colorAttribute = null;
    private Color colorTagDelimiter = null;
    private Color colorTagBackground = null;
    private Color colorDeclarationBackground = null;
    private Color colorEntityBackground = null;
    private Color colorCommentBackground = null;
    private Color colorDocTypeBackground = null;
    private Color colorCDATABackground = null;
    private Color colorAttributeSeparator = null;
    private Color colorTagEnd = null;
    private Color colorNameSpace = null;
    private Color colorCDATA = null;
    private Color colorCDATAStart = null;
    private Color colorCDATAEnd = null;
    private Color colorTagBorderLine = null;
    private Color colorLineSelection = null;
    private Color colorLineError = null;
    private Color colorDTDElement = null;
    private Color colorDTDAttribute = null;
    private Color colorDTDEntity = null;
    private Color colorCurrentLine = null;
    private Color colorDTDNotation;
    private XMLEntityResolver resolver = new XMLEntityResolver();
    private Object expressionHighlighter = null;
    private boolean xmllocation = true;
    SimpleNode lastStructureLocation;
    private boolean enabledXPathLocation = true;
    private boolean enableHighlightCurrentLine = true;
    private Object currentLineHighlightTag = null;
    private CurrentLineHightlighter currentLineHighlight = null;
    private boolean delayedDisableCaretListeners = false;
    private boolean infoTooltip = true;
    private LineRenderer errorLineRenderer;
    private LineRenderer xpathLineRenderer;
    private Color highlightExpressionColor = Color.LIGHT_GRAY;
    private LineRenderer currentLineRenderer;
    private LineRenderer selectionLineRenderer;
    final CurrentLocationJob LOCATION_JOB = new CurrentLocationJob();
    public static Class _locationJobClass = CurrentLocationJob.class;

    public XMLEditor(EditorContext editorContext) {
        this.editorContext = editorContext;
        this.setBorder(null);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.lineSegment = new Segment();
        this.resetDefaultLook();
        this.initUI();
        this.initKeymap();
        this.um = new UndoManager();
    }

    private void initUI() {
        String string = "xmlpad.editor.";
        Font font = UIManager.getFont(string + "font");
        if (font != null) {
            this.setFont(font);
        } else if (System.getProperty("os.name") != null && "mac os x".equals(System.getProperty("os.name").toLowerCase())) {
            this.setFont(new Font("monaco", 0, 12));
        }
        Color color = UIManager.getColor(string + "dtdElementColor");
        if (color != null) {
            this.setColorForDTDElement(color);
        }
        if ((color = UIManager.getColor(string + "dtdNotationColor")) != null) {
            this.setColorForDTDNotation(color);
        }
        if ((color = UIManager.getColor(string + "dtdAttributeColor")) != null) {
            this.setColorForDTDAttribute(color);
        }
        if ((color = UIManager.getColor(string + "dtdEntityColor")) != null) {
            this.setColorForDTDEntity(color);
        }
        if ((color = UIManager.getColor(string + "tagBorderLineColor")) != null) {
            this.setColorForTagBorderLine(color);
        }
        if ((color = UIManager.getColor(string + "cdataColor")) != null) {
            this.setColorForCDATA(color);
        }
        if ((color = UIManager.getColor(string + "entityColor")) != null) {
            this.setColorForEntity(color);
        }
        if ((color = UIManager.getColor(string + "commentColor")) != null) {
            this.setColorForComment(color);
        }
        if ((color = UIManager.getColor(string + "declarationColor")) != null) {
            this.setColorForDeclaration(color);
        }
        if ((color = UIManager.getColor(string + "docTypeColor")) != null) {
            this.setColorForDocType(color);
        }
        if ((color = UIManager.getColor(string + "literalColor")) != null) {
            this.setColorForLiteral(color);
        }
        if ((color = UIManager.getColor(string + "tagColor")) != null) {
            this.setColorForTag(color);
        }
        if ((color = UIManager.getColor(string + "invalidColor")) != null) {
            this.setColorForInvalid(color);
        }
        if ((color = UIManager.getColor(string + "textColor")) != null) {
            this.setColorForText(color);
        }
        if ((color = UIManager.getColor(string + "attributeColor")) != null) {
            this.setColorForAttribute(color);
        }
        if ((color = UIManager.getColor(string + "attributeSeparatorColor")) != null) {
            this.setColorForAttributeSeparator(color);
        }
        if ((color = UIManager.getColor(string + "selectionHighlightColor")) != null) {
            this.setSelectionHighlightColor(color);
        }
        if ((color = UIManager.getColor(string + "backgroundColor")) != null) {
            this.setBackground(color);
        }
        if ((color = UIManager.getColor(string + "tagBackground")) != null) {
            this.setColorForTagBackground(color);
        }
        if ((color = UIManager.getColor(string + "declarationBackground")) != null) {
            this.setColorForDeclarationBackground(color);
        }
        if ((color = UIManager.getColor(string + "entityBackground")) != null) {
            this.setColorForEntityBackground(color);
        }
        if ((color = UIManager.getColor(string + "commentBackground")) != null) {
            this.setColorForCommentBackground(color);
        }
        if ((color = UIManager.getColor(string + "docTypeBackground")) != null) {
            this.setColorForDocTypeBackground(color);
        }
        if ((color = UIManager.getColor(string + "cdataBackground")) != null) {
            this.setColorForCDATABackground(color);
        }
        this.colorCurrentLine = new Color(230, 250, 230);
    }

    public void dispose() {
        Debug.debug("Dispose XMLEditor " + this);
        this.setTransferHandler(null);
        this.removeFocusListener(this);
        this.removeCaretListener(this);
        this.getDocument().removeUndoableEditListener(this.editorUndoableListener);
        this.setUndoManager(null);
        this.editorContext = null;
        this.removeMouseListener(this.popupMouseAdapter);
        this.removeMouseMotionListener(this);
        this.releaseKeyMap();
    }

    public void addNotify() {
        super.addNotify();
        this.initOnce();
        if (this.enableHighlightCurrentLine) {
            this.highlightCurrentLine();
        }
    }

    public void select(int n, int n2) {
        int n3 = this.getDocument().getLength();
        if (n < 0) {
            n = 0;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 < n) {
            n2 = n;
        }
        this.setCaretPosition(n2);
        this.moveCaretPosition(n);
    }

    protected void initOnce() {
        if (this.initOnce) {
            return;
        }
        this.initOnce = true;
        this.addCaretListener(this);
        this.getDocument().addUndoableEditListener(this.editorUndoableListener);
        this.addFocusListener(this);
        if (this.getXMLContainer() != null) {
            this.setUndoManager(this.getXMLContainer().createUndoManager());
        }
        this.popupMouseAdapter = new PopupMouseAdapter();
        this.addMouseListener(this.popupMouseAdapter);
        this.initKeyMap();
        if (this.getEditorKit() instanceof XMLEditorKit) {
            ((XMLEditorKit)this.getEditorKit()).setSyntaxColor(this.getXMLContainer().getDocumentInfo().hasSyntaxColor());
            ((XMLEditorKit)this.getEditorKit()).setDTDMode(this.getXMLContainer().getDocumentInfo().isDtdMode());
        }
        ((XMLDocument)this.getDocument()).setAutoCloseTag(this.getXMLContainer().getDocumentInfo().hasAutoClosing());
        this.setTransferHandler(new CustomTransferHandler());
        this.addMouseMotionListener(this);
    }

    private void initKeyMap() {
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), new CustomTabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 64), new CustomUntabAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 128), new ContentAssistantAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 192), new EntityAssistantAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 640), new SystemAssistantAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 128), new SelectNodeDownAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 128), new SelectNodeUpAction());
    }

    private void releaseKeyMap() {
        this.getInputMap().remove(KeyStroke.getKeyStroke(9, 0));
        this.getInputMap().remove(KeyStroke.getKeyStroke(9, 64));
        this.getInputMap().remove(KeyStroke.getKeyStroke(32, 128));
        this.getInputMap().remove(KeyStroke.getKeyStroke(32, 192));
        this.getInputMap().remove(KeyStroke.getKeyStroke(32, 640));
        this.getInputMap().remove(KeyStroke.getKeyStroke(40, 192));
        this.getInputMap().remove(KeyStroke.getKeyStroke(38, 192));
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.container != null && this.container.isAutoDisposeMode()) {
            this.dispose();
        }
    }

    public SimpleNode getCurrentNodeLocation() {
        return this.lastStructureLocation;
    }

    public void setXMLContainer(XMLContainer xMLContainer) {
        this.container = xMLContainer;
    }

    public XMLContainer getXMLContainer() {
        return this.container;
    }

    public XMLDocument getXMLDocument() {
        return (XMLDocument)this.getDocument();
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = new XMLDocument(this);
            this.setEditorKit(this.getEditorKit());
        }
        return this.document;
    }

    public void resetDocument(XMLDocument xMLDocument) {
        if (this.document != null && this.document instanceof XMLDocument) {
            this.document.setEditor(null);
        }
        this.document = xMLDocument;
        super.setDocument(xMLDocument);
    }

    public void setAutoResetAction(boolean bl) {
        this.autoResetAction = bl;
    }

    public boolean isAutoResetAction() {
        return this.autoResetAction;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.unhighlightLine();
        if (this.autoResetAction) {
            ActionModel.resetActionState(this, this.getXMLContainer());
        }
        this.getXMLContainer().resetEditor(this);
        if (this.delayedStructuredDamaged) {
            this.delayedStructuredDamaged = false;
            ((XMLDocument)this.getDocument()).structureDamaged();
        }
        if (UIManager.getBorder("xmlpad.editor.focusBorder") != null) {
            this.setBorder(UIManager.getBorder("xmlpad.editor.focusBorder"));
        }
    }

    void setDelayedStructureDamaged(boolean bl) {
        this.delayedStructuredDamaged = bl;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focusView = false;
        if (UIManager.getBorder("xmlpad.editor.focusBorder") != null) {
            this.setBorder(null);
        }
    }

    public void setEnabledRealTimeStructureChanged(boolean bl) {
        this.realTimeStructureChanged = bl;
        ((XMLDocument)this.getDocument()).enableStructureDamagedSupport(bl);
    }

    public boolean isEnabledRealTimeStructureChanged() {
        return this.realTimeStructureChanged;
    }

    public void setAutoCloseTag(boolean bl) {
        ((XMLDocument)this.getDocument()).setAutoCloseTag(bl);
    }

    public boolean isAutoCloseTag() {
        return ((XMLDocument)this.getDocument()).isAutoCloseTag();
    }

    public void resetDocumentState(boolean bl) {
        this.documentModified = bl;
    }

    public boolean isDocumentModified() {
        return this.documentModified;
    }

    public void notifyStructureChanged() {
        ((XMLDocument)this.getDocument()).structureDamaged();
    }

    void notifyDocumentChanged() {
        if (!this.documentModified) {
            this.documentModified = true;
            this.getXMLContainer().notifyDocumentVersion(false);
        }
    }

    public void initErrorProcessing() {
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        if (bl) {
            if (!bl2 && this.minErrorLineFound == -1 && n > 0) {
                this.minErrorLineFound = n;
            } else if (bl2 && SharedProperties.HIGHLIGHT_ERROR_ONTHEFLY) {
                this.highlightErrorLine(n);
                this.repaint();
            }
        }
    }

    public void notifyNoError(boolean bl) {
        if (this.errorHighlightTag == null) {
            return;
        }
        this.getHighlighter().removeHighlight(this.errorHighlightTag);
        this.errorHighlightTag = null;
    }

    public void stopErrorProcessing() {
        if (this.minErrorLineFound != -1) {
            this.setLineNumber(this.minErrorLineFound);
        }
        this.repaint();
        this.minErrorLineFound = -1;
    }

    public void errorSelected(String string, int n, String string2) {
        this.highlightErrorLine(n, true);
    }

    public void resetDefaultLook() {
        LookManager.install(this.container, this);
        if (this.errorLineRenderer == null) {
            this.errorLineRenderer = BasicLineRenderer.getSharedInstance();
        }
        if (this.selectionLineRenderer == null) {
            this.selectionLineRenderer = BasicLineRenderer.getSharedInstance();
        }
        if (this.xpathLineRenderer == null) {
            this.xpathLineRenderer = SimpleLineRenderer.getSharedInstance();
        }
    }

    public EditorKit getEditorKit() {
        if (this.EDITOR_KIT == null) {
            this.EDITOR_KIT = new XMLEditorKit((XMLDocument)this.getDocument());
        }
        return this.EDITOR_KIT;
    }

    public void setDisplaySpace(boolean bl) {
        if (this.EDITOR_KIT instanceof XMLEditorKit) {
            ((XMLEditorKit)this.EDITOR_KIT).setDisplaySpace(bl);
            this.repaint();
        }
    }

    public boolean isDisplaySpace() {
        if (this.EDITOR_KIT instanceof XMLEditorKit) {
            return ((XMLEditorKit)this.EDITOR_KIT).isDisplaySpace();
        }
        return false;
    }

    public void initKeymap() {
        Keymap keymap = this.getKeymap();
        this.map = XMLEditor.addKeymap("XMLEditor", keymap);
        this.setKeymap(this.map);
        this.map.setDefaultAction(new DefaultTextAction(this.map.getDefaultAction()));
    }

    public void setAction(KeyStroke keyStroke, Action action) {
        this.map.addActionForKeyStroke(keyStroke, action);
    }

    public void setColorForCurrentLine(Color color) {
        this.colorCurrentLine = color;
    }

    public void setColorForAttribute(String string, Color color) {
        if (this.container != null) {
            this.container.getDocumentColorAccessibility().setColorForAttribute(string, color);
        }
    }

    public Color getColorForAttribute(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().getColorForAttribute(string);
        }
        return null;
    }

    public boolean hasColorForAttribute(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().hasColorForAttribute(string);
        }
        return false;
    }

    public void setColorForTag(String string, Color color) {
        if (this.container != null) {
            this.container.getDocumentColorAccessibility().setColorForTag(string, color);
        }
    }

    public Color getColorForTag(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().getColorForTag(string);
        }
        return null;
    }

    public boolean hasColorForTag(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().hasColorForTag(string);
        }
        return false;
    }

    public void setColorForPrefix(String string, Color color) {
        if (this.container != null) {
            this.container.getDocumentColorAccessibility().setColorForPrefix(string, color);
        }
    }

    public Color getColorForPrefix(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().getColorForPrefix(string);
        }
        return null;
    }

    public boolean hasColorForPrefix(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().hasColorForPrefix(string);
        }
        return false;
    }

    public void setBackgroundColorForPrefix(String string, Color color) {
        if (this.container != null) {
            this.container.getDocumentColorAccessibility().setBackgroundColorForPrefix(string, color);
        }
    }

    public Color getBackgroundColorForPrefix(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().getBackgroundColorForPrefix(string);
        }
        return null;
    }

    public boolean hasBackgroundColorForPrefix(String string) {
        if (this.container != null) {
            return this.container.getDocumentColorAccessibility().hasBackgroundColorForPrefix(string);
        }
        return false;
    }

    public void setColorForLineSelection(Color color) {
        this.colorLineSelection = color;
    }

    public void setColorForLineError(Color color) {
        this.colorLineError = color;
    }

    public void setColorForDTDElement(Color color) {
        this.colorDTDElement = color;
    }

    public Color getColorForDTDElement() {
        return this.colorDTDElement;
    }

    public void setColorForDTDAttribute(Color color) {
        this.colorDTDAttribute = color;
    }

    public Color getColorForDTDAttribute() {
        return this.colorDTDAttribute;
    }

    public void setColorForDTDEntity(Color color) {
        this.colorDTDEntity = color;
    }

    public Color getColorForDTDEntity() {
        return this.colorDTDEntity;
    }

    public void setColorForDTDNotation(Color color) {
        this.colorDTDNotation = color;
    }

    public Color getColorForDTDNotation() {
        return this.colorDTDNotation;
    }

    public void setColorForTagBorderLine(Color color) {
        this.colorTagBorderLine = color;
    }

    public Color getColorForTagBorderLine() {
        return this.colorTagBorderLine;
    }

    public void setColorForCDATA(Color color) {
        this.colorCDATA = color;
    }

    public void setColorForCDATAStart(Color color) {
        this.colorCDATAStart = color;
    }

    public Color getColorForCDATAStart() {
        return this.colorCDATAStart;
    }

    public void setColorForCDATAEnd(Color color) {
        this.colorCDATAEnd = color;
    }

    public Color getColorForCDATAEnd() {
        return this.colorCDATAEnd;
    }

    public void setColorForCDATABackground(Color color) {
        this.colorCDATABackground = color;
    }

    public void setColorForTagUnderline(Color color) {
        this.colorTagUnderline = color;
    }

    public void setColorForEntity(Color color) {
        this.colorEntity = color;
    }

    public void setColorForComment(Color color) {
        this.colorComment = color;
    }

    public void setColorForCommentStart(Color color) {
        this.colorCommentStart = color;
    }

    public Color getColorForCommentStart() {
        return this.colorCommentStart;
    }

    public void setColorForCommentEnd(Color color) {
        this.colorCommentStart = color;
    }

    public Color getColorForCommentEnd() {
        return this.colorCommentStart;
    }

    public void setColorForDeclarationStart(Color color) {
        this.colorDeclarationStart = color;
    }

    public Color getColorForDeclarationStart() {
        return this.colorDeclarationStart;
    }

    public void setColorForDeclarationEnd(Color color) {
        this.colorDeclarationEnd = color;
    }

    public Color getColorForDeclarationEnd() {
        return this.colorDeclarationEnd;
    }

    public void setColorForDeclaration(Color color) {
        this.colorDeclaration = color;
    }

    public void setColorForDocType(Color color) {
        this.colorDocType = color;
    }

    public void setColorForDocTypeStart(Color color) {
        this.colorDocTypeStart = color;
    }

    public Color getColorForDocTypeStart() {
        return this.colorDocTypeStart;
    }

    public void setColorForDocTypeEnd(Color color) {
        this.colorDocTypeEnd = color;
    }

    public Color getColorForDocTypeEnd() {
        return this.colorDocTypeEnd;
    }

    public void setColorForDocTypeBackground(Color color) {
        this.colorDocTypeBackground = color;
    }

    public void setColorForLiteral(Color color) {
        this.colorLiteral = color;
    }

    public void setColorForTag(Color color) {
        this.colorTag = color;
    }

    public void setColorForInvalid(Color color) {
        this.colorInvalid = color;
    }

    public void setColorForText(Color color) {
        this.colorText = color;
    }

    public void setColorForAttribute(Color color) {
        this.colorAttribute = color;
    }

    public void setColorForTagDelimiter(Color color) {
        this.colorTagDelimiter = color;
    }

    public void setColorForTagBackground(Color color) {
        this.colorTagBackground = color;
    }

    public void setColorForDeclarationBackground(Color color) {
        this.colorDeclarationBackground = color;
    }

    public void setColorForEntityBackground(Color color) {
        this.colorEntityBackground = color;
    }

    public void setColorForCommentBackground(Color color) {
        this.colorCommentBackground = color;
    }

    public void setColorForAttributeSeparator(Color color) {
        this.colorAttributeSeparator = color;
    }

    public void setColorForTagEnd(Color color) {
        this.colorTagEnd = color;
    }

    public void setColorForNameSpace(Color color) {
        this.colorNameSpace = color;
    }

    public Color getColorForLineError() {
        return this.colorLineError;
    }

    public Color getColorForLineSelection() {
        return this.colorLineSelection;
    }

    public Color getColorForCDATA() {
        return this.colorCDATA;
    }

    public Color getColorForCDATABackground() {
        return this.colorCDATABackground;
    }

    public Color getColorForTagUnderline() {
        return this.colorTagUnderline;
    }

    public Color getColorForNameSpace() {
        return this.colorNameSpace;
    }

    public Color getColorForEntity() {
        return this.colorEntity;
    }

    public Color getColorForComment() {
        return this.colorComment;
    }

    public Color getColorForDeclaration() {
        return this.colorDeclaration;
    }

    public Color getColorForDocType() {
        return this.colorDocType;
    }

    public Color getColorForDocTypeBackground() {
        return this.colorDocTypeBackground;
    }

    public Color getColorForLiteral() {
        return this.colorLiteral;
    }

    public Color getColorForTag() {
        return this.colorTag;
    }

    public Color getColorForInvalid() {
        return this.colorInvalid;
    }

    public Color getColorForText() {
        return this.colorText;
    }

    public Color getColorForAttribute() {
        return this.colorAttribute;
    }

    public Color getColorForTagDelimiter() {
        return this.colorTagDelimiter;
    }

    public Color getColorForTagBackground() {
        return this.colorTagBackground;
    }

    public Color getColorForDeclarationBackground() {
        return this.colorDeclarationBackground;
    }

    public Color getColorForEntityBackground() {
        return this.colorEntityBackground;
    }

    public Color getColorCommentBackground() {
        return this.colorCommentBackground;
    }

    public Color getColorForAttributeSeparator() {
        return this.colorAttributeSeparator;
    }

    public Color getColorForTagEnd() {
        return this.colorTagEnd;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.um = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.um;
    }

    public void undo() {
        try {
            this.um.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            ActionModel.setEnabledAction(ActionModel.UNDO_ACTION, false);
        }
    }

    public void redo() {
        try {
            this.um.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            ActionModel.setEnabledAction(ActionModel.REDO_ACTION, false);
        }
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.resolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setText(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        inputStream.close();
        this.setText(stringBuffer.toString());
    }

    public void setText(String string) {
        try {
            if (this.um != null) {
                this.um.discardAllEdits();
            } else {
                this.um = this.container.createUndoManager();
            }
            this.getXMLDocument().remove(0, this.document.getLength());
            this.getXMLDocument().insertStringWithoutHelper(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.lastStructureLocation = null;
    }

    public String getText(int n) {
        try {
            return this.document.getText(n, this.document.getLength() - n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getText() {
        return this.getText(0);
    }

    public void setLineNumber(int n) {
        try {
            Element element = this.document.getDefaultRootElement();
            Element element2 = element.getElement(n - 1);
            this.setCaretPosition(element2.getStartOffset());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertText(String string) {
        try {
            int n = 0;
            n = this.getCaretPosition();
            this.document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public EditorKit createDefaultEditorKit() {
        return this.EDITOR_KIT;
    }

    public void unhighlightLine() {
        if (this.selectionHighlight != null) {
            this.getHighlighter().removeHighlight(this.selectionHighlight);
        }
        this.repaint();
        this.selectionHighlight = null;
    }

    public int getLineStart(int n) {
        try {
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            return n3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    public int getLineEnd(int n) {
        try {
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            int n3 = element2.getEndOffset();
            return n3;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public void asynchronousHighlightLine(int n) {
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XMLEditor.this.highlightLine(n2);
            }
        });
    }

    public void highlightLine(int n) {
        try {
            if (this.selectionHighlight == null) {
                this.selectionHighlight = this.getHighlighter().addHighlight(0, 0, new SelectionLineHighlighter());
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        try {
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            Element element2 = element.getElement(Math.max(0, n - 1));
            if (element2 == null) {
                System.err.println("Can't find element : " + (n - 1) + "?");
                return;
            }
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset();
            this.getHighlighter().changeHighlight(this.selectionHighlight, n2, n3);
            Rectangle rectangle = this.modelToView(n2);
            rectangle.height = this.getVisibleRect().height;
            rectangle.y -= rectangle.height / 2;
            this.scrollRectToVisible(rectangle);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.repaint();
    }

    public void removeHighlightedErrorLine() {
        if (this.errorHighlightTag != null) {
            this.getHighlighter().removeHighlight(this.errorHighlightTag);
        }
        this.errorHighlightTag = null;
    }

    public void removeHighlightedLines() {
        this.getHighlighter().removeAllHighlights();
    }

    public void highlightNodes(List list) {
        this.getHighlighter().removeAllHighlights();
        XPathLineHighlighter xPathLineHighlighter = new XPathLineHighlighter();
        for (int i = 0; i < list.size(); ++i) {
            SimpleNode simpleNode = (SimpleNode)list.get(i);
            int n = simpleNode.getStartingLine();
            if (n < 1) continue;
            Element element = this.getDocument().getDefaultRootElement();
            Element element2 = element.getElement(n - 1);
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset();
            try {
                this.getHighlighter().addHighlight(n2, n3, xPathLineHighlighter);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void highlightNode(SimpleNode simpleNode) {
        int n = simpleNode.getStartingLine();
        if (n >= 1) {
            this.highlightNode(n);
        }
    }

    public void highlightNode(int n) {
        this.getHighlighter().removeAllHighlights();
        XPathLineHighlighter xPathLineHighlighter = new XPathLineHighlighter();
        Element element = this.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n - 1);
        if (element2 != null) {
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset();
            try {
                this.getHighlighter().addHighlight(n2, n3, xPathLineHighlighter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void highlightExpression(int n) {
        try {
            this.removeHighlightExpression();
            ExpressionHighlighter expressionHighlighter = new ExpressionHighlighter();
            this.expressionHighlighter = this.getHighlighter().addHighlight(n, n + 1, expressionHighlighter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeHighlightExpression() {
        if (this.expressionHighlighter != null) {
            this.getHighlighter().removeHighlight(this.expressionHighlighter);
            this.expressionHighlighter = null;
        }
    }

    public void highlightErrorLine(int n) {
        this.highlightErrorLine(n, false);
    }

    public void highlightErrorLine(int n, boolean bl) {
        if (n > 0) {
            try {
                Element element;
                Document document = this.getDocument();
                Element element2 = document.getDefaultRootElement();
                if (n - 1 < 0) {
                    n = 1;
                }
                if ((element = element2.getElement(n - 1)) == null) {
                    System.err.println("Can't find element : " + (n - 1) + "?");
                    return;
                }
                int n2 = element.getStartOffset();
                int n3 = element.getEndOffset();
                if (this.errorHighlightTag != null) {
                    this.getHighlighter().removeHighlight(this.errorHighlightTag);
                }
                this.errorHighlightTag = this.getHighlighter().addHighlight(n2, n3, new ErrorLineHighlighter());
                if (bl) {
                    Rectangle rectangle = this.modelToView(n2);
                    rectangle.height = this.getVisibleRect().height;
                    rectangle.y -= rectangle.height / 2;
                    this.scrollRectToVisible(rectangle);
                }
                this.repaint();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setEnabledTreeLocationForCaret(boolean bl) {
        this.xmllocation = bl;
        if (!bl && this.editorContext != null) {
            this.editorContext.notifyLocation(null);
        }
    }

    public boolean isEnabledTreeLocationForCaret() {
        return this.xmllocation;
    }

    protected void updateSelectionState() {
        boolean bl = this.getSelectionStart() < this.getSelectionEnd() && this.getSelectionStart() >= 0;
        ActionModel.activeActionForSelection(bl);
    }

    public void setEnabledXPathLocation(boolean bl) {
        this.enabledXPathLocation = bl;
    }

    public boolean isEnabledXPathLocation() {
        return this.enabledXPathLocation;
    }

    public void notifyCurrentLocation() {
        if (this.getXMLContainer().getTreeListeners() == null || !this.enabledXPathLocation || this.getXMLContainer().getErrorManager().hasLastError()) {
            return;
        }
        if (this.editorContext != null && !this.getXMLContainer().getTreeListeners().isLocationLocked() && this.LOCATION_JOB.preRun()) {
            this.LOCATION_JOB.run();
        }
    }

    public void notifyCaretLocation() {
        int n = this.getCaretPosition();
        Element element = this.getDocument().getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        int n3 = n - element.getElement(n2).getStartOffset();
        this.editorContext.notifyCaretLocation(n3 + 1, n2 + 1);
    }

    public void synchronousCurrentLocation(boolean bl) {
        if (this.getXMLContainer() == null) {
            return;
        }
        if (this.getXMLContainer().getTreeListeners() == null) {
            return;
        }
        if (this.getXMLContainer().hasErrorMessage()) {
            bl = false;
        }
        if (!bl || this.getXMLContainer().getTreeListeners().isLocationLocked()) {
            // empty if block
        }
        if (this.editorContext != null && !this.getXMLContainer().getTreeListeners().isLocationLocked() && !this.getXMLContainer().getTreeListeners().isLocationLocked()) {
            SimpleNode simpleNode;
            this.lastStructureLocation = simpleNode = this.document.getXMLPath(this.getCaretPosition());
            if (this.editorContext != null) {
                this.editorContext.notifyLocation(simpleNode);
            }
            this.repaint();
        }
    }

    public void setEnableHighlightCurrentLine(boolean bl) {
        this.enableHighlightCurrentLine = bl;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.notifyCaretLocation();
        if (this.enableHighlightCurrentLine) {
            this.highlightCurrentLine();
        }
        if (this.disableCaretListeners || this.delayedDisableCaretListeners) {
            this.delayedDisableCaretListeners = false;
            return;
        }
        this.updateSelectionState();
        if (this.xmllocation && this.enabledXPathLocation) {
            this.notifyCurrentLocation();
        }
        ExpressionHighlighterManager.highlight(this);
    }

    private void highlightCurrentLine() {
        int n = this.getCaretPosition();
        int n2 = this.getDocument().getDefaultRootElement().getElementIndex(n);
        Element element = this.getDocument().getDefaultRootElement().getElement(n2);
        if (this.currentLineHighlightTag != null) {
            this.getHighlighter().removeHighlight(this.currentLineHighlightTag);
        }
        if (this.currentLineHighlight == null) {
            this.currentLineHighlight = new CurrentLineHightlighter();
        }
        try {
            this.currentLineHighlightTag = this.getHighlighter().addHighlight(element.getStartOffset(), element.getEndOffset(), this.currentLineHighlight);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean setCaretPositionWithoutNotification(int n) {
        this.delayedDisableCaretListeners = true;
        try {
            this.setCaretPosition(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void setInfoToolTip(boolean bl) {
        this.infoTooltip = bl;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.infoTooltip) {
            SimpleNode simpleNode;
            int n;
            if (mouseEvent.isControlDown()) {
                n = this.viewToModel(mouseEvent.getPoint());
                try {
                    simpleNode = this.document.getXMLPath(n);
                    if (simpleNode != null) {
                        this.setToolTipText(simpleNode.getXPathLocation());
                    } else {
                        this.setToolTipText(null);
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.setToolTipText(null);
                }
            }
            if (mouseEvent.isAltDown()) {
                try {
                    n = this.viewToModel(mouseEvent.getPoint());
                    simpleNode = this.document.getXMLPath(n);
                    if (simpleNode != null) {
                        if (simpleNode.isText()) {
                            this.setToolTipText(simpleNode.getContent());
                        } else {
                            StringBuffer stringBuffer = new StringBuffer("<html><body>");
                            if (simpleNode.getViewAttributeCount() > 0) {
                                for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                                    String string = simpleNode.getViewAttributeAt(i);
                                    stringBuffer.append("<b>");
                                    stringBuffer.append(string);
                                    stringBuffer.append("</b> : <i>");
                                    stringBuffer.append(simpleNode.getAttribute(string));
                                    stringBuffer.append("</i>");
                                    stringBuffer.append("<br>");
                                }
                            } else {
                                stringBuffer.append("No attributes");
                            }
                            stringBuffer.append("</body></html>");
                            this.setToolTipText(stringBuffer.toString());
                        }
                    } else {
                        this.setToolTipText(null);
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.setToolTipText(null);
                }
            }
        }
    }

    public void setErrorLineRenderer(LineRenderer lineRenderer) {
        this.errorLineRenderer = lineRenderer;
    }

    public void setXPathLineRenderer(LineRenderer lineRenderer) {
        this.xpathLineRenderer = lineRenderer;
    }

    public void setHighlightExpressionColor(Color color) {
        this.highlightExpressionColor = color;
    }

    public void setCurrentLineRenderer(LineRenderer lineRenderer) {
        this.currentLineRenderer = lineRenderer;
    }

    public void setSelectionLineRenderer(LineRenderer lineRenderer) {
        this.selectionLineRenderer = lineRenderer;
    }

    private Point getTextBeginEnd(int n) {
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement().getElement(n);
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        try {
            String string = document.getText(n2, n3 - n2 + 1);
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                for (int j = string.length() - 1; j > i; --j) {
                    if (Character.isWhitespace(string.charAt(j))) continue;
                    int n4 = n2 + j;
                    int n5 = n2 + i;
                    if (n4 - n5 < 2) {
                        return null;
                    }
                    return new Point(n5, n4 + 1);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return null;
    }

    public Color getSelectionHighlightColor() {
        return this.selectionHighlightColor;
    }

    public void setSelectionHighlightColor(Color color) {
        this.selectionHighlightColor = color;
    }

    class CustomTransferHandler
    extends TransferHandler {
        CustomTransferHandler() {
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
            int n2;
            JTextComponent jTextComponent;
            int n3;
            if (jComponent instanceof JTextComponent && (n3 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) != (n2 = jTextComponent.getSelectionEnd())) {
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    if (n == 2) {
                        document.remove(n3, n2 - n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor;
            if (jComponent instanceof JTextComponent && (dataFlavor = this.getFlavor(transferable.getTransferDataFlavors())) != null) {
                InputContext inputContext = jComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                try {
                    Object object = transferable.getTransferData(dataFlavor);
                    String string = null;
                    try {
                        if (object instanceof SimpleNode) {
                            SimpleNode simpleNode = (SimpleNode)object;
                            int n = 0;
                            if (simpleNode.isTag()) {
                                ++n;
                            }
                            string = XMLEditor.this.getDocument().getText(simpleNode.getStartingOffset(), simpleNode.getStoppingOffset() - simpleNode.getStartingOffset() + n);
                        } else {
                            string = (String)transferable.getTransferData(dataFlavor);
                        }
                        ((JTextComponent)jComponent).replaceSelection(string);
                    }
                    catch (BadLocationException badLocationException) {
                        return false;
                    }
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getFlavor(dataFlavorArray) != null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (dataFlavorArray[i].equals(DataFlavor.stringFlavor)) {
                        return dataFlavorArray[i];
                    }
                    if (!dataFlavorArray[i].equals(TreeListeners.NODE_FLAVOR)) continue;
                    return dataFlavorArray[i];
                }
            }
            return null;
        }
    }

    final class CurrentLocationJob
    implements Job,
    SwingEventSynchro,
    FastJob {
        SimpleNode computedLocation = null;

        CurrentLocationJob() {
        }

        public Object getSource() {
            return this;
        }

        public void dispose() {
            this.computedLocation = null;
        }

        public boolean isAlone() {
            return true;
        }

        public void stopIt() {
        }

        public boolean preRun() {
            this.computedLocation = null;
            if (XMLEditor.this.getXMLContainer() == null) {
                return false;
            }
            if (XMLEditor.this.getXMLContainer().getTreeListeners() == null) {
                return false;
            }
            if (XMLEditor.this.editorContext != null && !XMLEditor.this.getXMLContainer().getTreeListeners().isLocationLocked() && !XMLEditor.this.getXMLContainer().getTreeListeners().isLocationLocked()) {
                try {
                    this.computedLocation = XMLEditor.this.document.getXMLPath(XMLEditor.this.getCaretPosition());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (XMLEditor.this.getXMLContainer() == null) {
                    return;
                }
                if (XMLEditor.this.getXMLContainer().getTreeListeners() == null) {
                    return;
                }
                if (XMLEditor.this.editorContext != null && !XMLEditor.this.getXMLContainer().getTreeListeners().isLocationLocked() && !XMLEditor.this.getXMLContainer().getTreeListeners().isLocationLocked()) {
                    if (XMLEditor.this.editorContext != null && XMLEditor.this.lastStructureLocation != this.computedLocation) {
                        XMLEditor.this.editorContext.notifyLocation(this.computedLocation);
                    }
                    XMLEditor.this.lastStructureLocation = this.computedLocation;
                    XMLEditor.this.repaint();
                }
            }
            finally {
                this.computedLocation = null;
            }
        }
    }

    class CustomUntabAction
    extends TextAction {
        public CustomUntabAction() {
            super("delete-tab");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            Element element;
            Element element2;
            int n3 = XMLEditor.this.getSelectionEnd();
            if (n3 == (element2 = (element = XMLEditor.this.document.getDefaultRootElement()).getElement(n2 = element.getElementIndex(n3))).getStartOffset()) {
                --n3;
                --n2;
            }
            if (n3 > XMLEditor.this.getSelectionStart()) {
                n = XMLEditor.this.document.getDefaultRootElement().getElementIndex(XMLEditor.this.getSelectionStart());
            } else {
                n2 = n = XMLEditor.this.document.getDefaultRootElement().getElementIndex(XMLEditor.this.getCaretPosition());
            }
            int n4 = Math.min(n, n2);
            int n5 = Math.max(n, n2);
            Character c = (Character)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-char", new Character(' '));
            Integer n6 = (Integer)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-size", new Integer(4));
            int n7 = n6;
            XMLEditor.this.document.enableStructureDamagedSupport(false);
            for (int i = n4; i <= n5; ++i) {
                if (i == n5) {
                    XMLEditor.this.document.enableStructureDamagedSupport(true);
                }
                int n8 = XMLEditor.this.document.getDefaultRootElement().getElement(i).getStartOffset();
                int n9 = XMLEditor.this.document.getDefaultRootElement().getElement(i).getEndOffset();
                try {
                    int n10 = 0;
                    for (int j = n8; j < n9 && n10 < n7 && XMLEditor.this.getText(j, 1).charAt(0) == c.charValue(); ++j, ++n10) {
                    }
                    XMLEditor.this.document.remove(n8, n10);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    XMLEditor.this.document.enableStructureDamagedSupport(true);
                }
            }
        }
    }

    class CustomTabAction
    extends TextAction {
        public CustomTabAction() {
            super("insert-tab");
            ActionMap actionMap = XMLEditor.this.getActionMap();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Element element;
            Element element2;
            int n2 = XMLEditor.this.getSelectionEnd();
            if (n2 == (element2 = (element = XMLEditor.this.document.getDefaultRootElement()).getElement(n = element.getElementIndex(n2))).getStartOffset()) {
                --n2;
                --n;
            }
            Character c = (Character)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-char", new Character(' '));
            Integer n3 = (Integer)ActionModel.getProperty(ActionModel.FORMAT_ACTION, "indent-size", new Integer(4));
            int n4 = n3;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append(c.charValue());
            }
            String string = stringBuffer.toString();
            if (n2 > XMLEditor.this.getSelectionStart()) {
                int n5 = XMLEditor.this.document.getDefaultRootElement().getElementIndex(XMLEditor.this.getSelectionStart());
                int n6 = Math.min(n5, n);
                int n7 = Math.max(n5, n);
                XMLEditor.this.document.enableStructureDamagedSupport(false);
                for (int i = n6; i <= n7; ++i) {
                    int n8 = XMLEditor.this.document.getDefaultRootElement().getElement(i).getStartOffset();
                    try {
                        if (i == n7) {
                            XMLEditor.this.document.enableStructureDamagedSupport(true);
                        }
                        XMLEditor.this.document.insertString(n8, string, null);
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        XMLEditor.this.document.enableStructureDamagedSupport(true);
                    }
                }
            } else {
                try {
                    XMLEditor.this.document.insertString(XMLEditor.this.getCaretPosition(), string, null);
                }
                catch (BadLocationException badLocationException) {
                    XMLEditor.this.document.enableStructureDamagedSupport(true);
                }
            }
        }
    }

    class SystemAssistantAction
    extends AbstractAction {
        SystemAssistantAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XMLEditor.this.getXMLDocument().manageCompletion(true, XMLEditor.this.getCaretPosition(), "<!");
        }
    }

    class EntityAssistantAction
    extends AbstractAction {
        EntityAssistantAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XMLEditor.this.getXMLDocument().manageCompletion(true, XMLEditor.this.getCaretPosition(), "&");
        }
    }

    class ContentAssistantAction
    extends AbstractAction {
        ContentAssistantAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XMLEditor.this.getXMLDocument().manageCompletion(true, XMLEditor.this.getCaretPosition(), null);
        }
    }

    class SelectNodeDownAction
    extends AbstractAction {
        SelectNodeDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FastVector fastVector;
            int n;
            SimpleNode simpleNode = XMLEditor.this.getCurrentNodeLocation();
            if (simpleNode != null && (n = (fastVector = simpleNode.getDocument().getFlatNodes()).indexOf(simpleNode)) < fastVector.size() - 1) {
                SimpleNode simpleNode2 = (SimpleNode)fastVector.get(n + 1);
                XMLEditor.this.highlightNode(simpleNode2);
                int n2 = 1;
                if (simpleNode2.isText()) {
                    n2 = 0;
                }
                XMLEditor.this.setCaretPosition(simpleNode2.getStartingOffset() + n2);
                XMLEditor.this.repaint();
            }
        }
    }

    class SelectNodeUpAction
    extends AbstractAction {
        SelectNodeUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleNode simpleNode = XMLEditor.this.getCurrentNodeLocation();
            if (simpleNode != null) {
                FastVector fastVector;
                int n;
                if (simpleNode.isText()) {
                    simpleNode.getSimpleParent();
                }
                if ((n = (fastVector = simpleNode.getDocument().getFlatNodes()).indexOf(simpleNode)) > 0) {
                    SimpleNode simpleNode2 = (SimpleNode)fastVector.get(n - 1);
                    XMLEditor.this.highlightNode(simpleNode2);
                    int n2 = 1;
                    if (simpleNode2.isText()) {
                        n2 = 0;
                    }
                    XMLEditor.this.setCaretPosition(simpleNode2.getStartingOffset() + n2);
                    XMLEditor.this.repaint();
                }
            }
        }
    }

    class PopupMouseAdapter
    extends MouseAdapter {
        PopupMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && XMLEditor.this.getXMLContainer() != null) {
                XMLEditor.this.getXMLContainer().showPopup(XMLEditor.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class SelectionLineHighlighter
    implements Highlighter.HighlightPainter {
        SelectionLineHighlighter() {
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Document document = XMLEditor.this.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n);
            Point point = XMLEditor.this.getTextBeginEnd(n3);
            Rectangle rectangle = (Rectangle)shape;
            int n4 = fontMetrics.getHeight();
            int n5 = rectangle.x;
            int n6 = rectangle.y + n4 * n3;
            int n7 = rectangle.width;
            if (point != null) {
                try {
                    Rectangle rectangle2 = XMLEditor.this.modelToView(point.x);
                    Rectangle rectangle3 = XMLEditor.this.modelToView(point.y);
                    if (rectangle3.y != rectangle2.y && point.y - 2 > point.x) {
                        rectangle3 = XMLEditor.this.modelToView(point.y - 2);
                    }
                    n5 = rectangle2.x;
                    n7 = rectangle3.x - rectangle2.x;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            XMLEditor.this.selectionLineRenderer.renderer(graphics, XMLEditor.this.selectionHighlightColor, n5, n6, n7, n4);
        }
    }

    class ErrorLineHighlighter
    implements Highlighter.HighlightPainter {
        ErrorLineHighlighter() {
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Document document = XMLEditor.this.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n);
            Rectangle rectangle = (Rectangle)shape;
            int n4 = fontMetrics.getHeight();
            int n5 = rectangle.x;
            int n6 = rectangle.y + n4 * n3;
            int n7 = rectangle.width;
            Point point = XMLEditor.this.getTextBeginEnd(n3);
            if (point != null) {
                try {
                    Rectangle rectangle2 = XMLEditor.this.modelToView(point.x);
                    Rectangle rectangle3 = XMLEditor.this.modelToView(point.y);
                    n5 = rectangle2.x;
                    n7 = rectangle3.x - rectangle2.x;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            XMLEditor.this.errorLineRenderer.renderer(graphics, XMLEditor.this.errorHighlightColor, n5, n6, n7, n4);
        }
    }

    class CurrentLineHightlighter
    implements Highlighter.HighlightPainter {
        CurrentLineHightlighter() {
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Document document = XMLEditor.this.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n);
            Rectangle rectangle = (Rectangle)shape;
            int n4 = fontMetrics.getHeight();
            int n5 = rectangle.y + n4 * n3;
            int n6 = 0;
            int n7 = XMLEditor.this.getWidth();
            if (XMLEditor.this.currentLineRenderer == null) {
                XMLEditor.this.currentLineRenderer = PlainLineRenderer.getSharedInstance();
            }
            XMLEditor.this.currentLineRenderer.renderer(graphics, XMLEditor.this.colorCurrentLine, n6, n5, n7, n4);
        }
    }

    class XPathLineHighlighter
    implements Highlighter.HighlightPainter {
        XPathLineHighlighter() {
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Document document = XMLEditor.this.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n);
            Rectangle rectangle = (Rectangle)shape;
            int n4 = fontMetrics.getHeight();
            int n5 = rectangle.x - 1;
            int n6 = rectangle.y + n4 * n3 - 1;
            int n7 = rectangle.width + 2;
            Point point = XMLEditor.this.getTextBeginEnd(n3);
            if (point != null) {
                try {
                    Rectangle rectangle2 = XMLEditor.this.modelToView(point.x);
                    Rectangle rectangle3 = XMLEditor.this.modelToView(point.y - 2);
                    n5 = rectangle2.x;
                    n7 = rectangle3.x - rectangle2.x;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            XMLEditor.this.xpathLineRenderer.renderer(graphics, XMLEditor.this.xpathHighlightColor, n5, n6, n7, n4);
        }
    }

    class ExpressionHighlighter
    implements Highlighter.HighlightPainter {
        ExpressionHighlighter() {
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            try {
                Rectangle rectangle = XMLEditor.this.modelToView(n);
                Rectangle rectangle2 = XMLEditor.this.modelToView(n2);
                graphics.setColor(XMLEditor.this.highlightExpressionColor);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class EditorUndoableListener
    implements UndoableEditListener {
        EditorUndoableListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            XMLEditor.this.um.addEdit(undoableEditEvent.getEdit());
        }
    }

    class DefaultTextAction
    extends TextAction
    implements ActionListener {
        private TextAction ta;

        public DefaultTextAction(Action action) {
            super("default");
            this.ta = (TextAction)action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.ta.actionPerformed(actionEvent);
        }
    }
}

