/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad;

import com.japisoft.xmlpad.PopupModelListener;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionGroup;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.TreeAction;
import com.japisoft.xmlpad.action.XMLAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;

public class PopupModel {
    private final Object SEPARATOR = null;
    private Vector content = new Vector();
    private XMLContainer container;
    private Vector vListeners = null;
    private boolean cEnableChange = false;

    public PopupModel(XMLContainer xMLContainer) {
        this.container = xMLContainer;
    }

    public void dispose() {
        this.container = null;
    }

    public void addPopupModelListener(PopupModelListener popupModelListener) {
        if (this.vListeners == null) {
            this.vListeners = new Vector();
        }
        this.vListeners.add(popupModelListener);
    }

    public void removePopupModelListener(PopupModelListener popupModelListener) {
        if (this.vListeners != null) {
            this.vListeners.remove(popupModelListener);
        }
    }

    public void setEnabledListener(boolean bl) {
        this.cEnableChange = bl;
        if (bl) {
            this.fireNotification();
        }
    }

    private void fireNotification() {
        for (int i = 0; i < this.vListeners.size(); ++i) {
            PopupModelListener popupModelListener = (PopupModelListener)this.vListeners.get(i);
            popupModelListener.updateActions(this.content);
        }
    }

    public int size() {
        return this.content.size();
    }

    public void addAction(Action action) {
        this.content.add(action);
        if (action instanceof XMLAction) {
            ((XMLAction)action).setXMLContainer(this.container);
            ((XMLAction)action).setXMLEditor(this.container.getEditor());
        }
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void removeAction(Action action, boolean bl) {
        this.content.remove(action);
        if (bl && action instanceof XMLAction) {
            ((XMLAction)action).dispose();
        }
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void removeAction(Action action) {
        this.removeAction(action, false);
    }

    public void insertActionAt(Action action, int n) {
        this.content.insertElementAt(action, n);
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public Action getActionAt(int n) {
        return (Action)this.content.elementAt(n);
    }

    public boolean isAction(int n) {
        return !this.isSeparator(n);
    }

    public void addSeparator() {
        this.content.add(this.SEPARATOR);
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void insertSeparatorAt(int n) {
        this.content.insertElementAt(this.SEPARATOR, n);
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public void removeSeparator(int n) {
        if (this.content.get(n) == this.SEPARATOR) {
            this.content.removeElementAt(n);
        }
        if (this.cEnableChange) {
            this.fireNotification();
        }
    }

    public boolean isSeparator(int n) {
        return this.content.get(n) == this.SEPARATOR;
    }

    public static void resetPopupModel(PopupModel popupModel) {
        Enumeration enumeration = ActionModel.getGroups();
        while (enumeration.hasMoreElements()) {
            ActionGroup actionGroup = (ActionGroup)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < actionGroup.size(); ++i) {
                Action action = (Action)actionGroup.get(i);
                if (action instanceof XMLAction && !((XMLAction)action).isPopable()) continue;
                popupModel.addAction(action);
                bl = true;
            }
            if (!enumeration.hasMoreElements() || !bl) continue;
            popupModel.addSeparator();
        }
    }

    public static void resetTreePopupModel(PopupModel popupModel) {
        ActionGroup actionGroup = ActionModel.getGroupByName(ActionModel.TREE_GROUP);
        if (actionGroup == null) {
            return;
        }
        for (int i = 0; i < actionGroup.size(); ++i) {
            TreeAction treeAction;
            if (!(actionGroup.get(i) instanceof TreeAction) || !(treeAction = (TreeAction)actionGroup.get(i)).isTreePopable()) continue;
            popupModel.addAction((XMLAction)((Object)treeAction));
        }
    }
}

