/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.editor;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.internationalization.Traductor;
import com.japisoft.framework.xml.validator.ErrorValidationNode;
import com.japisoft.framework.xml.validator.XSDValidator;
import com.japisoft.xmlform.Toolkit;
import com.japisoft.xmlform.UIToolkit;
import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.EditingContext;
import com.japisoft.xmlform.component.XMLDeserizalizer;
import com.japisoft.xmlform.component.XMLFormComponentFactory;
import com.japisoft.xmlform.component.container.XMLFormContainer;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import com.japisoft.xmlform.editor.EditorModel;
import com.japisoft.xmlform.editor.EditorValidationErrorsPanel;
import com.japisoft.xmlform.editor.ErrorHighlighter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorComponent
extends JPanel
implements ErrorHighlighter {
    private XMLFormComponentFactory factory = null;
    private XMLFormContainer form = null;
    private JScrollPane sp = null;
    private Document doc = null;
    private List<ErrorValidationNode> lastErrors = null;
    private EditorValidationErrorsPanel errorsPanel = null;
    private HashMap<String, AbstractXMLFormComponent> components = null;

    public EditorComponent() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
    }

    public XMLFormComponentFactory getComponentFactory() {
        if (this.factory == null) {
            this.factory = new XMLFormComponentFactory(false, null);
        }
        return this.factory;
    }

    public void initForm(XMLFormContainer xMLFormContainer) {
        if (this.sp != null) {
            this.remove(this.sp);
        }
        this.form = xMLFormContainer;
        this.sp = new JScrollPane(this.form);
        this.add(this.sp);
        this.invalidate();
        this.validate();
        xMLFormContainer.resetRootContainerSize();
    }

    public Document getDocument() {
        Object object;
        if (this.doc == null) {
            try {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                this.doc = ((DocumentBuilderFactory)object).newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
        }
        if (this.form != null) {
            object = (Element)this.form.getDOM(this.doc);
            this.doc = object.getOwnerDocument();
            if (this.doc.getDocumentElement() == null) {
                this.doc.appendChild((Node)object);
            }
        }
        return this.doc;
    }

    public String getFormTemplateURI() {
        if (this.form == null) {
            return null;
        }
        return this.form.getFormTemplateURI();
    }

    public String getSchemaURI() {
        if (this.form == null) {
            return null;
        }
        return this.form.getSchemaURI();
    }

    public void loadDocument(File file) throws Exception {
        this.loadDocument(file.toString(), new FileInputStream(file));
    }

    public void loadDocument(String string) throws Exception {
        if (string.indexOf("://") > -1) {
            this.loadDocument(string, new URL(string).openStream());
        } else {
            this.loadDocument(new File(string));
        }
    }

    private void updateTitle(String string) {
    }

    public void loadDocument(String string, InputStream inputStream) throws Exception {
        this.updateTitle(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.parse(inputStream, string);
        this.loadDocument(string, this.doc);
    }

    public void loadDocument(String string, Document document) throws Exception {
        Object object;
        NodeList nodeList = document.getChildNodes();
        String string2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ProcessingInstruction processingInstruction;
            object = nodeList.item(i);
            if (!(object instanceof ProcessingInstruction) || !"xmlform".equalsIgnoreCase((processingInstruction = (ProcessingInstruction)object).getTarget())) continue;
            string2 = Toolkit.trimQuote(processingInstruction.getData());
        }
        if (string2 == null) {
            throw new Exception("Can't find the XML form document");
        }
        string2 = Toolkit.getAbsolutePath(string, string2);
        XMLFormContainer xMLFormContainer = this.loadXMLForm(string2);
        this.initForm(xMLFormContainer);
        object = xMLFormContainer.getFirstEditableComponent();
        xMLFormContainer.dispatchDOM(document);
        if (object != null) {
            ((JComponent)object).requestFocus();
        }
        EditorModel.CURRENT_DOCUMENT = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorComponent.this.sp.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    public void setFocusTo(AbstractXMLFormComponent abstractXMLFormComponent) {
        Point point = UIToolkit.getLocation(abstractXMLFormComponent);
        JViewport jViewport = this.sp.getViewport();
        jViewport.setViewPosition(point);
        abstractXMLFormComponent.requestFocus();
    }

    private AbstractXMLFormComponent getBoundComponent(Node node) {
        if (node == null) {
            return null;
        }
        AbstractXMLFormComponent abstractXMLFormComponent = (AbstractXMLFormComponent)node.getUserData("ui");
        if (abstractXMLFormComponent != null) {
            return abstractXMLFormComponent;
        }
        return this.getBoundComponent(node.getParentNode());
    }

    @Override
    public void highlight(ErrorValidationNode errorValidationNode) {
        AbstractXMLFormComponent abstractXMLFormComponent;
        Node node = errorValidationNode.getNode();
        if (node != null && (abstractXMLFormComponent = this.getBoundComponent(node)) != null) {
            abstractXMLFormComponent.setError(errorValidationNode.getMessage());
            this.setFocusTo(abstractXMLFormComponent);
        }
    }

    public List<Node> checkEmptyFields() {
        Document document = this.getDocument();
        NodeList nodeList = document.getElementsByTagName("*");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (element = (Element)node).getUserData("ui") == null) continue;
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                if (!this.isEmptyString(attr.getNodeValue())) continue;
                arrayList.add(attr);
            }
            if (!element.hasChildNodes()) continue;
            NodeList nodeList2 = element.getChildNodes();
            boolean bl = true;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (node2 instanceof Text) {
                    if (this.isEmptyString(((Text)node2).getNodeValue())) continue;
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    private boolean isEmptyString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void removeOldErrors() {
        if (this.lastErrors != null) {
            for (ErrorValidationNode errorValidationNode : this.lastErrors) {
                AbstractXMLFormComponent abstractXMLFormComponent;
                Node node = errorValidationNode.getNode();
                if (node == null || (abstractXMLFormComponent = this.getBoundComponent(node)) == null) continue;
                abstractXMLFormComponent.setError(null);
            }
            this.lastErrors = null;
            this.remove(this.errorsPanel);
            this.invalidate();
            this.validate();
            this.errorsPanel = null;
        }
    }

    public boolean validateDocument() {
        this.removeOldErrors();
        String string = this.form.getSchemaURI();
        if (string != null) {
            String string2 = this.form.getFormTemplateURI();
            String string3 = Toolkit.getAbsolutePath(string2, string);
            try {
                XSDValidator xSDValidator = new XSDValidator(string3);
                if (!xSDValidator.validate(this.getDocument())) {
                    String string4 = xSDValidator.getLastErrorMessage();
                    this.lastErrors = xSDValidator.getErrors();
                    if (this.lastErrors != null && this.lastErrors.size() > 0) {
                        this.errorsPanel = new EditorValidationErrorsPanel(this);
                        this.add((Component)this.errorsPanel, "South");
                        this.errorsPanel.init(this.lastErrors);
                        this.invalidate();
                        this.validate();
                        for (ErrorValidationNode errorValidationNode : this.lastErrors) {
                            AbstractXMLFormComponent abstractXMLFormComponent;
                            Node node = errorValidationNode.getNode();
                            if (node == null || (abstractXMLFormComponent = this.getBoundComponent(node)) == null) continue;
                            string4 = errorValidationNode.getMessage();
                            abstractXMLFormComponent.setError(errorValidationNode.getMessage());
                        }
                        AbstractXMLFormComponent abstractXMLFormComponent = this.getBoundComponent(this.lastErrors.get(0).getNode());
                        if (abstractXMLFormComponent != null) {
                            this.setFocusTo(abstractXMLFormComponent);
                        }
                    }
                    UIToolkit.dispatchError(Traductor.traduce("errors", "Error(s) found") + " : [ " + string4 + "]");
                    return false;
                }
            }
            catch (Exception exception) {
                ApplicationModel.debug(exception);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument(String string) throws Exception {
        if (!this.validateDocument() && !UIToolkit.confirm(Traductor.traduce("saveerror", "Your document contains some errors, could you confirm the saving operation ?"))) {
            return;
        }
        if (string.indexOf("://") > -1) {
            int n;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.saveDocument(string, byteArrayOutputStream);
            String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            OutputStream outputStream = uRLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            try {
                dataOutputStream.writeBytes("file=" + URLEncoder.encode(string2));
            }
            finally {
                dataOutputStream.close();
            }
            InputStream inputStream = uRLConnection.getInputStream();
            while ((n = inputStream.read()) != -1) {
            }
        } else {
            this.saveDocument(new File(string));
        }
    }

    public void saveDocument(File file) throws Exception {
        this.saveDocument(file.toString(), new FileOutputStream(file));
    }

    public void saveDocument(String string, OutputStream outputStream) throws Exception {
        Node node;
        Object object;
        String string2;
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        String string3 = this.getFormTemplateURI();
        Document document = this.getDocument();
        if (string3 != null) {
            string2 = null;
            string2 = Toolkit.areRelativeURI(string, string3) ? Toolkit.getRelativeURI(string3) : string3;
            object = document.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                ProcessingInstruction processingInstruction;
                Node node2 = object.item(i);
                if (!(node2 instanceof ProcessingInstruction) || !"xmlform".equals((processingInstruction = (ProcessingInstruction)node2).getTarget())) continue;
                document.removeChild(processingInstruction);
                break;
            }
            node = document.createProcessingInstruction("xmlform", string2);
            document.insertBefore(node, document.getDocumentElement());
        }
        if ((string2 = this.getSchemaURI()) != null) {
            object = null;
            object = Toolkit.areRelativeURI(string, string2) ? Toolkit.getRelativeURI(string2) : string2;
            node = document.getDocumentElement();
            node.setAttribute("xsi:noNamespaceSchemaLocation", (String)object);
            node.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        if (string2 != null) {
            object = document.getDocumentElement();
            object.removeAttribute("xsi:noNamespaceSchemaLocation");
            object.removeAttribute("xmlns:xsi");
        }
        EditorModel.CURRENT_DOCUMENT = string;
    }

    public void newDocument(File file) throws Exception {
        this.newDocument(file.toString(), new FileInputStream(file));
    }

    public void newDocument(String string) throws Exception {
        if (string.indexOf("://") > -1) {
            this.newDocument(string, new URL(string).openStream());
        } else {
            this.newDocument(new File(string));
        }
    }

    public void newDocument(String string, InputStream inputStream) throws Exception {
        XMLFormContainer xMLFormContainer = this.loadXMLForm(string, inputStream);
        this.initForm(xMLFormContainer);
        EditorModel.CURRENT_DOCUMENT = null;
        this.doc = null;
    }

    private XMLFormContainer loadXMLForm(String string) throws Exception {
        if (string.indexOf("://") > -1) {
            return this.loadXMLForm(string, new URL(string).openStream());
        }
        return this.loadXMLForm(string, new FileInputStream(string));
    }

    private void action(int n, Object object) {
        switch (n) {
            case 0: {
                this.setFocusTo((AbstractXMLFormComponent)object);
            }
        }
    }

    private XMLFormContainer loadXMLForm(String string, InputStream inputStream) throws Exception {
        this.removeOldErrors();
        this.components = new HashMap();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream, string);
        AbstractXMLFormComponent abstractXMLFormComponent = XMLDeserizalizer.build(document, false, null, this.components, new EditingContext(){

            @Override
            public XMLFormComponentFactory getComponentFactory() {
                return EditorComponent.this.getComponentFactory();
            }

            @Override
            public GrammarNodeTreeNode getCurrentTreeNode() {
                return null;
            }

            @Override
            public AbstractXMLFormComponent getComponentById(String string) {
                return (AbstractXMLFormComponent)EditorComponent.this.components.get(string);
            }

            @Override
            public void setComponentById(String string, AbstractXMLFormComponent abstractXMLFormComponent) {
                EditorComponent.this.components.put(string, abstractXMLFormComponent);
            }

            @Override
            public Collection<AbstractXMLFormComponent> getComponents() {
                return EditorComponent.this.components.values();
            }

            @Override
            public Document getDocument() {
                return EditorComponent.this.getDocument();
            }

            @Override
            public void action(int n, Object object) {
                EditorComponent.this.action(n, object);
            }
        });
        if (!(abstractXMLFormComponent instanceof XMLFormContainer)) {
            throw new Exception(Traductor.traduce("invalidform", "Invalid form document, no root component"));
        }
        XMLFormContainer xMLFormContainer = (XMLFormContainer)abstractXMLFormComponent;
        xMLFormContainer.setFormTemplateURI(string.toString());
        return xMLFormContainer;
    }
}

