/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer.data;

import com.japisoft.framework.xml.grammar.GrammarContainer;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class TreeDragDrop
extends TransferHandler
implements MouseMotionListener {
    private JTree tree = null;
    GrammarNodeTreeNode dragNode = null;

    public TreeDragDrop(JTree jTree) {
        this.tree = jTree;
        jTree.setTransferHandler(this);
        this.tree.addMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.exportAsDrag(this.tree, mouseEvent, 2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        GrammarNodeTreeNode grammarNodeTreeNode;
        JTree jTree = (JTree)jComponent;
        MouseEvent mouseEvent = (MouseEvent)inputEvent;
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (grammarNodeTreeNode = (GrammarNodeTreeNode)treePath.getLastPathComponent()).getUserObject() == null && grammarNodeTreeNode.getParent() != null) {
            GrammarNode grammarNode = grammarNodeTreeNode.getSource();
            if (grammarNode instanceof GrammarContainer) {
                return;
            }
            this.dragNode = grammarNodeTreeNode;
            super.exportAsDrag(jComponent, inputEvent, n);
        }
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        if (this.dragNode != null) {
            return new StringSelection("xpath:" + this.dragNode.toXPath());
        }
        return super.createTransferable(jComponent);
    }

    public int getSourceActions(JComponent jComponent) {
        return 2;
    }
}

