/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer;

import com.japisoft.xmlform.designer.DesignerComponent;
import com.japisoft.xmlform.designer.Factory;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.xml.FormatAction;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import com.japisoft.xmlpad.xml.validator.DefaultValidator;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DesignerEditor
extends JTabbedPane
implements IXMLPanel,
ChangeListener {
    private XMLContainer container = null;
    private Factory factory = null;
    private DesignerComponent ve = null;
    boolean addNotifyOk = false;

    public DesignerEditor(Factory factory) {
        super(3);
        this.factory = factory;
        this.container = factory.buildNewContainer();
        this.addTab("Source Editor", new ImageIcon(this.getClass().getResource("document_edit.png")), this.container.getView());
        this.ve = new DesignerComponent();
        this.addTab("Visual Editor", new ImageIcon(this.getClass().getResource("flash.png")), this.ve);
    }

    public void addNotify() {
        this.addNotifyOk = true;
        super.addNotify();
        this.addChangeListener(this);
        this.setSelectedIndex(1);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeChangeListener(this);
        this.addNotifyOk = false;
    }

    public void dispose() {
        this.container.dispose();
    }

    public Action getAction(String string) {
        if ("cut".equals(string) && this.getSelectedIndex() == 1) {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DesignerEditor.this.ve.cut();
                }
            };
        }
        return null;
    }

    public XMLContainer getMainContainer() {
        return this.container;
    }

    public XMLContainer getSelectedContainer() {
        return null;
    }

    public Iterator getProperties() {
        return this.container.getProperties();
    }

    public Object getProperty(String string, Object object) {
        return this.container.getProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.container.getProperty(string);
    }

    public XMLContainer getSubContainer(String string) {
        return this.container.getSubContainer(string);
    }

    public BookmarkContext getBookmarkContext() {
        return null;
    }

    public JComponent getView() {
        return this;
    }

    public void prepareToSave() {
        this.setSelectedIndex(0);
    }

    public void postLoad() {
        if (this.addNotifyOk) {
            this.removeChangeListener(this);
        }
        this.setSelectedIndex(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DesignerEditor.this.resetVisualData(false);
            }
        });
        if (this.addNotifyOk) {
            this.addChangeListener(this);
        }
    }

    public boolean reload() {
        return false;
    }

    public void setAutoDisposeMode(boolean bl) {
        this.container.setAutoDisposeMode(bl);
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        this.container.setDocumentInfo(xMLDocumentInfo);
    }

    public void setProperty(String string, Object object) {
        this.container.setProperty(string, object);
    }

    private void resetVisualData(boolean bl) {
        if (this.container.getRootNode() != null || !bl) {
            DefaultValidator defaultValidator = new DefaultValidator(true);
            if (!defaultValidator.validate(this.container, false)) {
                this.factory.buildAndShowErrorDialog("Error found inside the source\nPlease fix it before using the visual editor");
                this.setSelectedIndex(0);
            } else {
                Document document = defaultValidator.getDocument();
                if (document.getDocumentElement() == null) {
                    Element element = document.createElement("xf");
                    element.setAttribute("appVersion", "1.0");
                    document.appendChild(element);
                }
                try {
                    this.ve.load(this.container.getCurrentDocumentLocation(), document);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("E");
                }
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getSelectedIndex() == 1) {
            this.resetVisualData(true);
        } else {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                this.ve.save(document);
                FormatAction formatAction = (FormatAction)ActionModel.getActionByName(ActionModel.FORMAT_ACTION);
                XMLContainer xMLContainer = formatAction.getXMLContainer();
                formatAction.setXMLContainer(this.container);
                formatAction.formatAction(document);
                formatAction.setXMLContainer(xMLContainer);
            }
            catch (Exception exception) {
                this.factory.buildAndShowErrorDialog("Can't generate the source [" + exception.getMessage() + "]");
            }
        }
    }
}

