/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.universalbrowser;

import com.japisoft.framework.ui.FastLabel;
import com.japisoft.universalbrowser.FileFilter;
import com.japisoft.universalbrowser.FileObjectTreeNode;
import com.japisoft.universalbrowser.FileView;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

class TreeCellRendererImpl
implements TreeCellRenderer {
    FastLabel fastlabel = new FastLabel(false);
    Icon drive = null;
    Icon document = null;
    Icon folder = null;
    Icon folder_closed = null;
    FileView fv = null;
    FileFilter filter = null;

    public TreeCellRendererImpl() {
        try {
            this.drive = new ImageIcon(this.getClass().getResource("diskdrive.png"));
            this.document = new ImageIcon(this.getClass().getResource("document.png"));
            this.folder = new ImageIcon(this.getClass().getResource("folder.png"));
            this.folder_closed = new ImageIcon(this.getClass().getResource("folder_closed.png"));
        }
        catch (Throwable throwable) {
            System.err.println("Can't init icons ? : " + throwable.getMessage());
        }
    }

    void setFileView(FileView fileView) {
        this.fv = fileView;
    }

    void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        if (!(object instanceof FileObjectTreeNode)) {
            this.fastlabel.setBackground(jTree.getBackground());
            this.fastlabel.setForeground(Color.RED);
            this.fastlabel.setText(object.toString());
            return this.fastlabel;
        }
        FileObjectTreeNode fileObjectTreeNode = (FileObjectTreeNode)object;
        Icon icon = null;
        icon = fileObjectTreeNode.isRoot() ? this.drive : (fileObjectTreeNode.isFolder() ? (!bl2 ? this.folder_closed : this.folder) : this.document);
        if (this.fv != null && !fileObjectTreeNode.isRoot() && (object2 = this.fv.getIcon(fileObjectTreeNode.getSource())) != null) {
            icon = object2;
        }
        this.fastlabel.setIcon(icon);
        this.fastlabel.setText(fileObjectTreeNode.toString());
        if (bl) {
            this.fastlabel.setForeground(UIManager.getColor("List.selectionForeground"));
            this.fastlabel.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            object2 = jTree.getForeground();
            Color color = jTree.getBackground();
            if (this.fv != null && !fileObjectTreeNode.isRoot()) {
                Color color2 = this.fv.getForeground(fileObjectTreeNode.getSource());
                if (color2 != null) {
                    object2 = color2;
                }
                if ((color2 = this.fv.getBackground(fileObjectTreeNode.getSource())) != null) {
                    color = color2;
                }
            }
            if (this.filter != null && !fileObjectTreeNode.isRoot() && !this.filter.accept(fileObjectTreeNode.getSource())) {
                object2 = color.darker().darker();
            }
            this.fastlabel.setForeground((Color)object2);
            this.fastlabel.setBackground(color);
        }
        this.fastlabel.setToolTipText(jTree.getToolTipText());
        return this.fastlabel;
    }
}

