/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.grammar.xsd;

import com.japisoft.framework.xml.DOMToolkit;
import com.japisoft.framework.xml.grammar.GrammarElement;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.framework.xml.grammar.GrammarText;
import com.japisoft.framework.xml.grammar.GrammarType;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammar;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarAttribute;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarContainer;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarElement;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarText;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDGrammarType
implements GrammarType {
    private String type = null;
    private Document doc = null;
    private ArrayList<GrammarNode> children = null;

    public XSDGrammarType(String string) {
        this.type = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDGrammarType(Element element) {
        this.doc = element.getOwnerDocument();
        try {
            this.processElement(element);
        }
        finally {
            this.doc = null;
        }
    }

    private void processElement(Element element) {
        Element element2 = element;
        if (element.hasAttribute("ref") && (element = this.resolveRef(element)) == null) {
            element = element2;
        }
        this.type = element.getAttribute("type");
        if (element.hasAttribute("base")) {
            this.type = element.getAttribute("base");
        }
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element3 = (Element)nodeList.item(i);
            if ("simpleType".equals(element3.getLocalName())) {
                node = element3;
                break;
            }
            if (!"complexType".equals(element3.getLocalName())) continue;
            node = element3;
            break;
        }
        if (node == null && !"".equals(this.type)) {
            node = this.resolveType(this.type);
        }
        if (node != null) {
            if ("simpleType".equals(node.getLocalName())) {
                this.processSimpleType((Element)node);
            } else {
                this.processComplexType(element2, (Element)node);
            }
        } else {
            this.type = this.extractLocalType(element.getAttribute("type"), element);
        }
    }

    private void processComplexContent(Element element) {
        Element element2 = DOMToolkit.getFirstElement(element, "restriction");
        if (element2 == null) {
            element2 = DOMToolkit.getFirstElement(element, "extension");
        }
        if (element2 != null) {
            String string = element2.getAttribute("base");
            Element element3 = this.resolveType(string);
            if (element3 != null) {
                this.processElement(element3);
            }
            this.processComplexParts(element);
        }
    }

    private String processSimpleContent(Element element) {
        Element element2 = DOMToolkit.getFirstElement(element, "restriction");
        if (element2 == null) {
            element2 = DOMToolkit.getFirstElement(element, "extension");
        }
        if (element2 != null) {
            String string = element2.getAttribute("base");
            Element element3 = this.resolveType(string);
            if (element3 != null) {
                this.processSimpleType(element3);
            } else {
                String string2 = this.extractLocalType(string, element2);
                if (string2 != null) {
                    GrammarText grammarText = this.getFirstTextGrammarNode();
                    if (grammarText != null) {
                        this.removeGrammarNode(grammarText);
                    }
                    this.addGrammarNodeValue(new XSDGrammarText(null, new XSDGrammarType(string2)));
                }
            }
            this.processComplexParts(element2);
            return string;
        }
        return null;
    }

    void processComplexParts(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI())) continue;
                if ("sequence".equals(node.getLocalName()) || "choice".equals(node.getLocalName()) || "all".equals(node.getLocalName())) {
                    this.addGrammarNodeValue(new XSDGrammarContainer((Element)node));
                    continue;
                }
                if ("element".equals(node.getLocalName())) {
                    this.addElementValue((Element)node);
                    continue;
                }
                if (!"attribute".equals(node.getLocalName())) continue;
                this.addAttributeValue((Element)node);
            }
        }
    }

    void processSimpleType(Element element) {
        Object object;
        Element element2 = DOMToolkit.getFirstElement(element, "restriction");
        if (element2 == null) {
            element2 = DOMToolkit.getFirstElement(element, "extension");
        }
        if (element2 != null) {
            this.type = element2.getAttribute("base");
            object = this.resolveType(this.type);
            if (object != null) {
                this.processSimpleContent((Element)object);
            }
        } else {
            this.type = this.extractLocalType(element2.getAttribute("base"), element);
        }
        object = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "enumeration");
        for (int i = 0; i < object.getLength(); ++i) {
            this.addEnumValue((Element)object.item(i));
        }
    }

    void processComplexType(Element element, Element element2) {
        this.type = "complex";
        Element element3 = DOMToolkit.getFirstElement(element2, "simpleContent");
        if (element3 != null) {
            this.processSimpleContent(element3);
        } else {
            element3 = DOMToolkit.getFirstElement(element2, "complexContent");
            if (element3 != null) {
                this.processComplexContent(element3);
            } else {
                this.processComplexParts(element2);
            }
        }
    }

    private Element resolveType(String string) {
        NodeList nodeList = this.doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"simpleType".equals((element = (Element)nodeList.item(i)).getLocalName()) && !"complexType".equals(element.getLocalName()) || !string.equals(element.getAttribute("name"))) continue;
            return element;
        }
        return null;
    }

    private Element resolveRef(Element element) {
        String string = element.getAttribute("ref");
        List<GrammarElement> list = XSDGrammar.getGlobalComponent(this.doc, "element");
        for (GrammarElement grammarElement : list) {
            Element element2 = ((XSDGrammarElement)grammarElement).getDOMElement();
            if (!element2.getAttribute("name").equals(string)) continue;
            return element2;
        }
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    private void addEnumValue(Element element) {
        this.addGrammarNodeValue(new XSDGrammarText(element.getAttribute("value")));
    }

    private void addAttributeValue(Element element) {
        this.addGrammarNodeValue(new XSDGrammarAttribute(element));
    }

    private void addElementValue(Element element) {
        this.addGrammarNodeValue(new XSDGrammarElement(element));
    }

    private void addGrammarNodeValue(GrammarNode grammarNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(grammarNode);
    }

    private void removeGrammarNode(GrammarNode grammarNode) {
        if (this.children != null) {
            this.children.remove(grammarNode);
        }
    }

    private GrammarText getFirstTextGrammarNode() {
        if (this.children == null) {
            return null;
        }
        for (GrammarNode grammarNode : this.children) {
            if (!(grammarNode instanceof GrammarText)) continue;
            return (GrammarText)grammarNode;
        }
        return null;
    }

    @Override
    public List<GrammarNode> getValues() {
        return this.children;
    }

    private String extractLocalType(String string, Element element) {
        String string2;
        if (string != null && (string2 = this.getRootPrefix(element)) != null && string.startsWith(string2 + ":")) {
            string = string.substring(string2.length() + 1);
            return string;
        }
        return null;
    }

    protected String getRootPrefix(Node node) {
        Document document = node.getOwnerDocument();
        Element element = document.getDocumentElement();
        return element.getPrefix();
    }
}

