/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.grammar.xsd;

import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.framework.xml.grammar.GrammarType;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarType;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSDGrammarNode
implements GrammarNode {
    protected Node node = null;
    protected int minOccurs = 1;
    protected int maxOccurs = 1;
    protected GrammarType type = null;

    public XSDGrammarNode(Node node) {
        this.node = node;
        if (node instanceof Element) {
            Element element = (Element)node;
            if (element.hasAttribute("minOccurs")) {
                try {
                    this.minOccurs = Integer.parseInt(element.getAttribute("minOccurs"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (element.hasAttribute("maxOccurs")) {
                if ("unbounded".equalsIgnoreCase(element.getAttribute("maxOccurs"))) {
                    this.maxOccurs = Integer.MAX_VALUE;
                } else {
                    try {
                        this.maxOccurs = Integer.parseInt(element.getAttribute("maxOccurs"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public String getName() {
        return this.node.getLocalName();
    }

    public String getNamespace() {
        return null;
    }

    public GrammarType getType() {
        if (this.type == null) {
            this.type = new XSDGrammarType((Element)this.node);
        }
        return this.type;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public Node getDOMSource() {
        return this.node;
    }

    public Element getDOMElement() {
        return (Element)this.node;
    }

    public void dump() {
        this.dump(0);
    }

    public void dump(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
        System.out.println("node " + this.getName() + " / " + this.getClass());
        GrammarType grammarType = this.getType();
        List<GrammarNode> list = grammarType.getValues();
        if (list != null) {
            for (GrammarNode grammarNode : list) {
                if (!(grammarNode instanceof XSDGrammarNode)) continue;
                ((XSDGrammarNode)grammarNode).dump(n + 1);
            }
        }
    }
}

