/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.action;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dialog.BasicOKCancelDialogComponent;
import com.japisoft.framework.dialog.actions.OKAction;
import com.japisoft.framework.ui.SimpleFileFilter;
import com.japisoft.framework.xml.action.CustomEntityResolver;
import com.japisoft.framework.xml.action.XMLCatalogAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;

public class XMLCatalogDialog
extends BasicOKCancelDialogComponent {
    DefaultTableModel tableModel = null;
    JTable tb;

    public XMLCatalogDialog() {
        super(ApplicationModel.MAIN_FRAME, "XML Catalog", "XML Catalog", "Use your OASIS XML Catalogs for Parsing...\nNote that if you modify a catalog you must reload " + ApplicationModel.SHORT_APPNAME, null);
        this.initUI();
    }

    private void initUI() {
        this.tableModel = new DefaultTableModel(new String[]{"Catalog path"}, 0);
        this.tb = new JTable(this.tableModel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(new JScrollPane(this.tb));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new AddAction());
        jToolBar.add(new RemoveAction());
        jPanel.add((Component)jToolBar, "South");
        this.setUI(jPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeClosing() {
        super.beforeClosing();
        if (this.getLastAction() == OKAction.ID) {
            File file = XMLCatalogAction.getCatalogLstPath();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                try {
                    for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                        bufferedWriter.write((String)this.tableModel.getValueAt(i, 0));
                        bufferedWriter.newLine();
                    }
                }
                finally {
                    bufferedWriter.close();
                }
                CustomEntityResolver.getInstance().loadCatalogs();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeShowing() {
        super.beforeShowing();
        File file = XMLCatalogAction.getCatalogLstPath();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        this.tableModel.addRow(new Object[]{string});
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", "Remove");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = XMLCatalogDialog.this.tb.getSelectedRow();
            if (n > -1) {
                XMLCatalogDialog.this.tableModel.removeRow(n);
            }
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", "Add");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.addChoosableFileFilter(new SimpleFileFilter("XML catalog", "xml"));
            if (jFileChooser.showOpenDialog(XMLCatalogDialog.this) == 0) {
                XMLCatalogDialog.this.tableModel.addRow(new Object[]{jFileChooser.getSelectedFile().toString()});
            }
        }
    }
}

