/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XMLToolkit;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

public final class XMLParser {
    public static String DEF_PARSER_NAME = "XERCES";
    public static String DEF_PARSER_CLASS = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
    public static String DEF_LIBRARY_PATH = "parser";
    private static Class DEF_PARSER = null;
    private static boolean ERROR_FOUND = false;
    private static boolean NAMESPACEAWARE = false;
    private static boolean SCHEMAAWARE = true;
    private static SAXParserFactory FACTORY = null;

    public static void resetDefaultParser() {
        NAMESPACEAWARE = Preferences.getPreference("xmlconfig", "namespaceAware", true);
        if (Preferences.getPreference("xmlconfig", "xinclude", true)) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XIncludeParserConfiguration");
        }
        ApplicationModel.debug("Reset the default parser");
        if (DEF_PARSER == null && !ERROR_FOUND && !XMLParser.loadByConfigFile()) {
            String string = Preferences.getPreference(Preferences.SYSTEM_GP, "xmlparser", DEF_PARSER_NAME);
            ApplicationModel.debug("Reset from the preference " + string);
            if (!DEF_PARSER_NAME.equals(string)) {
                ApplicationModel.debug("Load from " + DEF_LIBRARY_PATH);
                ArrayList arrayList = XMLToolkit.browseJars(DEF_LIBRARY_PATH);
                if (arrayList.size() == 0) {
                    try {
                        DEF_PARSER = Class.forName(string);
                    }
                    catch (Throwable throwable) {
                        System.err.println("Can't use the " + string + " class");
                        ERROR_FOUND = true;
                    }
                } else {
                    URL[] uRLArray = new URL[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        uRLArray[i] = (URL)arrayList.get(i);
                    }
                    try {
                        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                        DEF_PARSER = uRLClassLoader.loadClass(string);
                        ApplicationModel.debug("Find " + DEF_PARSER);
                    }
                    catch (Throwable throwable) {
                        System.err.println("Can't use " + string + " : " + throwable.getMessage());
                        ERROR_FOUND = true;
                    }
                }
            }
        }
    }

    static boolean loadByConfigFile() {
        try {
            ApplicationModel.debug("Load jaxp_parser.dat");
            Class clazz = XMLToolkit.loadByConfigFile(new File(ApplicationModel.getAppUserPath(), "jaxp_parser.dat"));
            if (clazz != null) {
                ApplicationModel.debug("Class found " + clazz);
                DEF_PARSER = clazz;
                return true;
            }
            ApplicationModel.debug("No class found");
        }
        catch (Exception exception) {
            ApplicationModel.debug(exception);
        }
        return false;
    }

    public static SAXParserFactory getSAXParserFactory() {
        XMLParser.resetDefaultParser();
        SAXParserFactory sAXParserFactory = null;
        if (DEF_PARSER != null) {
            try {
                sAXParserFactory = (SAXParserFactory)DEF_PARSER.newInstance();
            }
            catch (Throwable throwable) {
                System.err.println("Can't use " + DEF_PARSER + " : " + throwable.getMessage());
            }
        }
        if (DEF_PARSER == null) {
            try {
                DEF_PARSER = Class.forName(DEF_PARSER_CLASS);
                sAXParserFactory = (SAXParserFactory)DEF_PARSER.newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException("ERROR CAN'T FIND " + DEF_PARSER_CLASS + "???");
            }
        }
        sAXParserFactory.setNamespaceAware(NAMESPACEAWARE);
        ApplicationModel.debug("Use the factory " + sAXParserFactory);
        return sAXParserFactory;
    }

    public static SAXParserFactory getSaxParserFactory(boolean bl) throws Exception {
        if (FACTORY == null) {
            FACTORY = XMLParser.getSAXParserFactory();
        }
        FACTORY.setValidating(bl);
        try {
            FACTORY.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return FACTORY;
    }

    public static SAXParser getSaxParser(boolean bl) throws Exception {
        SAXParser sAXParser = XMLParser.getSaxParserFactory(bl).newSAXParser();
        ApplicationModel.debug("Use the parser " + sAXParser + " / validating : " + bl);
        return sAXParser;
    }
}

