/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.job;

import com.japisoft.framework.job.FastJob;
import com.japisoft.framework.job.HeavyJob;
import com.japisoft.framework.job.HeavyJobProxy;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManagerListener;
import com.japisoft.framework.job.KnownJob;
import com.japisoft.framework.job.SwingEventSynchro;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class JobManager
implements Runnable {
    public static int JOB_DELAY_BOUND;
    private Vector workList = new Vector();
    private boolean aliveMode = false;
    private static int ADAPTING_JOB_DELAY;
    public static JobManager COMMON_MANAGER;
    private static Thread COMMON_MANAGER_THREAD;
    private static JobManagerListener listener;
    private boolean flushJobs = false;
    private Runnable runningJob;
    public static boolean working;
    static Vector lstHeavyJob;

    public void run() {
        try {
            boolean bl = false;
            while (this.aliveMode) {
                this.flushJobs = false;
                Thread.sleep(ADAPTING_JOB_DELAY);
                this.flushJobs = true;
                bl = this.runAll();
                if (bl) {
                    ADAPTING_JOB_DELAY = JOB_DELAY_BOUND / 2;
                    continue;
                }
                ADAPTING_JOB_DELAY = JOB_DELAY_BOUND;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setJobManagerListener(JobManagerListener jobManagerListener) {
        listener = jobManagerListener;
    }

    public static boolean isRunning(Job job) {
        return JobManager.COMMON_MANAGER.runningJob == job;
    }

    public static void addJob(Job job) {
        boolean bl = true;
        boolean bl2 = false;
        if (job instanceof HeavyJob) {
            COMMON_MANAGER.run((HeavyJob)job);
        } else {
            if (job.isAlone()) {
                Object object = job.getSource();
                try {
                    for (int i = 0; i < JobManager.COMMON_MANAGER.workList.size(); ++i) {
                        JobWrapper jobWrapper = (JobWrapper)JobManager.COMMON_MANAGER.workList.get(i);
                        Job job2 = jobWrapper.job;
                        if (job2.getSource() != object || job2.getClass() != job.getClass()) continue;
                        jobWrapper.markedStopped = true;
                        job2.stopIt();
                        bl2 = true;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (COMMON_MANAGER_THREAD == null || !COMMON_MANAGER_THREAD.isAlive()) {
                COMMON_MANAGER_THREAD = new Thread((Runnable)COMMON_MANAGER, "COMMON_MANAGER_THREAD");
                JobManager.COMMON_MANAGER.aliveMode = true;
                COMMON_MANAGER_THREAD.start();
            }
            JobManager.COMMON_MANAGER.workList.add(new JobWrapper(job));
        }
    }

    public void dispose() {
        this.aliveMode = false;
        COMMON_MANAGER.notify();
        try {
            COMMON_MANAGER_THREAD.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isTerminated(String string) {
        try {
            for (int i = 0; i < this.workList.size(); ++i) {
                Object e = this.workList.get(i);
                if (!(e instanceof KnownJob) || !string.equals(((KnownJob)e).getName())) continue;
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private synchronized boolean runAll() throws InterruptedException {
        int n;
        if (this.workList.size() == 0) {
            working = false;
            return true;
        }
        boolean bl = true;
        Object[] objectArray = this.workList.toArray();
        working = objectArray.length > 0;
        for (n = 0; n < objectArray.length; ++n) {
            JobWrapper jobWrapper = (JobWrapper)objectArray[n];
            if (jobWrapper.markedStopped) continue;
            this.runningJob = jobWrapper.job;
            this.run(this.runningJob);
            this.runningJob = null;
            if (!(jobWrapper.job instanceof FastJob)) {
                bl = false;
            }
            this.dispose(jobWrapper.job);
            Thread.yield();
            Thread.sleep(5L);
        }
        for (n = 0; n < objectArray.length; ++n) {
            this.workList.remove(objectArray[n]);
        }
        working = false;
        return bl;
    }

    public static boolean isTaskWorking(Class[] classArray) {
        Object[] objectArray = JobManager.COMMON_MANAGER.workList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            JobWrapper jobWrapper = (JobWrapper)objectArray[i];
            if (jobWrapper.markedStopped) continue;
            for (int j = 0; j < classArray.length; ++j) {
                if (jobWrapper.job.getClass() != classArray[j]) continue;
                return true;
            }
        }
        return false;
    }

    private void run(Runnable runnable) {
        try {
            if (listener != null && runnable instanceof KnownJob) {
                this.notifyStartJob((KnownJob)runnable, false);
            }
            if (runnable instanceof SwingEventSynchro) {
                boolean bl = ((SwingEventSynchro)((Object)runnable)).preRun();
                if (bl) {
                    SwingUtilities.invokeAndWait(runnable);
                }
            } else {
                runnable.run();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (listener != null && runnable instanceof KnownJob) {
            this.notifyStopJob((KnownJob)runnable, false);
        }
    }

    void notifyStartJob(KnownJob knownJob, boolean bl) {
        if (listener != null) {
            listener.startKnownJob(knownJob, knownJob.getName(), bl);
        }
        if (bl) {
            if (lstHeavyJob == null) {
                lstHeavyJob = new Vector();
            }
            lstHeavyJob.add(knownJob.getName());
        }
    }

    void notifyStopJob(KnownJob knownJob, boolean bl) {
        if (listener != null) {
            listener.stopKnownJob(knownJob.getName(), knownJob.getErrorMessage(), bl);
        }
        if (bl) {
            lstHeavyJob.remove(knownJob.getName());
        }
    }

    private void run(HeavyJob heavyJob) {
        new Thread(new HeavyJobProxy(heavyJob)).start();
    }

    private void dispose(Object object) {
        if (object instanceof Job) {
            try {
                ((Job)object).dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getHeavyJobCount() {
        if (lstHeavyJob == null) {
            return 0;
        }
        return lstHeavyJob.size();
    }

    public static String getHeavyJob(int n) {
        if (lstHeavyJob == null) {
            return null;
        }
        return (String)lstHeavyJob.get(n);
    }

    public static JPopupMenu buildPopupForHeavyJob() {
        if (lstHeavyJob != null) {
            Object[] objectArray = lstHeavyJob.toArray();
            if (objectArray.length == 0) {
                return null;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < objectArray.length; ++i) {
                jPopupMenu.add(new JMenuItem((String)objectArray[i]));
            }
            return jPopupMenu;
        }
        return null;
    }

    static {
        ADAPTING_JOB_DELAY = JOB_DELAY_BOUND = 100;
        COMMON_MANAGER = new JobManager();
        COMMON_MANAGER_THREAD = null;
        listener = null;
        working = false;
        lstHeavyJob = null;
    }

    static class JobWrapper {
        Job job;
        boolean markedStopped;

        public JobWrapper(Job job) {
            this.job = job;
        }
    }
}

