/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.BasicInnerWindow;
import com.japisoft.framework.dockable.BasicStatusBar;
import com.japisoft.framework.dockable.ComponentFactory;
import com.japisoft.framework.dockable.ComponentIdable;
import com.japisoft.framework.dockable.DefaultState;
import com.japisoft.framework.dockable.DockManager;
import com.japisoft.framework.dockable.DockableLayout;
import com.japisoft.framework.dockable.InnerWindowProperties;
import com.japisoft.framework.dockable.JDockEvent;
import com.japisoft.framework.dockable.JDockException;
import com.japisoft.framework.dockable.JDockListener;
import com.japisoft.framework.dockable.JDockSource;
import com.japisoft.framework.dockable.State;
import com.japisoft.framework.dockable.Windowable;
import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.dockable.action.common.ExtractAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JDock {
    CustomMouseListener listener1 = null;
    ArrayList leftComponent = null;
    ArrayList rightComponent = null;
    ArrayList topComponent = null;
    ArrayList bottomComponent = null;
    private boolean shadowMode = true;
    boolean visibleMode = false;
    InnerPanel panel = null;
    private JMenu menuWindow = null;
    JComponent finalView = null;
    BasicStatusBar statusBarView = null;
    private boolean statusBarEnabled = false;
    private boolean enabledActionPopup = true;
    private Dimension minimalInnerWindowSize = null;
    private Hashtable htComponent2ComponentIdable = null;
    private Hashtable htHiddenWindow = null;
    private Point lastPoint;
    private boolean horizontal = false;
    private BasicInnerWindow draggingFrame = null;
    private Rectangle draggingBorder = null;
    private Rectangle matchingBorder = new Rectangle(-1, -1, -1, -1);
    private Component selectedComponent = null;
    private Component lastSelectedComponent = null;
    private Point initialPoint = null;
    private boolean showDraggingShadow = true;
    private Cursor lastCursor = null;
    private Color draggingShadowColor = Color.black;
    private Color draggingActiveWindow = Color.red;
    private Color resizingShadowColor = Color.black;
    ArrayList listeners = null;
    private boolean showResizeShadow = true;

    public JDock() {
        this.panel = this.createInnerView();
    }

    public JDock(boolean bl) {
        this();
        if (!bl) {
            this.setShadowMode(bl);
        }
    }

    protected InnerPanel createInnerView() {
        return new InnerPanel();
    }

    public void setShadowMode(boolean bl) {
        this.shadowMode = bl;
        this.checkLayout();
        ((DockableLayout)this.panel.getLayout()).borderX = bl ? 5 : 3;
        ((DockableLayout)this.panel.getLayout()).borderY = bl ? 5 : 3;
    }

    public boolean isShadowMode() {
        return this.shadowMode;
    }

    protected void setUIReady(boolean bl) {
    }

    public void setLayout(LayoutManager2 layoutManager2) {
        if (this.panel.getLayout() instanceof DockableLayout) {
            ((DockableLayout)this.panel.getLayout()).dispose();
        }
        this.panel.setLayout(new DockableLayout(this, layoutManager2));
    }

    public void setMenuWindow(JMenu jMenu) {
        this.menuWindow = jMenu;
    }

    private void addBasicInnerWindowsForMenu(BasicInnerWindow basicInnerWindow) {
        String string = basicInnerWindow.getId();
        String string2 = basicInnerWindow.getTitle();
        if (string2 == null) {
            string2 = string;
        }
        HideShowAction hideShowAction = new HideShowAction(string2, string);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(hideShowAction);
        jCheckBoxMenuItem.setSelected(basicInnerWindow.getView().getParent() != null);
        this.menuWindow.add(jCheckBoxMenuItem);
    }

    private void buildMenuWindow() {
        if (this.menuWindow != null && this.menuWindow.getMenuComponentCount() == 0) {
            Object object;
            for (int i = 0; i < this.panel.getComponentCount(); ++i) {
                object = this.panel.getComponent(i);
                if (!(object instanceof BasicInnerWindow)) continue;
                BasicInnerWindow basicInnerWindow = (BasicInnerWindow)object;
                this.addBasicInnerWindowsForMenu(basicInnerWindow);
            }
            if (this.hasHiddenWindows()) {
                Enumeration enumeration = this.hiddenWindows();
                while (enumeration.hasMoreElements()) {
                    object = (Windowable)enumeration.nextElement();
                    if (!(object instanceof BasicInnerWindow)) continue;
                    this.addBasicInnerWindowsForMenu((BasicInnerWindow)object);
                }
            }
        }
    }

    public void dispose() {
        DockManager.removeAllDockedFrame();
        DockManager.LAST_FOCUS = null;
        if (this.panel.getLayout() instanceof DockableLayout) {
            ((DockableLayout)this.panel.getLayout()).dispose();
        }
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            if (!(this.panel.getComponent(i) instanceof BasicInnerWindow)) continue;
            BasicInnerWindow basicInnerWindow = (BasicInnerWindow)this.panel.getComponent(i);
            basicInnerWindow.dispose();
        }
        if (this.menuWindow != null) {
            this.menuWindow.removeAll();
        }
        this.menuWindow = null;
        this.htComponent2ComponentIdable = null;
        if (this.statusBarView != null) {
            this.statusBarView.dispose();
        }
    }

    boolean isUIReady() {
        return this.visibleMode;
    }

    private void checkInvalidate() {
        if (this.visibleMode) {
            this.panel.invalidate();
            this.panel.validate();
        }
    }

    public void add(JComponent jComponent, Object object) {
        this.addInnerWindow(jComponent, object);
    }

    public void addInnerWindow(InnerWindowProperties innerWindowProperties, Object object) {
        if (innerWindowProperties == null) {
            throw new JDockException("properties can't be null");
        }
        if (innerWindowProperties.getIcon() != null && innerWindowProperties.getIcon().getIconHeight() != 16 && innerWindowProperties.getIcon().getIconWidth() != 16) {
            throw new JDockException("Invalid icon, must be 16x16 !");
        }
        this.checkLayout();
        if (((DockableLayout)this.panel.getLayout()).isConstraintsKnown(object)) {
            throw new JDockException("You can't reuse the same constraint for different added components");
        }
        this.panel.add((Component)new BasicInnerWindow(innerWindowProperties), object);
        this.checkForStatusBar();
        this.checkInvalidate();
    }

    private void checkForStatusBar() {
        if (this.visibleMode && this.statusBarView != null) {
            this.statusBarView.prepare(this);
        }
    }

    public void addInnerWindow(JComponent jComponent, Object object) {
        this.checkLayout();
        if (((DockableLayout)this.panel.getLayout()).isConstraintsKnown(object)) {
            throw new JDockException("You can't reuse the same constraint for different added components");
        }
        this.panel.add((Component)jComponent, object);
        this.checkForStatusBar();
        this.checkInvalidate();
    }

    private void checkLayout() {
        if (!(this.panel.getLayout() instanceof DockableLayout)) {
            this.setLayout(new BorderLayout());
        }
    }

    JComponent getDockingView() {
        return this.panel;
    }

    public JComponent getView() {
        if (this.finalView == null) {
            if (!this.statusBarEnabled) {
                this.finalView = this.panel;
            } else {
                this.finalView = new JPanel();
                this.finalView.setLayout(new BorderLayout());
                this.finalView.add((Component)this.panel, "Center");
                this.statusBarView = new BasicStatusBar();
                this.finalView.add((Component)this.statusBarView, "South");
            }
        }
        return this.finalView;
    }

    public void setEnabledStatusBar(boolean bl) {
        this.statusBarEnabled = bl;
        if (this.statusBarView != null) {
            if (bl && this.statusBarView.getParent() == null) {
                this.getView().add((Component)this.statusBarView, "South");
            } else if (!bl) {
                this.getView().remove(this.statusBarView);
            }
            this.getView().invalidate();
            this.getView().validate();
        }
    }

    public boolean isEnabledStatusBar() {
        return this.statusBarEnabled;
    }

    public void setEnabledActionPopup(boolean bl) {
        this.enabledActionPopup = bl;
    }

    public boolean isEnabledActionPopup() {
        return this.enabledActionPopup;
    }

    public void setMinimalInnerWindowSize(Dimension dimension) {
        this.minimalInnerWindowSize = dimension;
    }

    public Dimension getMinimalInnerWindowSize() {
        if (this.minimalInnerWindowSize == null) {
            this.minimalInnerWindowSize = new Dimension(10, 10);
        }
        return this.minimalInnerWindowSize;
    }

    public State getState() {
        DefaultState defaultState = new DefaultState();
        defaultState.read(this);
        return defaultState;
    }

    public void setState(State state) {
        if (!(state instanceof DefaultState)) {
            throw new JDockException("Unknown state class");
        }
        ((DefaultState)state).write(this);
        this.panel.doLayout();
        this.panel.repaint();
    }

    Windowable getInnerWindowForId(String string) {
        Object object;
        int n;
        if (string == null) {
            throw new JDockException("Invalid id : " + string + " ?");
        }
        for (n = 0; n < this.panel.getComponentCount(); ++n) {
            if (!(this.panel.getComponent(n) instanceof Windowable) || !string.equals((object = (Windowable)((Object)this.panel.getComponent(n))).getId())) continue;
            return object;
        }
        for (n = 0; n < this.panel.getComponentCount(); ++n) {
            ComponentIdable componentIdable;
            JComponent jComponent;
            object = this.panel.getComponent(n);
            if (!(object instanceof JComponent) || !string.equals((jComponent = (JComponent)object).getName())) continue;
            if (this.htComponent2ComponentIdable == null) {
                this.htComponent2ComponentIdable = new Hashtable();
            }
            if ((componentIdable = (ComponentIdable)this.htComponent2ComponentIdable.get(jComponent)) == null) {
                componentIdable = new ComponentIdable(jComponent);
                this.htComponent2ComponentIdable.put(jComponent, componentIdable);
            }
            return componentIdable;
        }
        return null;
    }

    public String getInnerWindowTitleForId(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            return windowable.getTitle();
        }
        return null;
    }

    public boolean isInnerWindowFixed(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            return false;
        }
        return windowable.isFixed();
    }

    public void setInnerWindowFixed(String string, boolean bl) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        windowable.setFixed(bl);
    }

    public void setInnerWindowResizable(String string, boolean bl) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        windowable.setResizable(bl);
    }

    public boolean isInnerWindowResizable(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        return windowable.isResizable();
    }

    public ActionModel getInnerWindowActionsForId(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            return windowable.getActionModel();
        }
        return null;
    }

    public void setInnerWindowTitleForId(String string, String string2) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        windowable.setTitle(string2);
    }

    public void setInnerWindowIconForId(String string, Icon icon) {
        if (icon != null && icon.getIconHeight() != 16 && icon.getIconWidth() != 16) {
            throw new JDockException("Invalid icon must be 16x16 !");
        }
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            windowable.setIcon(icon);
        }
    }

    public Icon getInnerWindowIconForId(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            return windowable.getIcon();
        }
        return null;
    }

    public void setInnerWindowBackgroundForId(String string, Color color) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            windowable.setBackground(color);
        }
    }

    public void setInnerWindowForegroundForId(String string, Color color) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            windowable.setForeground(color);
        }
    }

    public JComponent getInnerWindowViewForId(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            return windowable.getUserView();
        }
        return null;
    }

    public void removeInnerWindow(String string) {
        if (string == null) {
            throw new JDockException("Invalid null id ");
        }
        Windowable windowable = this.getInnerWindowForId(string);
        if (this.htHiddenWindow != null) {
            if (this.htHiddenWindow.containsKey(string)) {
                windowable = (Windowable)this.htHiddenWindow.get(string);
            }
            this.htHiddenWindow.remove(string);
        }
        if (windowable != null) {
            if (this.htComponent2ComponentIdable != null && this.htComponent2ComponentIdable.get(windowable.getView()) != null) {
                this.htComponent2ComponentIdable.remove(windowable.getView());
            }
            this.getInnerLayout().disposeComponent(windowable.getView());
            this.panel.remove(windowable.getView());
            this.fireJDockEvent(windowable.getId(), 3);
        }
        if (this.menuWindow != null) {
            for (int i = 0; i < this.menuWindow.getItemCount(); ++i) {
                try {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.menuWindow.getItem(i);
                    HideShowAction hideShowAction = (HideShowAction)jCheckBoxMenuItem.getAction();
                    if (!hideShowAction.id.equals(string)) continue;
                    this.menuWindow.remove(jCheckBoxMenuItem);
                    break;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        this.panel.doLayout();
    }

    boolean hasHiddenWindows() {
        return this.htHiddenWindow != null && this.htHiddenWindow.size() > 0;
    }

    Enumeration hiddenWindows() {
        if (this.htHiddenWindow != null) {
            return this.htHiddenWindow.elements();
        }
        return null;
    }

    public void hideInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        if (!this.isInnerWindowHidden(string)) {
            this.getInnerLayout().resetConstraintResizeForHiddenComponent(windowable.getView());
            this.panel.remove(windowable.getView());
            this.updateView();
            if (this.htHiddenWindow == null) {
                this.htHiddenWindow = new Hashtable();
            }
            this.htHiddenWindow.put(string, windowable);
            this.fireJDockEvent(windowable.getId(), 4);
        }
    }

    public void showInnerWindow(String string) {
        if (this.htHiddenWindow == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        Windowable windowable = (Windowable)this.htHiddenWindow.get(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        if (this.isInnerWindowHidden(string)) {
            this.panel.add(windowable.getView());
            this.updateView();
            this.htHiddenWindow.remove(string);
            this.fireJDockEvent(windowable.getId(), 5);
        }
    }

    private void updateView() {
        this.panel.invalidate();
        this.panel.validate();
        this.panel.repaint();
    }

    public boolean isInnerWindowHidden(String string) {
        if (this.htHiddenWindow == null) {
            return false;
        }
        return this.htHiddenWindow.containsKey(string);
    }

    public void selectInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable != null) {
            windowable.requestFocus();
        }
    }

    public void extractInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        Action action = null;
        action = windowable.getActionModel().getActionByClass(ExtractAction.class);
        this.fireJDockEvent(string, 6);
        final JFrame jFrame = ComponentFactory.getComponentFactory().buildDockedFrame(action, windowable);
        jFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jFrame.toFront();
            }
        });
    }

    public void maximizeInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Windowable windowable2;
            Component component = this.panel.getComponent(i);
            if (component instanceof Windowable) {
                windowable2 = (Windowable)((Object)component);
                windowable2.setMaximized(false);
                continue;
            }
            if (this.htComponent2ComponentIdable == null || (windowable2 = (Windowable)this.htComponent2ComponentIdable.get(component)) == null) continue;
            windowable2.setMaximized(false);
        }
        windowable.setMaximized(true);
        this.getInnerLayout().setMaximizedComponent(windowable.getView());
        this.panel.doLayout();
        this.panel.repaint();
        this.fireJDockEvent(string, 1);
    }

    public boolean isMaximizedInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            return false;
        }
        return windowable.isMaximized();
    }

    public void restoreInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        this.getInnerLayout().setMaximizedComponent(null);
        this.panel.doLayout();
        this.panel.repaint();
        windowable.setMaximized(false);
        this.fireJDockEvent(string, 7);
    }

    public void maximizedRestoredInnerWindow(String string) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown inner window " + string);
        }
        if (windowable.isMaximized()) {
            this.restoreInnerWindow(string);
        } else {
            this.maximizeInnerWindow(string);
        }
    }

    void showHorizontalResize(Point point) {
        this.lastPoint = point;
        this.horizontal = true;
        if (this.showResizeShadow) {
            this.getView().repaint();
        }
    }

    void showVerticalResize(Point point) {
        this.lastPoint = point;
        this.horizontal = false;
        if (this.showResizeShadow) {
            this.getView().repaint();
        }
    }

    public void setEnabledDraggingShadow(boolean bl) {
        this.showDraggingShadow = bl;
    }

    public boolean isEnabledDraggingShasow() {
        return this.showDraggingShadow;
    }

    void startDrag(MouseEvent mouseEvent, BasicInnerWindow basicInnerWindow) {
        this.draggingFrame = basicInnerWindow;
        if (this.draggingBorder == null) {
            this.draggingBorder = new Rectangle();
        }
        this.initialPoint = mouseEvent.getPoint();
    }

    private String getId(Component component) {
        if (component instanceof Windowable) {
            return ((Windowable)((Object)component)).getId();
        }
        return component.getName();
    }

    Windowable componentToWindowable(Component component) {
        if (component instanceof Windowable) {
            return (Windowable)((Object)component);
        }
        if (this.htComponent2ComponentIdable != null) {
            return (Windowable)this.htComponent2ComponentIdable.get(component);
        }
        return null;
    }

    void stopDrag() {
        if (this.selectedComponent != null) {
            boolean bl = true;
            if (this.selectedComponent instanceof Windowable) {
                Windowable windowable = (Windowable)((Object)this.selectedComponent);
                boolean bl2 = bl = !windowable.isFixed();
            }
            if (bl) {
                this.fireJDockEvent(this.getId(this.draggingFrame), 2);
                this.fireJDockEvent(this.getId(this.selectedComponent), 2);
                this.getInnerLayout().swap(this.draggingFrame, this.selectedComponent);
                this.panel.doLayout();
            }
        }
        if (this.lastCursor != null) {
            this.draggingFrame.setCursor(this.lastCursor);
        }
        this.draggingFrame = null;
        this.initialPoint = null;
        this.lastCursor = null;
        this.selectedComponent = null;
        this.lastSelectedComponent = null;
        if (this.showDraggingShadow) {
            this.panel.repaint();
        }
    }

    void workingDrag(Windowable windowable, MouseEvent mouseEvent) {
        if (windowable.isFixed()) {
            return;
        }
        if (this.lastCursor == null) {
            if (this.draggingFrame == null) {
                return;
            }
            this.lastCursor = this.draggingFrame.getCursor();
            this.draggingFrame.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.draggingBorder.x = this.draggingFrame.getX() + (mouseEvent.getX() - this.initialPoint.x);
        this.draggingBorder.y = mouseEvent.getY() + this.draggingFrame.getY();
        this.draggingBorder.width = this.draggingFrame.getWidth();
        this.draggingBorder.height = this.draggingFrame.getHeight();
        this.selectedComponent = null;
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component component = this.panel.getComponent(i);
            Rectangle rectangle = component.getBounds();
            if (component == this.draggingFrame || !rectangle.contains(this.draggingFrame.getX() + mouseEvent.getX(), this.draggingFrame.getY() + mouseEvent.getY())) continue;
            this.selectedComponent = component;
            break;
        }
        if (this.showDraggingShadow) {
            this.panel.repaint();
        } else if (this.selectedComponent != null && this.selectedComponent != this.lastSelectedComponent) {
            this.panel.repaint();
            this.lastSelectedComponent = this.selectedComponent;
        }
    }

    DockableLayout getInnerLayout() {
        if (this.panel.getLayout() instanceof DockableLayout) {
            return (DockableLayout)this.panel.getLayout();
        }
        this.setLayout(new BorderLayout());
        return this.getInnerLayout();
    }

    public void setBackground(Color color) {
        this.panel.setBackground(color);
    }

    public Color getBackground() {
        return this.panel.getBackground();
    }

    public void setDraggingShadowColor(Color color) {
        this.draggingShadowColor = color;
    }

    public Color getDraggingShadowColor() {
        return this.draggingShadowColor;
    }

    public void setDraggingActiveWindow(Color color) {
        this.draggingActiveWindow = color;
    }

    public Color getDraggingActiveWindow() {
        return this.draggingActiveWindow;
    }

    public void setResizingShadowColor(Color color) {
        this.resizingShadowColor = color;
    }

    public Color getResizingShadowColor() {
        return this.resizingShadowColor;
    }

    public boolean resize(String string, int n, int n2) {
        Windowable windowable = this.getInnerWindowForId(string);
        if (windowable == null) {
            throw new JDockException("Unknown window " + string);
        }
        Dimension dimension = windowable.getView().getPreferredSize();
        if (dimension == null) {
            return false;
        }
        if (dimension.width + n < 10) {
            return false;
        }
        if (dimension.height + n2 < 10) {
            return false;
        }
        windowable.getView().setPreferredSize(new Dimension(dimension.width + n, dimension.height + n2));
        this.getView().doLayout();
        for (int i = 0; i < this.getView().getComponentCount(); ++i) {
            Component component = this.getView().getComponent(i);
            if (component.getWidth() < 0 || component.getHeight() < 0 || component.getWidth() >= 10 && component.getHeight() >= 10) continue;
            this.resize(string, -n, -n2);
            return false;
        }
        return true;
    }

    public void addJDockListener(JDockListener jDockListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(jDockListener);
    }

    public void removeJDockListener(JDockListener jDockListener) {
        if (this.listeners != null) {
            this.listeners.remove(jDockListener);
        }
    }

    void fireJDockEvent(String string, int n) {
        if ((n == 4 || n == 5) && this.statusBarView != null) {
            this.statusBarView.prepare(this);
        }
        if (this.listeners != null && this.listeners.size() > 0) {
            JDockEvent jDockEvent = new JDockEvent(this, n, string);
            for (int i = 0; i < this.listeners.size(); ++i) {
                JDockListener jDockListener = (JDockListener)this.listeners.get(i);
                jDockListener.jdockAction(jDockEvent);
            }
        }
    }

    public void setEnabledResizeShadow(boolean bl) {
        this.showResizeShadow = bl;
    }

    public boolean isEnabledResizeShasow() {
        return this.showResizeShadow;
    }

    class CustomMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        Point initialPoint;
        Cursor lastCursor = null;

        CustomMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (JDock.this.getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            this.initialPoint = mouseEvent.getPoint();
            JDock.this.lastPoint = null;
            if (JDock.this.showResizeShadow) {
                JDock.this.getView().repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component;
            int n;
            Component component2;
            super.mouseReleased(mouseEvent);
            if (JDock.this.getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            if (JDock.this.leftComponent != null) {
                component2 = (Component)JDock.this.leftComponent.get(0);
                for (n = 0; n < JDock.this.panel.getComponentCount(); ++n) {
                    component = JDock.this.panel.getComponent(n);
                    if (JDock.this.leftComponent.contains(component) || component.getX() + component.getWidth() != component2.getX() + component2.getWidth()) continue;
                    JDock.this.leftComponent.add(component);
                }
            }
            if (JDock.this.rightComponent != null) {
                component2 = (Component)JDock.this.rightComponent.get(0);
                for (n = 0; n < JDock.this.panel.getComponentCount(); ++n) {
                    component = JDock.this.panel.getComponent(n);
                    if (JDock.this.rightComponent.contains(component) || component.getX() != component2.getX()) continue;
                    JDock.this.rightComponent.add(component);
                }
            }
            if (JDock.this.topComponent != null) {
                component2 = (Component)JDock.this.topComponent.get(0);
                for (n = 0; n < JDock.this.panel.getComponentCount(); ++n) {
                    component = JDock.this.panel.getComponent(n);
                    if (JDock.this.topComponent.contains(component) || component.getY() + component.getHeight() != component2.getY() + component2.getHeight()) continue;
                    JDock.this.topComponent.add(component);
                }
            }
            if (JDock.this.bottomComponent != null) {
                component2 = (Component)JDock.this.bottomComponent.get(0);
                for (n = 0; n < JDock.this.panel.getComponentCount(); ++n) {
                    component = JDock.this.panel.getComponent(n);
                    if (JDock.this.bottomComponent.contains(component) || component.getY() != component2.getY()) continue;
                    JDock.this.bottomComponent.add(component);
                }
            }
            boolean bl = false;
            if (JDock.this.leftComponent != null && JDock.this.rightComponent != null) {
                bl = true;
                n = mouseEvent.getX() - this.initialPoint.x;
                n = this.rescaleDeltaX(n, JDock.this.leftComponent, JDock.this.rightComponent);
                JDock.this.getInnerLayout().resize(JDock.this.leftComponent, 0, 0, n, 0);
                JDock.this.getInnerLayout().resize(JDock.this.rightComponent, n, 0, -n, 0);
            } else if (JDock.this.topComponent != null && JDock.this.bottomComponent != null) {
                bl = true;
                n = mouseEvent.getY() - this.initialPoint.y;
                n = this.rescaleDeltaY(n, JDock.this.topComponent, JDock.this.bottomComponent);
                JDock.this.getInnerLayout().resize(JDock.this.topComponent, 0, 0, 0, n);
                JDock.this.getInnerLayout().resize(JDock.this.bottomComponent, 0, n, 0, -n);
            }
            if (bl) {
                this.doLayout();
                this.updateComponent(JDock.this.leftComponent);
                this.updateComponent(JDock.this.rightComponent);
                this.updateComponent(JDock.this.bottomComponent);
                this.updateComponent(JDock.this.topComponent);
            }
            this.initialPoint = null;
            JDock.this.lastPoint = null;
            if (JDock.this.showResizeShadow) {
                JDock.this.getView().repaint();
            }
        }

        private void doLayout() {
            JDock.this.getView().revalidate();
        }

        private int rescaleDeltaY(int n, ArrayList arrayList, ArrayList arrayList2) {
            int n2;
            Component component;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                component = (Component)arrayList.get(n3);
                n2 = component.getHeight() + n - JDock.this.getInnerLayout().borderY;
                if (n2 >= 20) continue;
                n4 = Math.max(n4, 20 - n2);
            }
            if (n4 > 0) {
                return n + n4;
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                component = (Component)arrayList2.get(n3);
                n2 = component.getHeight() - n - JDock.this.getInnerLayout().borderY;
                if (n2 >= 20) continue;
                n4 = Math.max(n4, 20 - n2);
            }
            return n - n4;
        }

        private int rescaleDeltaX(int n, ArrayList arrayList, ArrayList arrayList2) {
            int n2;
            Component component;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                component = (Component)arrayList.get(n3);
                n2 = component.getWidth() + n - JDock.this.getInnerLayout().borderX;
                if (n2 >= 20) continue;
                n4 = Math.max(n4, 20 - n2);
            }
            if (n4 > 0) {
                return n + n4;
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                component = (Component)arrayList2.get(n3);
                n2 = component.getWidth() - n - JDock.this.getInnerLayout().borderX;
                if (n2 >= 20) continue;
                n4 = Math.max(n4, 20 - n2);
            }
            return n - n4;
        }

        private void updateComponent(ArrayList arrayList) {
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Component component = (Component)arrayList.get(i);
                    component.invalidate();
                    component.validate();
                    component.repaint();
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JDock.this.getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            if (JDock.this.leftComponent != null && JDock.this.rightComponent != null) {
                JDock.this.showVerticalResize(mouseEvent.getPoint());
            } else if (JDock.this.topComponent != null && JDock.this.bottomComponent != null) {
                JDock.this.showHorizontalResize(mouseEvent.getPoint());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (JDock.this.getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            if (this.initialPoint != null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            JDock.this.leftComponent = null;
            JDock.this.rightComponent = null;
            JDock.this.topComponent = null;
            JDock.this.bottomComponent = null;
            for (int i = 0; i < JDock.this.panel.getComponentCount(); ++i) {
                JComponent jComponent = (JComponent)JDock.this.panel.getComponent(i);
                Rectangle rectangle = jComponent.getBounds();
                if (rectangle.contains(n + 8, n2)) {
                    if (JDock.this.rightComponent == null) {
                        JDock.this.rightComponent = new ArrayList();
                    }
                    JDock.this.rightComponent.add(jComponent);
                } else if (rectangle.contains(n - 8, n2)) {
                    if (JDock.this.leftComponent == null) {
                        JDock.this.leftComponent = new ArrayList();
                    }
                    JDock.this.leftComponent.add(jComponent);
                }
                if (rectangle.contains(n, n2 - 8)) {
                    if (JDock.this.topComponent == null) {
                        JDock.this.topComponent = new ArrayList();
                    }
                    JDock.this.topComponent.add(jComponent);
                    continue;
                }
                if (!rectangle.contains(n, n2 + 8)) continue;
                if (JDock.this.bottomComponent == null) {
                    JDock.this.bottomComponent = new ArrayList();
                }
                JDock.this.bottomComponent.add(jComponent);
            }
            if (JDock.this.leftComponent != null && JDock.this.rightComponent != null) {
                if (this.checkForNonResizable(JDock.this.leftComponent) || this.checkForNonResizable(JDock.this.rightComponent)) {
                    JDock.this.leftComponent = null;
                    JDock.this.rightComponent = null;
                    return;
                }
                if (this.lastCursor == null) {
                    this.lastCursor = JDock.this.panel.getCursor();
                }
                JDock.this.panel.setCursor(Cursor.getPredefinedCursor(11));
            } else if (JDock.this.topComponent != null && JDock.this.bottomComponent != null) {
                if (this.checkForNonResizable(JDock.this.topComponent) || this.checkForNonResizable(JDock.this.bottomComponent)) {
                    JDock.this.topComponent = null;
                    JDock.this.bottomComponent = null;
                    return;
                }
                if (this.lastCursor == null) {
                    this.lastCursor = JDock.this.panel.getCursor();
                }
                JDock.this.panel.setCursor(Cursor.getPredefinedCursor(8));
            } else if (this.lastCursor != null) {
                JDock.this.panel.setCursor(this.lastCursor);
            }
        }

        private boolean checkForNonResizable(ArrayList arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Windowable) || ((Windowable)arrayList.get(i)).isResizable()) continue;
                return true;
            }
            return false;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (JDock.this.getInnerLayout().hasMaximizedComponent()) {
                return;
            }
            if (this.lastCursor != null) {
                JDock.this.panel.setCursor(this.lastCursor);
            }
        }
    }

    class HideShowAction
    extends AbstractAction {
        private String id;

        public HideShowAction(String string, String string2) {
            this.putValue("Name", string);
            this.id = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JDock.this.isInnerWindowHidden(this.id)) {
                JDock.this.showInnerWindow(this.id);
            } else {
                JDock.this.hideInnerWindow(this.id);
            }
        }
    }

    protected class InnerPanel
    extends JPanel
    implements JDockSource {
        protected InnerPanel() {
        }

        public JDock getSource() {
            return JDock.this;
        }

        public void addNotify() {
            super.addNotify();
            if (JDock.this.listener1 == null) {
                JDock.this.listener1 = new CustomMouseListener();
            }
            this.addMouseListener(JDock.this.listener1);
            this.addMouseMotionListener(JDock.this.listener1);
            JDock.this.visibleMode = true;
            JDock.this.buildMenuWindow();
            JDock.this.setUIReady(true);
            if (JDock.this.statusBarView != null) {
                JDock.this.statusBarView.prepare(JDock.this);
            }
        }

        public void removeNotify() {
            super.removeNotify();
            this.removeMouseListener(JDock.this.listener1);
            this.removeMouseMotionListener(JDock.this.listener1);
            JDock.this.visibleMode = false;
            JDock.this.setUIReady(false);
        }

        public JDock getJDock() {
            return JDock.this;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (JDock.this.showResizeShadow && JDock.this.lastPoint != null) {
                graphics.setColor(JDock.this.resizingShadowColor);
                if (JDock.this.horizontal) {
                    graphics.drawRect(0, ((JDock)JDock.this).lastPoint.y, this.getWidth(), 1);
                } else {
                    graphics.drawRect(((JDock)JDock.this).lastPoint.x, 0, 1, this.getHeight());
                }
            }
            if (JDock.this.showDraggingShadow && JDock.this.draggingFrame != null) {
                graphics.setColor(JDock.this.draggingShadowColor);
                graphics.drawRect(((JDock)JDock.this).draggingBorder.x, ((JDock)JDock.this).draggingBorder.y, ((JDock)JDock.this).draggingBorder.width, ((JDock)JDock.this).draggingBorder.height);
            }
            if (JDock.this.selectedComponent != null) {
                graphics.setColor(JDock.this.draggingActiveWindow);
                graphics.drawRect(JDock.this.selectedComponent.getX(), JDock.this.selectedComponent.getY(), JDock.this.selectedComponent.getWidth(), JDock.this.selectedComponent.getHeight());
                graphics.drawRect(JDock.this.selectedComponent.getX() + 1, JDock.this.selectedComponent.getY() + 1, JDock.this.selectedComponent.getWidth() - 2, JDock.this.selectedComponent.getHeight() - 2);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (JDock.this.shadowMode) {
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Component component = this.getComponent(i);
                    if (!(component instanceof BasicInnerWindow)) continue;
                    graphics.setColor(Color.gray);
                    graphics.drawRect(component.getX() + component.getWidth() + 1, component.getY() + 4, 1, component.getHeight() - 3);
                    graphics.drawRect(component.getX() + 3, component.getY() + component.getHeight(), component.getWidth() - 2, 1);
                }
            }
        }
    }
}

