/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.BasicInnerWindow;
import com.japisoft.framework.dockable.ButtonLayout;
import com.japisoft.framework.dockable.DockManager;
import com.japisoft.framework.dockable.DockableFrameTitleBar;
import com.japisoft.framework.dockable.JDock;
import com.japisoft.framework.dockable.Windowable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class DefaultTitleBar
extends JComponent
implements DockableFrameTitleBar,
MouseListener {
    private String title = null;
    private Icon icon = null;
    private int height = 0;
    private int ascent = 0;
    private Color gradientStart;
    private Color gradientStop;
    private Color gradientSelectedStart;
    private Color gradientSelectedStop;
    private Color titleColor;
    private boolean focusMode = false;
    private boolean maximizedState = false;

    public DefaultTitleBar() {
        this.setFont(new Font("dialog", 0, 12));
        this.setLayout(new ButtonLayout());
        this.resetColors();
        this.gradientSelectedStart = UIManager.getColor("jdock.innerwindow.gradient.selectedStartColor");
        if (this.gradientSelectedStart == null) {
            this.gradientSelectedStart = new Color(0, 0, 128);
        }
        this.gradientSelectedStop = UIManager.getColor("jdock.innerwindow.gradient.selectedStopColor");
        if (this.gradientSelectedStop == null) {
            this.gradientSelectedStop = UIManager.getColor("Panel.background");
        }
    }

    public DefaultTitleBar(String string) {
        this();
        this.title = string;
    }

    public DefaultTitleBar(String string, Icon icon) {
        this(string);
        this.icon = icon;
    }

    private void resetColors() {
        this.gradientStart = UIManager.getColor("jdock.innerwindow.gradient.startColor");
        if (this.gradientStart == null) {
            this.gradientStart = new Color(128, 128, 128);
        }
        this.gradientStop = UIManager.getColor("jdock.innerwindow.gradient.stopColor");
        if (this.gradientStop == null) {
            this.gradientStop = UIManager.getColor("Panel.background");
        }
        this.titleColor = UIManager.getColor("jdock.innerwindow.titleColor");
        if (this.titleColor == null) {
            this.titleColor = Color.white;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            if (!(this.getParent() instanceof Windowable)) {
                return;
            }
            Windowable windowable = (Windowable)((Object)this.getParent());
            boolean bl = windowable.isMaximized();
            if (this.getParent().getParent() instanceof JDock.InnerPanel) {
                JDock.InnerPanel innerPanel = (JDock.InnerPanel)this.getParent().getParent();
                innerPanel.getJDock().maximizedRestoredInnerWindow(windowable.getId());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JScrollPane jScrollPane;
        if (!(this.getParent() instanceof BasicInnerWindow)) {
            return;
        }
        BasicInnerWindow basicInnerWindow = (BasicInnerWindow)this.getParent();
        boolean bl = false;
        if (basicInnerWindow.getView() instanceof JScrollPane && (jScrollPane = (JScrollPane)basicInnerWindow.getView()).getViewport().getView() != null) {
            jScrollPane.getViewport().getView().requestFocus();
            bl = true;
        }
        if (!bl) {
            basicInnerWindow.getView().requestFocus();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void focusMode(boolean bl) {
        if (this.focusMode == bl) {
            return;
        }
        this.focusMode = bl;
        this.repaint();
        if (this.focusMode) {
            if (this.getParent() instanceof Windowable) {
                Windowable windowable = (Windowable)((Object)this.getParent());
                windowable.fireDockEvent(windowable.getId(), 0);
            }
            if (DockManager.LAST_FOCUS != null && DockManager.LAST_FOCUS != this) {
                DockManager.LAST_FOCUS.focusMode(false);
            }
            DockManager.LAST_FOCUS = this;
        }
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setBackground(Color color) {
        if (color == null) {
            this.resetColors();
        } else {
            if (this.gradientStop == this.gradientSelectedStart) {
                this.gradientStop = color;
            }
            this.gradientStart = color;
        }
        this.repaint();
    }

    public void setForeground(Color color) {
        if (color == null) {
            this.resetColors();
        } else {
            this.titleColor = color;
        }
        this.repaint();
    }

    public void addSeparator() {
        JLabel jLabel = null;
        jLabel = new JLabel(new SeparatorImage());
        this.add(jLabel);
        jLabel.setPreferredSize(new Dimension(8, 16));
    }

    public void addButton(JButton jButton) {
        this.add(jButton);
        jButton.setPreferredSize(new Dimension(16, 16));
    }

    public void addButton(JButton jButton, boolean bl) {
        if (bl) {
            jButton.setBorderPainted(false);
            jButton.setBorder(null);
        }
        this.add(jButton);
    }

    public void removeAllButtons() {
        this.removeAll();
    }

    public void prepare() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.height == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.height = fontMetrics.getHeight() + 6;
            this.ascent = fontMetrics.getDescent();
        }
        if (dimension == null) {
            dimension = new Dimension(1, this.height);
        } else {
            dimension.height = this.height;
        }
        return dimension;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.gradientStart;
        Color color2 = this.gradientStop;
        if (this.focusMode) {
            color = this.gradientSelectedStart;
            color2 = this.gradientSelectedStop;
        }
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, this.getWidth() / 2, this.getHeight(), color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(this.titleColor);
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics2D, 2, (this.getHeight() - this.icon.getIconHeight()) / 2);
        }
        if (this.title != null) {
            graphics2D.drawString(this.title, this.icon == null ? 10 : this.icon.getIconWidth() + 5, this.getHeight() / 2 + this.ascent + 2);
        }
        graphics2D.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 3);
    }

    public JComponent getView() {
        return this;
    }

    class SeparatorImage
    implements Icon {
        SeparatorImage() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.white);
            graphics.drawLine(2, 2, 2, 14);
            graphics.setColor(Color.gray);
            graphics.drawLine(3, 2, 3, 14);
        }
    }
}

