/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.console;

import com.japisoft.framework.ApplicationModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class ConsolePanel
extends JPanel {
    private JTextArea ta;
    private static JTextArea VISIBLE_TEXTE = null;
    static StringBuffer bo = null;
    public static int CONSOLE_OUTPUT_MAX_BUFFER = 4096;
    private static PrintStream previousErrorState = null;
    private static PrintStream previousOutputState = null;

    public ConsolePanel() {
        this.prepareUI();
    }

    public void addNotify() {
        super.addNotify();
        VISIBLE_TEXTE = this.ta;
        if (bo != null) {
            this.ta.setText(bo.toString());
            try {
                this.ta.setCaretPosition(this.ta.getDocument().getLength());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        VISIBLE_TEXTE = null;
    }

    private void prepareUI() {
        this.setLayout(new BorderLayout());
        this.ta = new JTextArea();
        this.ta.setFont(new Font("courier", 0, 12));
        this.ta.setEditable(false);
        this.add(new JScrollPane(this.ta));
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new CleanAction());
        jToolBar.add(new CopyAction());
        this.add((Component)jToolBar, "South");
        this.setPreferredSize(new Dimension(300, 400));
    }

    public static void initConsoleState() {
        ConsoleOutputStream consoleOutputStream = new ConsoleOutputStream();
        PrintStream printStream = new PrintStream(consoleOutputStream);
        previousErrorState = System.err;
        previousOutputState = System.out;
        System.setErr(printStream);
        System.setOut(printStream);
    }

    public static void restoreConsoleState() {
        if (previousErrorState != null) {
            System.setErr(previousErrorState);
            System.setOut(previousOutputState);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new ConsolePanel());
        ConsolePanel.initConsoleState();
        for (int i = 0; i < 100; ++i) {
            System.out.println(">sdsdfsdfsfdsfdsfdsdfsdfdf" + i);
            System.err.println(">>>>>>>>>>>>>>>" + i);
        }
        jFrame.setSize(new Dimension(400, 400));
        jFrame.setVisible(true);
    }

    static class ConsoleOutputStream
    extends OutputStream {
        ConsoleOutputStream() {
        }

        public void write(int n) throws IOException {
            if (bo == null) {
                bo = new StringBuffer();
            }
            if (bo.length() > CONSOLE_OUTPUT_MAX_BUFFER) {
                bo.deleteCharAt(0);
            }
            bo.append((char)n);
            if (ApplicationModel.DEBUG_MODE) {
                previousOutputState.write(n);
            }
            if (VISIBLE_TEXTE != null) {
                VISIBLE_TEXTE.setText(bo.toString());
            }
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("Name", "Copy");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ConsolePanel.this.ta.getSelectedText() == null) {
                ConsolePanel.this.ta.selectAll();
            }
            ConsolePanel.this.ta.copy();
        }
    }

    class CleanAction
    extends AbstractAction {
        public CleanAction() {
            this.putValue("Name", "Clean");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConsolePanel.this.ta.setText("");
            bo = null;
        }
    }
}

