/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.command;

import com.japisoft.framework.dialog.command.ActionItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ExternalToolPane
extends JPanel
implements ActionListener {
    JComboBox cbAction = new JComboBox();
    JButton btnStore = new JButton();
    JButton btnDelete = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextField txfCommand = new JTextField();
    JTextArea txaArguments = new JTextArea();
    JButton btnArg = new JButton();
    JComboBox cbArgs = new JComboBox();
    JScrollPane jScrollPane1 = new JScrollPane();
    JLabel jLabel2 = new JLabel();
    JButton btnRun = new JButton();
    JTextArea txaConsole = new JTextArea();
    JButton btnCommand = new JButton();
    JButton btnClean = new JButton();
    JButton btnCopy = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Hashtable htMacro = new Hashtable();
    Process currentProcess;

    public ExternalToolPane() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPreferredSize(new Dimension(500, 550));
    }

    public void addNotify() {
        super.addNotify();
        this.btnDelete.addActionListener(this);
        this.btnStore.addActionListener(this);
        this.btnArg.addActionListener(this);
        this.btnCommand.addActionListener(this);
        this.btnRun.addActionListener(this);
        this.btnClean.addActionListener(this);
        this.btnCopy.addActionListener(this);
        this.cbAction.addActionListener(this);
        this.setMacro("home", System.getProperty("user.home"));
        if (this.cbAction.getItemCount() > 0) {
            this.cbAction.setSelectedIndex(0);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnDelete.removeActionListener(this);
        this.btnStore.removeActionListener(this);
        this.btnArg.removeActionListener(this);
        this.btnCommand.removeActionListener(this);
        this.btnRun.removeActionListener(this);
        this.btnClean.removeActionListener(this);
        this.btnCopy.removeActionListener(this);
        this.cbAction.removeActionListener(this);
    }

    public void setActionItems(ArrayList arrayList) {
        this.cbAction.removeAllItems();
        for (ActionItem actionItem : arrayList) {
            this.cbAction.addItem(actionItem);
        }
    }

    public ArrayList getActionsItems() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.cbAction.getItemCount(); ++i) {
            arrayList.add(this.cbAction.getItemAt(i));
        }
        return arrayList;
    }

    public void setMacro(String string, String string2) {
        this.htMacro.put(string, string2);
    }

    public void setMacro(String[] stringArray) {
        this.cbArgs.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cbArgs.setSelectedIndex(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnArg) {
            this.addArg();
        } else if (actionEvent.getSource() == this.btnCommand) {
            this.setCommand();
        } else if (actionEvent.getSource() == this.btnRun) {
            if ("Run".equals(this.btnRun.getText())) {
                this.run();
            } else {
                this.stop();
            }
        } else if (actionEvent.getSource() == this.btnClean) {
            this.cleanConsole();
        } else if (actionEvent.getSource() == this.btnCopy) {
            this.copyConsole();
        } else if (actionEvent.getSource() == this.btnStore) {
            ActionItem actionItem = new ActionItem(((JTextField)this.cbAction.getEditor().getEditorComponent()).getText(), this.txfCommand.getText(), this.txaArguments.getText());
            this.cbAction.addItem(actionItem);
        } else if (actionEvent.getSource() == this.btnDelete) {
            int n = this.cbAction.getSelectedIndex();
            if (n > -1) {
                this.cbAction.removeItemAt(n);
            }
            if (this.cbAction.getItemCount() > 0) {
                this.cbAction.setSelectedIndex(0);
            }
        } else if (actionEvent.getSource() == this.cbAction && this.cbAction.getSelectedItem() instanceof ActionItem) {
            ActionItem actionItem = (ActionItem)this.cbAction.getSelectedItem();
            this.selectAction(actionItem);
        }
    }

    private void selectAction(ActionItem actionItem) {
        this.txfCommand.setText(actionItem.command);
        this.txaArguments.setText(actionItem.arguments);
        this.txaConsole.setText(null);
    }

    private void addArg() {
        String string = (String)this.cbArgs.getSelectedItem();
        int n = string.indexOf("-");
        String string2 = string.substring(n + 1);
        this.txaArguments.append(string2);
    }

    private void setCommand() {
        JFileChooser jFileChooser = new JFileChooser(this.txfCommand.getText());
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.txfCommand.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    private void cleanConsole() {
        this.txaConsole.setText(null);
    }

    private void copyConsole() {
        this.txaConsole.copy();
    }

    private void stop() {
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
            this.btnRun.setText("Run");
        }
    }

    private void run() {
        block8: {
            try {
                String string = this.txaArguments.getText();
                Enumeration enumeration = this.htMacro.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = "\\$\\{" + string2 + "\\}";
                    String string4 = (String)this.htMacro.get(string2);
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < string4.length(); ++i) {
                        char c = string4.charAt(i);
                        if (c == '\\') {
                            stringBuffer.append("\\\\");
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    string = string.replaceAll(string3, stringBuffer.toString());
                }
                this.txaConsole.setText(null);
                this.currentProcess = Runtime.getRuntime().exec(this.txfCommand.getText() + " " + string);
                new ThreadPoller(this.currentProcess.getInputStream()).start();
                new ThreadPoller(this.currentProcess.getErrorStream()).start();
                try {
                    this.btnRun.setText("Stop");
                    int n = this.currentProcess.waitFor();
                    if (n > 0) {
                        JOptionPane.showMessageDialog(this, "Abnormal terminaison");
                        break block8;
                    }
                    JOptionPane.showMessageDialog(this, "Completed");
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Can't run this command");
            }
        }
        this.btnRun.setText("Run");
    }

    public static void main(String[] stringArray) {
        ExternalToolPane externalToolPane = new ExternalToolPane();
        externalToolPane.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.cbAction.setEditable(true);
        this.btnStore.setEnabled(false);
        this.btnStore.setText("Store");
        this.btnDelete.setEnabled(false);
        this.btnDelete.setText("Delete");
        this.jLabel1.setText("Command");
        this.jLabel3.setText("Arguments");
        this.btnArg.setEnabled(false);
        this.btnArg.setText("Arg");
        this.jLabel2.setText("Console");
        this.btnRun.setEnabled(false);
        this.btnRun.setText("Run");
        this.txaConsole.setBackground(Color.black);
        this.txaConsole.setFont(new Font("Monospaced", 0, 14));
        this.txaConsole.setForeground(Color.white);
        this.btnCommand.setText("...");
        this.btnClean.setText("Clean");
        this.btnCopy.setText("Copy");
        this.add((Component)this.btnDelete, new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 7, 0, 14), 0, 0));
        this.add((Component)this.jScrollPane2, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 10, 1, new Insets(8, 13, 0, 14), 430, 45));
        this.add((Component)this.btnArg, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 13, 0, 9), 0, 0));
        this.add((Component)this.cbArgs, new GridBagConstraints(1, 5, 4, 1, 1.0, 0.0, 10, 2, new Insets(7, 0, 0, 14), 340, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 7, 5, 1, 1.0, 1.0, 10, 1, new Insets(8, 13, 0, 14), 428, 129));
        this.jScrollPane1.getViewport().add((Component)this.txaConsole, null);
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(14, 19, 0, 13), 0, 0));
        this.add((Component)this.btnStore, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 8, 0, 0), 6, 0));
        this.add((Component)this.btnRun, new GridBagConstraints(3, 8, 2, 1, 0.0, 0.0, 10, 0, new Insets(6, 12, 7, 14), 10, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 13, 0, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 13, 0, 0), 0, 0));
        this.add((Component)this.txfCommand, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(9, 13, 0, 0), 10, 0));
        this.add((Component)this.btnClean, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 13, 7, 0), 0, 0));
        this.add((Component)this.btnCopy, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 11, 7, 5), 1, 0));
        this.add((Component)this.btnCommand, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(9, 1, 0, 0), -6, -6));
        this.add((Component)this.cbAction, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 9, 3, 4), 0, 0));
        this.jScrollPane2.getViewport().add((Component)this.txaArguments, null);
        this.txaConsole.setEditable(false);
        this.txfCommand.setDocument(new TestDocument(this.txfCommand));
        ((JTextField)this.cbAction.getEditor().getEditorComponent()).setDocument(new TestDocument((JTextField)this.cbAction.getEditor().getEditorComponent()));
    }

    private void updateTextFileStatus(JTextField jTextField, boolean bl) {
        if (jTextField == this.txfCommand) {
            this.btnArg.setEnabled(!bl);
            this.btnRun.setEnabled(!bl);
        } else if (jTextField == this.cbAction.getEditor().getEditorComponent()) {
            this.btnStore.setEnabled(!bl);
            this.btnDelete.setEnabled(!bl);
        }
    }

    class ThreadPoller
    extends Thread {
        private InputStream input;

        public ThreadPoller(InputStream inputStream) {
            this.input = inputStream;
        }

        public void run() {
            try {
                int n;
                byte[] byArray = new byte[80];
                while ((n = this.input.read(byArray)) != -1) {
                    ExternalToolPane.this.txaConsole.append("" + new String(byArray, 0, n));
                    Thread.sleep(50L);
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class TestDocument
    extends PlainDocument {
        private JTextField ref;

        public TestDocument(JTextField jTextField) {
            this.ref = jTextField;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            ExternalToolPane.this.updateTextFileStatus(this.ref, this.ref.getText().length() == 0);
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            ExternalToolPane.this.updateTextFileStatus(this.ref, this.ref.getText().length() == 0);
        }

        protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            super.removeUpdate(defaultDocumentEvent);
            ExternalToolPane.this.updateTextFileStatus(this.ref, this.ref.getText().length() == 0);
        }
    }
}

