/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.actions;

import com.japisoft.framework.dialog.actions.CancelAction;
import com.japisoft.framework.dialog.actions.ClosingAction;
import com.japisoft.framework.dialog.actions.DialogAction;
import com.japisoft.framework.dialog.actions.DialogActionModelListener;
import com.japisoft.framework.dialog.actions.OKAction;
import java.util.ArrayList;

public class DialogActionModel {
    private ArrayList list;
    private DialogActionModelListener listener;
    public static DialogAction DEFAULT_OKACTION = new OKAction();
    public static DialogAction DEFAULT_CANCELACTION = new CancelAction();

    public static DialogActionModel getDefaultDialogActionModel() {
        return new DialogActionModel(new DialogAction[]{DEFAULT_CANCELACTION, DEFAULT_OKACTION});
    }

    public static DialogActionModel getDefaultDialogOkActionModel() {
        return new DialogActionModel(new DialogAction[]{DEFAULT_OKACTION});
    }

    public static DialogActionModel getDefaultDialogCloseActionModel() {
        return new DialogActionModel(new DialogAction[]{new ClosingAction()});
    }

    public DialogActionModel() {
    }

    public DialogActionModel(DialogAction dialogAction) {
        this.addDialogAction(dialogAction);
    }

    public DialogActionModel(DialogAction[] dialogActionArray) {
        if (dialogActionArray != null) {
            for (int i = 0; i < dialogActionArray.length; ++i) {
                this.addDialogAction(dialogActionArray[i]);
            }
        }
    }

    public Object clone() {
        DialogActionModel dialogActionModel = new DialogActionModel();
        dialogActionModel.list = new ArrayList();
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                dialogActionModel.list.add(this.list.get(i));
            }
        }
        return dialogActionModel;
    }

    public void setModelListener(DialogActionModelListener dialogActionModelListener) {
        this.listener = dialogActionModelListener;
    }

    public DialogAction getDialogActionForId(int n) {
        for (int i = 0; i < this.getDialogActionCount(); ++i) {
            DialogAction dialogAction = this.getDialogActionAt(i);
            if (dialogAction.getActionId() != n) continue;
            return dialogAction;
        }
        return null;
    }

    public boolean hasDialogActionForId(int n) {
        return this.getDialogActionForId(n) != null;
    }

    public DialogActionModel addDialogAction(DialogAction dialogAction) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        if (this.list.contains(dialogAction)) {
            throw new RuntimeException("Error : You have added several times the same action object");
        }
        this.checkForUniqueAction(dialogAction);
        this.list.add(dialogAction);
        this.fireModelUpdated();
        return this;
    }

    private void checkForUniqueAction(DialogAction dialogAction) {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (((DialogAction)this.list.get(i)).getActionId() != dialogAction.getActionId()) continue;
                throw new RuntimeException("Error : Found two actions with the same id " + dialogAction.getActionId());
            }
        }
    }

    public void addDialogAction(int n, DialogAction dialogAction) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.checkForUniqueAction(dialogAction);
        this.list.add(n, dialogAction);
        this.fireModelUpdated();
    }

    public void removeDialogAction(DialogAction dialogAction) {
        if (this.list != null) {
            this.list.remove(dialogAction);
            this.fireModelUpdated();
        }
    }

    private void fireModelUpdated() {
        if (this.listener != null) {
            this.listener.modelUpdated();
        }
    }

    public int getDialogActionCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public DialogAction getDialogActionAt(int n) {
        if (this.list == null) {
            return null;
        }
        return (DialogAction)this.list.get(n);
    }
}

