/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.app.toolkit;

import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.toolkit.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Toolkit {
    static String DEFAULT_FILE_ENCODING = "DEFAULT";
    public static String[] FILE_ENCODING = new String[]{DEFAULT_FILE_ENCODING, "ASCII", "Cp1252", "ISO8859_1", "ISO8859_2", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF8", "UTF-16"};
    private static EmptyIcon DEFAULT = null;

    public static Icon getImageIcon(String string) {
        return Toolkit.getImageIcon(string, false);
    }

    public static Icon getImageIcon(String string, boolean bl) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        File file = new File(string);
        if (file.exists()) {
            return new ImageIcon(string);
        }
        Logger.addWarning("Can't find " + string);
        if (bl) {
            return Toolkit.getDefaultImage();
        }
        return null;
    }

    public static String getCurrentFileEncoding() {
        String[] stringArray = Preferences.getPreference("file", "rw-encoding", FILE_ENCODING);
        return stringArray[0];
    }

    public static Reader getReaderForFile(File file) throws IOException {
        String string = Toolkit.getCurrentFileEncoding();
        return Toolkit.getReaderForFile(file, string);
    }

    public static Reader getReaderForFile(File file, String string) throws IOException {
        InputStreamReader inputStreamReader = string == null || DEFAULT_FILE_ENCODING.equals(string) ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), string);
        return inputStreamReader;
    }

    public static Reader getReaderForFile(String string) throws IOException {
        return Toolkit.getReaderForFile(new File(string));
    }

    public static Writer getWriterForFile(File file, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = string == null || DEFAULT_FILE_ENCODING.equals(string) ? new FileWriter(file) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
        return outputStreamWriter;
    }

    public static Writer getWriterForFile(File file) throws IOException {
        String string = Toolkit.getCurrentFileEncoding();
        return Toolkit.getWriterForFile(file, string);
    }

    public static String getEncodedString(byte[] byArray) throws IOException {
        String string = Toolkit.getCurrentFileEncoding();
        if (DEFAULT_FILE_ENCODING.equals(string)) {
            return new String(byArray);
        }
        return new String(byArray, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromFileName(String string) throws Throwable {
        if (string.indexOf("://") > -1) {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            return Toolkit.getContentFromInputStream(inputStream);
        }
        StringBuffer stringBuffer = null;
        File file = new File(string);
        if (file.exists()) {
            InputStreamReader inputStreamReader = null;
            String string2 = Toolkit.getCurrentFileEncoding();
            inputStreamReader = DEFAULT_FILE_ENCODING.equals(string2) || "AUTOMATIC".equals(string2) ? new FileReader(string) : new InputStreamReader((InputStream)new FileInputStream(string), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                stringBuffer = new StringBuffer();
                String string3 = null;
                String string4 = System.getProperty("line.separator");
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(string4);
                    }
                    stringBuffer.append(string3);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static String getContentFromInputStream(InputStream inputStream) throws Throwable {
        return Toolkit.getContentFromInputStream(inputStream, Toolkit.getCurrentFileEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromInputStream(InputStream inputStream, String string) throws Throwable {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        try {
            int n;
            InputStreamReader inputStreamReader = null;
            inputStreamReader = DEFAULT_FILE_ENCODING.equals(string) || string == null || "AUTOMATIC".equals(string) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuffer.toString();
    }

    public static String getPathForObject(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol().equals("jar")) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                uRL = jarURLConnection.getJarFileURL();
                String string2 = uRL.toExternalForm();
                string2 = string2.replaceAll("%20", " ");
                if (string2.startsWith("file://")) {
                    return string2.substring(6);
                }
                if (string2.startsWith("file:/")) {
                    return string2.substring(5);
                }
                return string2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return uRL.toExternalForm();
    }

    public static String toURL(File file) throws MalformedURLException {
        return file.toURI().toURL().toString();
    }

    public static boolean removeDirectoryAndContent(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        String[] stringArray = file.list();
        boolean bl = true;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                boolean bl2 = bl = bl && Toolkit.removeDirectoryAndContent(file2);
                if (!bl) break;
            }
        }
        bl = bl && file.delete();
        return bl;
    }

    public static String resolve(Hashtable hashtable, String string) throws Exception {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (bl) {
                if (c == '}') {
                    bl = false;
                    String string2 = stringBuffer2.toString();
                    String string3 = (String)hashtable.get(string2);
                    if (string3 == null) {
                        throw new Exception("Unknown parameter " + string2);
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer2.append(c);
                continue;
            }
            if (c == '{') {
                if (i - 1 >= 0) {
                    if (cArray[i - 1] == '$') {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        stringBuffer2 = new StringBuffer();
                        bl = true;
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getRelativePath(File file, File file2) {
        if (file2 == null) {
            return file.toString();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            int n;
            int n2;
            for (File file3 = file; file3 != null; file3 = file3.getParentFile()) {
                arrayList.add(0, file3.getName());
            }
            while (file2 != null) {
                arrayList2.add(0, file2.getName());
                file2 = file2.getParentFile();
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                try {
                    if (arrayList.get(n2).equals(arrayList2.get(n2))) continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                break;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = n2 + 1; n < arrayList2.size(); ++n) {
                stringBuffer.append("..");
                stringBuffer.append(System.getProperty("file.separator"));
            }
            for (n = n2; n < arrayList.size(); ++n) {
                if (n > n2) {
                    stringBuffer.append(System.getProperty("file.separator"));
                }
                stringBuffer.append(arrayList.get(n));
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return file.toString();
        }
    }

    public static Icon getDefaultImage() {
        if (DEFAULT == null) {
            DEFAULT = new EmptyIcon();
        }
        return DEFAULT;
    }

    public static void main(String[] stringArray) {
        File file = new File("d:\\doc.xml");
        File file2 = new File("C:\\titi\\toto\\personal.dtd");
        System.out.println(Toolkit.getRelativePath(file2, file));
    }

    public static class EmptyIcon
    implements Icon {
        private final int height;
        private final int width;

        public EmptyIcon() {
            this.height = 16;
            this.width = 16;
        }

        public EmptyIcon(Dimension dimension) {
            this.height = dimension.height;
            this.width = dimension.width;
        }

        public EmptyIcon(int n, int n2) {
            this.height = n;
            this.width = n2;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

