/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.document;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.Messages;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.document.DocumentBuilder;
import com.japisoft.fastparser.document.DocumentBuilderException;
import com.japisoft.fastparser.document.NamespaceContext;
import com.japisoft.fastparser.node.MutableNode;
import com.japisoft.fastparser.node.NodeFactory;
import com.japisoft.fastparser.node.ViewableNode;
import java.util.Enumeration;
import java.util.Stack;

public class DocumentBuilderImpl
implements DocumentBuilder {
    private NodeFactory nf;
    private MutableNode root;
    private Stack stack;
    private FastVector header;
    private Document doc;
    private NamespaceContext nscontext;
    private Parser p;
    private boolean flatMode;
    private FastVector flatView;
    private MutableNode current;
    private boolean checkCloseTag = true;
    private boolean checkPrefix = true;
    FastVector prefixToCheck = null;
    private boolean trimText = false;

    public DocumentBuilderImpl(NodeFactory nodeFactory, Parser parser, Document document) {
        this.nf = nodeFactory;
        if (document != null) {
            this.doc = document;
        } else {
            this.doc = new Document();
            nodeFactory.setRefDocument(this.doc);
            this.doc.setNodeFactory(nodeFactory);
        }
        this.p = parser;
    }

    public DocumentBuilderImpl(NodeFactory nodeFactory, Parser parser) {
        this(nodeFactory, parser, null);
    }

    public void dispose() {
        this.p = null;
    }

    public boolean isTerminated() {
        return this.stack == null || this.stack.isEmpty();
    }

    public void setFlatView(boolean bl) {
        this.flatMode = bl;
        this.flatView = bl ? new FastVector() : null;
        this.doc.setFlatNode(this.flatView);
    }

    public FastVector getFlatView() {
        return this.flatView;
    }

    public void openNode(String string, String string2, String string3) throws DocumentBuilderException {
        String string4;
        boolean bl;
        if (this.checkPrefix && this.nscontext != null && string != null && string2 == null) {
            string2 = this.nscontext.getPrefixURI(string);
        }
        if (bl = (string4 = string3).endsWith("/")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        int n = this.doc.getStringId(string4);
        MutableNode mutableNode = this.nf.getTagNode(n);
        if (this.flatMode) {
            this.flatView.add(mutableNode);
        }
        if (this.nscontext != null && string == null) {
            string2 = this.nscontext.currentDefaultNamespace();
        }
        mutableNode.setNameSpace(string, string2);
        mutableNode.setStartingLine(this.p.line);
        int n2 = string4.length();
        if (string != null) {
            n2 += string.length() + 1;
        }
        int n3 = this.p.offset;
        if (bl) {
            --n3;
        }
        mutableNode.setStartingOffset(n3 - n2 - 1);
        if (this.root == null) {
            this.root = mutableNode;
            this.stack = new Stack();
        } else {
            this.current.addNode(mutableNode);
        }
        if (!bl) {
            this.current = mutableNode;
            this.stack.push(this.current);
        } else {
            mutableNode.setClosedLeaf(true);
            mutableNode.setStoppingLine(this.p.line);
            if (bl) {
                ++n3;
            }
            mutableNode.setStoppingOffset(n3);
        }
    }

    public void setCheckForCloseTag(boolean bl) {
        this.checkCloseTag = bl;
    }

    public void setCheckPrefixForNamespace(boolean bl) {
        this.checkPrefix = bl;
    }

    public void closeNode(String string, String string2) throws DocumentBuilderException {
        if (this.stack == null) {
            throw new DocumentBuilderException(Messages.ERROR_TAG2 + " " + string2);
        }
        this.current = (MutableNode)this.stack.pop();
        if (string == null) {
            if (this.checkCloseTag && (this.current == null || !string2.equals(this.current.getNodeContent()))) {
                if (this.current == null) {
                    throw new DocumentBuilderException(Messages.ERROR_TAG2 + " " + string2);
                }
                throw new DocumentBuilderException(Messages.ERROR_TAG2 + " " + string2 + " " + Messages.ERROR_TAG3 + " </" + this.current.getNodeContent() + ">");
            }
        } else if (!(!this.checkCloseTag || this.current != null && string2.equals(this.current.getNodeContent()) && string.equals(this.current.getNameSpacePrefix()))) {
            if (this.current == null) {
                throw new DocumentBuilderException(Messages.ERROR_TAG2 + " " + string2);
            }
            throw new DocumentBuilderException(Messages.ERROR_TAG2 + " " + string2 + " " + Messages.ERROR_TAG3 + " </" + this.current.getNameSpacePrefix() + ":" + this.current.getNodeContent() + ">");
        }
        if (this.checkPrefix && this.current.getNameSpacePrefix() != null && this.current.getNameSpaceURI() == null) {
            throw new DocumentBuilderException(Messages.ERROR_PREFIX1 + " " + this.current.getNameSpacePrefix());
        }
        this.current.setStoppingLine(this.p.line);
        this.current.setStoppingOffset(this.p.offset);
        this.updateNamespaceScope();
        if (this.prefixToCheck != null) {
            for (int i = 0; i < this.prefixToCheck.size(); ++i) {
                String string3 = (String)this.prefixToCheck.get(i);
                if (this.nscontext.getPrefixURI(string3) != null) continue;
                this.p.line = ((ViewableNode)((Object)this.current)).getStartingLine() - 2;
                this.p.col = ((ViewableNode)((Object)this.current)).getStartingOffset();
                throw new RuntimeException("Unkown prefix '" + string3 + "'");
            }
            this.prefixToCheck = null;
        }
        this.current = this.stack.size() > 0 ? (MutableNode)this.stack.peek() : null;
    }

    private void updateNamespaceScope() {
        Enumeration enumeration = this.current.getNamespaceDeclared();
        if (enumeration != null && this.nscontext != null) {
            while (enumeration.hasMoreElements()) {
                this.nscontext.removePrefixScope((String)enumeration.nextElement());
            }
        }
        if (this.current.getDefaultNamespace() != null) {
            this.nscontext.popDefaultNamespace();
        }
    }

    public void closeNode() throws DocumentBuilderException {
        if (this.current == null) {
            throw new DocumentBuilderException(Messages.ERROR_TAG4);
        }
        this.current.setStoppingLine(this.p.line);
        this.current.setStoppingOffset(this.p.offset);
        this.current.setClosedLeaf(true);
        this.updateNamespaceScope();
        if (this.stack.size() != 0) {
            this.stack.pop();
            if (this.stack.size() != 0) {
                this.current = (MutableNode)this.stack.pop();
                this.stack.push(this.current);
            }
        }
    }

    public void setNameSpace(String string, String string2) {
        if (this.nscontext == null) {
            this.nscontext = new NamespaceContext();
        }
        if (string != null) {
            this.nscontext.addPrefixScope(string, string2);
        } else {
            this.nscontext.pushDefaultNamespace(string2);
        }
        if (this.current != null) {
            if (string != null) {
                this.current.addNameSpaceDeclaration(string, string2);
                if (this.current.getNameSpacePrefix() != null && string.equals(this.current.getNameSpacePrefix())) {
                    this.current.setNameSpace(string, string2);
                }
            } else {
                this.current.setDefaultNamespace(string2);
            }
        }
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws DocumentBuilderException {
        if (this.checkPrefix && this.nscontext != null && string != null && !"xml".equals(string) && string2 == null) {
            if (this.prefixToCheck == null) {
                this.prefixToCheck = new FastVector();
            }
            this.prefixToCheck.add(string);
        }
        if (this.current != null) {
            if (string == null) {
                this.current.setNodeAttribute(string3, string4);
            } else {
                this.current.setNodeAttribute(string + ":" + string3, string4);
            }
        }
    }

    public void addTextNode(String string) throws DocumentBuilderException {
        MutableNode mutableNode = this.nf.getTextNode(this.trimText ? string.trim() : string);
        mutableNode.setStartingLine(this.p.lineText);
        mutableNode.setStartingOffset(this.p.offset - string.length());
        mutableNode.setStoppingLine(this.p.line);
        mutableNode.setStoppingOffset(this.p.offset);
        if (this.flatMode) {
            this.flatView.add(mutableNode);
        }
        if (this.current != null) {
            this.current.addNode(mutableNode);
        }
    }

    public void addCommentNode(String string) {
        if (this.current == null) {
            if (this.header == null) {
                this.header = new FastVector();
            }
            this.header.add(this.nf.getCommentNode(string));
        } else {
            this.current.addNode(this.nf.getCommentNode(string));
        }
    }

    public Document getDocument() {
        Document document = this.doc;
        if (this.header != null) {
            document.setHeaderNode(this.header);
        }
        document.setRoot(this.root);
        return document;
    }

    public void trimTextNode(boolean bl) {
        this.trimText = bl;
    }
}

