/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.debug;

import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.editix.xslt.debug.TracableListener;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.bookmark.DefaultBookmarkContext;
import javax.swing.SwingUtilities;

abstract class CommonTraceListener
implements TracableListener {
    boolean waitMode = false;
    boolean noWait = false;
    boolean continueMode = false;
    IXMLPanel panel;
    DefaultBookmarkContext bmContext;

    public CommonTraceListener(IXMLPanel iXMLPanel) {
        this.panel = iXMLPanel;
        this.bmContext = (DefaultBookmarkContext)iXMLPanel.getBookmarkContext();
    }

    protected void showCurrentLine(String string, int n) {
        if (n <= 0) {
            return;
        }
        final int n2 = n;
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CommonTraceListener.this.panel.setProperty(XSLTEditor.DEBUG_CURRENT_LINE, new Object[]{string2, n2});
            }
        });
    }

    protected void unhighLight(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CommonTraceListener.this.panel != null) {
                    CommonTraceListener.this.panel.setProperty(XSLTEditor.DEBUG_CURRENT_LINE, new Object[]{null, -1});
                }
            }
        });
    }

    protected void refreshResult() {
        if (this.panel instanceof XSLTEditor) {
            ((XSLTEditor)this.panel).loadResultFile();
        }
    }

    protected void waitForDebug() {
        try {
            this.waitMode = true;
            while (this.waitMode) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void continueBreakpoint() {
        this.continueMode = false;
        this.waitMode = false;
        this.notify();
    }

    public synchronized void continueNextElement() {
        this.continueMode = true;
        this.waitMode = false;
        this.notify();
    }

    public synchronized void terminateAll() {
        this.unhighLight(false);
        this.waitMode = false;
        this.noWait = true;
        this.notify();
    }

    public void dispose() {
        this.refreshResult();
        this.unhighLight(false);
        this.panel = null;
        this.bmContext = null;
    }
}

