/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd;

import com.japisoft.editix.ui.xsd.CustomActionListener;
import com.japisoft.editix.ui.xsd.Factory;
import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.AnnotationViewImpl;
import com.japisoft.editix.ui.xsd.view.CommonSelectionListener;
import com.japisoft.editix.ui.xsd.view.DesignerViewImpl;
import com.japisoft.editix.ui.xsd.view.MainTableViewImpl;
import com.japisoft.editix.ui.xsd.view.designer.XSDAbstractComponentImpl;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponent;
import com.japisoft.editix.ui.xsd.view.element.ElementViewImpl;
import com.japisoft.editix.ui.xsd.view.element.PropertiesViewListener;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dockable.InnerWindowProperties;
import com.japisoft.framework.dockable.JDock;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualXSDEditor
extends JDock
implements ListSelectionListener,
CommonSelectionListener,
PropertiesViewListener {
    private MainTableViewImpl tv = null;
    private ElementViewImpl ev = null;
    private AnnotationViewImpl av = new AnnotationViewImpl();
    private DesignerViewImpl dv = null;
    private Factory factory = null;
    private JPanel mainPanel = new JPanel();
    private HistoryPrevious hp = new HistoryPrevious();
    private HistoryNext hn = new HistoryNext();
    private CopyAction ca = new CopyAction();
    private CutAction cua = new CutAction();
    private PasteAction pa = new PasteAction();
    private CustomActionListener actionListener = null;
    private Stack stackOfSelectionPrevious = null;
    private Stack stackOfSelectionNext = null;
    private Element selectedElement = null;
    private Element schemaRoot = null;
    private Element copyOrCutElement = null;

    public VisualXSDEditor(Factory factory) {
        this.factory = factory;
        this.dv = new DesignerViewImpl(factory);
        this.tv = new MainTableViewImpl(factory);
        this.ev = new ElementViewImpl(factory, this);
        JScrollPane jScrollPane = new JScrollPane(this.tv.getView());
        this.mainPanel.setLayout(new CardLayout());
        this.mainPanel.add((Component)jScrollPane, "table");
        JPanel jPanel = new JPanel();
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new BackToTableAction());
        jToolBar.addSeparator();
        jToolBar.add(new OpenAll());
        jToolBar.addSeparator();
        jToolBar.add(new GotoInto());
        jToolBar.addSeparator();
        jToolBar.add(this.hp);
        jToolBar.addSeparator();
        this.hp.setEnabled(false);
        jToolBar.add(this.hn);
        this.hn.setEnabled(false);
        jToolBar.addSeparator();
        jToolBar.add(this.ca);
        jToolBar.add(this.cua);
        jToolBar.add(this.pa);
        jToolBar.addSeparator();
        jToolBar.add(new ExportImageAction());
        this.ca.setEnabled(false);
        this.cua.setEnabled(false);
        this.pa.setEnabled(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)new JScrollPane(this.dv), "Center");
        this.mainPanel.add((Component)jPanel, "designer");
        this.tv.setCommonSelectionListener(this);
        this.dv.setCommonSelectionListener(this);
        this.addInnerWindow(new InnerWindowProperties("1", "Schema definitions", null, null, this.mainPanel), (Object)"Center");
        JComponent jComponent = this.ev.getView();
        jComponent.setPreferredSize(new Dimension(200, 0));
        this.addInnerWindow(new InnerWindowProperties("2", "Properties", null, null, jComponent), (Object)"East");
        JScrollPane jScrollPane2 = new JScrollPane(this.av.getView());
        jScrollPane2.setPreferredSize(new Dimension(0, 50));
        this.addInnerWindow(new InnerWindowProperties("3", "Documentation (Text only)", null, null, jScrollPane2), (Object)"South");
        this.getView().getActionMap().put("cut", this.cua);
        this.getView().getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "cut");
    }

    public void setCustomActions(CustomActionListener customActionListener) {
        this.actionListener = customActionListener;
    }

    public Action getCopyAction() {
        return this.ca;
    }

    public Action getCutAction() {
        return this.cua;
    }

    public Action getPasteAction() {
        return this.pa;
    }

    public void resetAttribute(String string, String string2) {
        if ("name".equals(string) || "ref".equals(string) || "minOccurs".equals(string) || "maxOccurs".equals(string) || "use".equals(string)) {
            this.dv.refreshCurrentElementUI();
        }
    }

    public void closeDesigner() {
        Element element;
        this.cleanHistory();
        this.dv.disposeAll();
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "table");
        this.ev.setDesignerMode(false);
        while (!(this.selectedElement.getParentNode() instanceof Document) && this.selectedElement.getParentNode() != null && !"schema".equals((element = (Element)this.selectedElement.getParentNode()).getLocalName())) {
            this.selectedElement = element;
        }
        this.tv.select(this.selectedElement);
    }

    public void openDesigner(Element element) {
        this.dv.init(element);
        ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "designer");
        this.ev.setDesignerMode(true);
        this.select(element);
        if (this.stackOfSelectionPrevious == null) {
            this.stackOfSelectionPrevious = new Stack();
        }
        if (this.stackOfSelectionPrevious != null) {
            this.stackOfSelectionPrevious.push(element);
        }
        this.resetStackActionsState();
    }

    private void resetStackActionsState() {
        this.hp.setEnabled(this.stackOfSelectionPrevious != null && this.stackOfSelectionPrevious.size() > 1);
        this.hn.setEnabled(this.stackOfSelectionNext != null && this.stackOfSelectionNext.size() > 0);
        try {
            Element element;
            if (this.hp.isEnabled()) {
                element = (Element)this.stackOfSelectionPrevious.get(this.stackOfSelectionPrevious.size() - 2);
                this.hp.putValue("ShortDescription", XSDAbstractComponentImpl.getToolTip(element, null));
            } else {
                this.hp.putValue("ShortDescription", null);
            }
            if (this.hn.isEnabled()) {
                element = (Element)this.stackOfSelectionNext.peek();
                this.hn.putValue("ShortDescription", XSDAbstractComponentImpl.getToolTip(element, null));
            } else {
                this.hn.putValue("ShortDescription", null);
            }
        }
        catch (Throwable throwable) {
            ApplicationModel.debug(throwable);
        }
    }

    private void cleanHistory() {
        this.stackOfSelectionNext = null;
        this.stackOfSelectionPrevious = null;
        this.resetStackActionsState();
    }

    public void select(Element element) {
        this.notifyCurrentElement(element);
        this.ca.setEnabled(true);
        this.cua.setEnabled(true);
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public DesignerViewImpl getDesignerView() {
        return this.dv;
    }

    public boolean delete(Element element) {
        return false;
    }

    protected void setUIReady(boolean bl) {
        if (bl) {
            this.tv.getSelectionModel().addListSelectionListener(this);
            this.tv.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.tv.getSelectionModel().removeListSelectionListener(this);
        }
    }

    public void init(Element element) {
        this.schemaRoot = element;
        this.tv.init(element);
        this.closeDesigner();
    }

    void select(String string) {
        Document document;
        Element element;
        if (this.schemaRoot != null && (element = SchemaHelper.resolveXPathExpression(string, document = this.schemaRoot.getOwnerDocument())) != null) {
            for (Node node = element; node != null; node = node.getParentNode()) {
                String string2 = node.getLocalName();
                if ("schema".equals(string2)) {
                    this.tv.select(element);
                    break;
                }
                if ("complexType".equals(string2)) {
                    element = node;
                    this.openDesigner(element);
                    break;
                }
                if (!"element".equals(string2)) continue;
                element = node;
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tv.getSelectedRow();
        boolean bl = false;
        if (n > -1 && this.schemaRoot != null) {
            this.ev.stopEditing();
            NodeList nodeList = this.schemaRoot.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                if (n == 0) {
                    this.notifyCurrentElement((Element)nodeList.item(i));
                    bl = true;
                    break;
                }
                --n;
            }
        }
        if (!bl) {
            this.notifyCurrentElement(null);
        }
    }

    private void notifyCurrentElement(Element element) {
        this.ev.init(element);
        this.av.init(element);
        this.selectedElement = element;
    }

    public void stopEditing() {
        this.tv.stopEditing();
        this.ev.stopEditing();
        this.selectedElement = null;
    }

    public void dispose() {
        this.schemaRoot = null;
        this.selectedElement = null;
        this.ev.dispose();
        this.av.dispose();
        this.tv.dispose();
        this.dv.dispose();
        this.ev = null;
        this.av = null;
        this.tv = null;
        this.hp = null;
        this.hn = null;
        this.stackOfSelectionNext = null;
        this.stackOfSelectionPrevious = null;
        this.copyOrCutElement = null;
        super.dispose();
    }

    class ExportImageAction
    extends AbstractAction {
        public ExportImageAction() {
            this.putValue("ShortDescription", "Export this diagram to an external image");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("photo_scenery.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VisualXSDEditor.this.actionListener != null) {
                VisualXSDEditor.this.actionListener.action("exportimage", VisualXSDEditor.this);
            }
        }
    }

    class PasteAction
    extends AbstractAction {
        PasteAction() {
            this.putValue("ShortDescription", "Paste the last element cut or copy");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("paste.png")));
            this.putValue("AcceleratorKey", KeyStroke.getAWTKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("Name", "Paste the XSD part");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VisualXSDEditor.this.copyOrCutElement != null) {
                String string = VisualXSDEditor.this.copyOrCutElement.getLocalName();
                if (SchemaHelper.canHaveThisChild(VisualXSDEditor.this.selectedElement, string)) {
                    Element element = (Element)VisualXSDEditor.this.copyOrCutElement.cloneNode(true);
                    element.setUserData("ui", null, null);
                    VisualXSDEditor.this.selectedElement.appendChild(element);
                    VisualXSDEditor.this.dv.refreshContent(VisualXSDEditor.this.selectedElement);
                } else {
                    VisualXSDEditor.this.factory.buildAndShowInformationDialog("Cannot paste this element");
                }
            }
        }
    }

    class CutAction
    extends AbstractAction {
        CutAction() {
            this.putValue("ShortDescription", "Cut the selected element");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("cut.png")));
            this.putValue("AcceleratorKey", KeyStroke.getAWTKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("Name", "Cut the XSD part");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisualXSDEditor.this.copyOrCutElement = VisualXSDEditor.this.selectedElement;
            VisualXSDEditor.this.dv.deleteXML((XSDComponent)VisualXSDEditor.this.selectedElement.getUserData("ui"));
            VisualXSDEditor.this.pa.setEnabled(true);
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
            this.putValue("ShortDescription", "Copy the selected element");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("copy.png")));
            this.putValue("AcceleratorKey", KeyStroke.getAWTKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("Name", "Copy the XSD part");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisualXSDEditor.this.copyOrCutElement = VisualXSDEditor.this.selectedElement;
            VisualXSDEditor.this.pa.setEnabled(true);
        }
    }

    class OpenAll
    extends AbstractAction {
        OpenAll() {
            this.putValue("ShortDescription", "Show all the content");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("jar_view.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VisualXSDEditor.this.selectedElement == null) {
                VisualXSDEditor.this.factory.buildAndShowErrorDialog("No selected element");
            } else if (VisualXSDEditor.this.selectedElement.getUserData("ui") == null) {
                VisualXSDEditor.this.factory.buildAndShowErrorDialog("Can't show the element content");
            } else {
                VisualXSDEditor.this.dv.openAll((XSDComponent)VisualXSDEditor.this.selectedElement.getUserData("ui"));
            }
        }
    }

    class GotoInto
    extends AbstractAction {
        GotoInto() {
            this.putValue("ShortDescription", "Go into the reference or external type");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("jar_into.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (VisualXSDEditor.this.selectedElement == null) {
                VisualXSDEditor.this.factory.buildAndShowErrorDialog("No selected element");
            } else if (!VisualXSDEditor.this.dv.open(VisualXSDEditor.this.selectedElement)) {
                VisualXSDEditor.this.factory.buildAndShowErrorDialog("Can't find an external definition");
            }
        }
    }

    class HistoryNext
    extends AbstractAction {
        HistoryNext() {
            this.putValue("ShortDescription", "Go to the next selection inside the history");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("arrow_right_green.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Element element = (Element)VisualXSDEditor.this.stackOfSelectionNext.pop();
            if (VisualXSDEditor.this.stackOfSelectionPrevious == null) {
                VisualXSDEditor.this.stackOfSelectionPrevious = new Stack();
            }
            VisualXSDEditor.this.openDesigner(element);
        }
    }

    class HistoryPrevious
    extends AbstractAction {
        HistoryPrevious() {
            this.putValue("ShortDescription", "Go to the previous selection inside the history");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("arrow_left_green.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Element element = (Element)VisualXSDEditor.this.stackOfSelectionPrevious.pop();
            Element element2 = (Element)VisualXSDEditor.this.stackOfSelectionPrevious.pop();
            if (VisualXSDEditor.this.stackOfSelectionNext == null) {
                VisualXSDEditor.this.stackOfSelectionNext = new Stack();
            }
            VisualXSDEditor.this.stackOfSelectionNext.push(element);
            VisualXSDEditor.this.openDesigner(element2);
        }
    }

    class BackToTableAction
    extends AbstractAction {
        public BackToTableAction() {
            this.putValue("ShortDescription", "Back to the main table");
            this.putValue("SmallIcon", new ImageIcon(VisualXSDEditor.class.getResource("table.png")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisualXSDEditor.this.closeDesigner();
        }
    }
}

