/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.info;

import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.xml.Encoding;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class InfoUI
extends JPanel
implements ActionListener {
    private JComboBox cbEncoding;
    private JComboBox cbFileType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JTextArea lblFilePath;
    private JLabel lblSize;

    InfoUI() {
        this.initComponents();
    }

    public void addNotify() {
        super.addNotify();
        this.cbEncoding.addActionListener(this);
        this.cbFileType.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.cbEncoding.removeActionListener(this);
        this.cbFileType.removeActionListener(this);
    }

    void updateForXMLContainer(XMLContainer xMLContainer) {
        if (xMLContainer != null) {
            Object object;
            this.lblFilePath.setText(xMLContainer.getCurrentDocumentLocation());
            this.lblFilePath.setToolTipText(this.lblFilePath.getText());
            this.jLabel1.setText(xMLContainer.getDocumentInfo().getDocumentName());
            if (xMLContainer.getCurrentDocumentLocation() != null) {
                object = new File(xMLContainer.getCurrentDocumentLocation());
                this.lblSize.setText(((File)object).length() + " bytes");
            } else {
                this.lblSize.setText("0");
            }
            object = null;
            object = xMLContainer.getDocumentInfo().getEncoding() != null ? xMLContainer.getDocumentInfo().getEncoding() : (String)xMLContainer.getProperty("encoding", "DEFAULT");
            this.cbEncoding.setSelectedItem(object);
            String string = xMLContainer.getDocumentInfo().getType();
            this.cbFileType.setSelectedItem(string);
        } else {
            this.lblFilePath.setText(null);
            this.lblFilePath.setToolTipText(null);
            this.lblSize.setText(null);
            this.cbEncoding.setSelectedItem("DEFAULT");
            this.cbFileType.setSelectedItem("XML");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        if (actionEvent.getSource() == this.cbEncoding) {
            String string = (String)this.cbEncoding.getSelectedItem();
            if ("DEFAULT".equals(string)) {
                string = null;
            }
            xMLContainer.setProperty("encoding", string);
            ProjectManager.updateFileEncoding(xMLContainer.getCurrentDocumentLocation(), string);
        } else if (actionEvent.getSource() == this.cbFileType) {
            String string = (String)this.cbFileType.getSelectedItem();
            EditixFrame.ACCESSOR.updateMenuActionForGroup(xMLContainer.getDocumentInfo().getType(), false);
            EditixFrame.ACCESSOR.updateToolBarAndMenuForType(string);
            ActionModel.resetActionState(xMLContainer);
            xMLContainer.getDocumentInfo().setType(string);
            ProjectManager.updateFileType(xMLContainer.getCurrentDocumentLocation(), string);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.lblFilePath = new JTextArea();
        this.lblFilePath.setLineWrap(true);
        this.lblFilePath.setOpaque(false);
        this.lblFilePath.setEditable(false);
        this.lblFilePath.setPreferredSize(new Dimension(100, 50));
        this.jLabel3 = new JLabel();
        this.lblSize = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbEncoding = new JComboBox();
        this.jLabel5 = new JLabel();
        this.cbFileType = new JComboBox();
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setForeground(new Color(50, 150, 50));
        this.jLabel1.setText("Info");
        this.jLabel2.setText("Path");
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.lblFilePath.setText("...");
        this.jLabel3.setText("Size");
        this.jLabel3.setFont(new Font("Arial", 1, 12));
        this.lblSize.setText("0");
        this.jLabel4.setText("Encoding");
        this.jLabel4.setFont(new Font("Arial", 1, 12));
        this.cbEncoding.setModel(new DefaultComboBoxModel<String>(Encoding.XML_ENCODINGS));
        this.jLabel5.setText("File type");
        this.jLabel5.setFont(new Font("Arial", 1, 12));
        this.cbFileType.setModel(new DefaultComboBoxModel<String>(DocumentModel.DOCUMENT_TYPE));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 197, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jLabel3).add((Component)this.lblSize).add((Component)this.jLabel4).add((Component)this.jLabel5).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.cbFileType, 0, -1, Short.MAX_VALUE).add(1, (Component)this.cbEncoding, -2, 87, -2)).add((Component)this.jLabel2).add((Component)this.lblFilePath, -1, 197, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.lblSize).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.cbEncoding, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.cbFileType, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.lblFilePath).addContainerGap(58, Short.MAX_VALUE)));
    }
}

