/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.EditixStatusBar;
import com.japisoft.xmlpad.CaretListener;
import com.japisoft.xmlpad.DocumentStateListener;
import com.japisoft.xmlpad.LocationEvent;
import com.japisoft.xmlpad.LocationListener;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public class Factory {
    private static JFileChooser fileChooser = null;
    private static JFileChooser projectChooser = null;

    public static XMLContainer buildNewContainer() {
        return Factory.buildNewContainer(false);
    }

    public static XMLContainer buildNewContainer(String string) {
        int n = string.lastIndexOf(".");
        String string2 = null;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        EditixXMLContainer editixXMLContainer = new EditixXMLContainer();
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForExt(string2);
        if (xMLDocumentInfo != null) {
            editixXMLContainer.setDocumentInfo(xMLDocumentInfo);
        }
        return editixXMLContainer;
    }

    public static XMLContainer buildNewContainer(boolean bl) {
        EditixXMLContainer editixXMLContainer = new EditixXMLContainer();
        if (bl) {
            editixXMLContainer.setDocumentInfo(DocumentModel.getDefaultDocument());
            editixXMLContainer.getDocumentInfo().setCurrentDocumentLocation("Empty.xml");
        }
        return editixXMLContainer;
    }

    public static JFileChooser buildFileChooser() {
        JFileChooser jFileChooser;
        if (fileChooser != null) {
            return fileChooser;
        }
        fileChooser = jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        FileFilter fileFilter = null;
        for (int i = 0; i < DocumentModel.getDocumentCount(); ++i) {
            XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentAt(i);
            jFileChooser.addChoosableFileFilter(xMLDocumentInfo.getFileFilter());
            if (fileFilter != null) continue;
            fileFilter = xMLDocumentInfo.getFileFilter();
        }
        jFileChooser.setFileFilter(fileFilter);
        return jFileChooser;
    }

    public static JFileChooser buildProjectFileChooser() {
        JFileChooser jFileChooser;
        if (projectChooser != null) {
            return projectChooser;
        }
        projectChooser = jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "*.pre (editix project file)";
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".pre");
            }
        });
        return jFileChooser;
    }

    public static void buildAndShowErrorDialog(String string) {
        JOptionPane.showMessageDialog(EditixFrame.ACCESSOR, string, "Error", 0);
    }

    public static String buildAndShowInputDialog(String string) {
        return JOptionPane.showInputDialog(EditixFrame.ACCESSOR, (Object)string);
    }

    public static void buildAndShowInformationDialog(String string) {
        JOptionPane.showMessageDialog(EditixFrame.ACCESSOR, string, "Info", 1);
    }

    public static int buildAndShowChoiceDialog(String string) {
        return JOptionPane.showConfirmDialog(EditixFrame.ACCESSOR, string, "Choice", 0);
    }

    static class EditixXMLContainer
    extends XMLContainer
    implements LocationListener,
    DocumentStateListener,
    CaretListener {
        public EditixXMLContainer() {
            this.setToolBarAvailable(false);
            this.setStatusBarAvailable(false);
            this.setPopupAvailable(false);
            this.setTreePopupAvailable(false);
        }

        public void addNotify() {
            this.setLocationListener(this);
            this.addDocumentStateListener(this);
            this.setCaretListener(this);
        }

        public void removeNotify() {
            this.unsetLocationListener();
            this.removeDocumentStateListener(this);
            this.unsetCaretListener();
        }

        public void setUIReady(boolean bl) {
            super.setUIReady(bl);
            if (bl) {
                this.addNotify();
            } else {
                this.removeNotify();
            }
        }

        public void locationChanged(LocationEvent locationEvent) {
            EditixStatusBar.ACCESSOR.setXPathLocation(locationEvent.getXPathLocation());
        }

        public void documentModified(XMLContainer xMLContainer) {
        }

        public void newDocument(XMLContainer xMLContainer) {
        }

        public JPopupMenu getCurrentPopup() {
            return EditixFrame.ACCESSOR.getBuilder().getPopup("EDITOR");
        }

        protected boolean useCustomPopupMenu() {
            return true;
        }

        public void caretLocation(int n, int n2) {
            EditixStatusBar.ACCESSOR.setLocation(n, n2);
        }
    }
}

