/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.ui;

import com.japisoft.editix.db.Driver;
import com.japisoft.editix.db.DriverDbManager;
import com.japisoft.editix.ui.EditixFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class DbConnectionPanel
extends JPanel
implements ActionListener {
    private JComboBox cbDriver;
    private JButton btnTest;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JPasswordField txtPassword;
    private JTextField txtUrl;
    private JTextField txtUser;

    public DbConnectionPanel() {
        this.initComponents();
        for (int i = 0; i < DriverDbManager.getDriverCount(); ++i) {
            this.cbDriver.addItem(DriverDbManager.getDriver(i));
        }
    }

    public void addNotify() {
        super.addNotify();
        this.cbDriver.addActionListener(this);
        if (this.cbDriver.getItemCount() > 0) {
            this.cbDriver.setSelectedIndex(0);
        } else {
            System.out.println("No driver found ??");
        }
        this.btnTest.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.cbDriver.removeActionListener(this);
        this.btnTest.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbDriver) {
            Driver driver = (Driver)this.cbDriver.getSelectedItem();
            this.txtUrl.setText(driver.url);
            this.txtPassword.setEnabled(!driver.embedded);
            this.txtUser.setEnabled(!driver.embedded);
        } else if (actionEvent.getSource() == this.btnTest) {
            Driver driver = (Driver)this.cbDriver.getSelectedItem();
            if (driver.test(this.txtUrl.getText(), this.txtUser.getText(), this.txtPassword.getText())) {
                EditixFactory.buildAndShowInformationDialog("Success Connection");
            } else {
                EditixFactory.buildAndShowErrorDialog("Can't connect");
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbDriver = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.txtUrl = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtUser = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtPassword = new JPasswordField();
        this.btnTest = new JButton();
        this.jLabel1.setText("Driver");
        this.jLabel2.setText("URL/Path");
        this.jLabel3.setText("User");
        this.jLabel4.setText("Password");
        this.btnTest.setText("Test");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbDriver, 0, 224, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jSeparator1, -1, 224, Short.MAX_VALUE).add((Component)this.jLabel2).add((Component)this.txtUrl, -1, 224, Short.MAX_VALUE).add((Component)this.jLabel3).add((Component)this.txtUser, -1, 224, Short.MAX_VALUE).add((Component)this.jLabel4).add((Component)this.txtPassword, -1, 224, Short.MAX_VALUE).add((Component)this.btnTest)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cbDriver, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.txtUrl, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.txtUser, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.txtPassword, -2, -1, -2).addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.btnTest).addContainerGap()));
    }

    public String getUrl() {
        return this.txtUrl.getText();
    }

    public String getUser() {
        return this.txtUser.getText();
    }

    public String getPassword() {
        return this.txtPassword.getText();
    }

    public Driver getDriver() {
        return (Driver)this.cbDriver.getSelectedItem();
    }
}

