/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file;

import com.japisoft.editix.action.panels.PanelAction;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.universalbrowser.ZIPBrowserPanel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p.Manager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class BrowseZIPAction
extends PanelAction {
    public static void addFileFilterForZipArchives(JFileChooser jFileChooser, boolean bl) {
        String string = Preferences.getPreference("zipbrowser", "zip extensions", "[Default archive]-zip;[Java Files]-jar-sar-ear-par-ejb3-war;[Microsoft Office documents]-docx-xslx-pptx;[Open office documents]-odt-ods-odp-odg-odf");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        CustomFileFilter customFileFilter = null;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                string2 = stringTokenizer.nextToken();
                CustomFileFilter customFileFilter2 = new CustomFileFilter(string2);
                jFileChooser.addChoosableFileFilter(customFileFilter2);
                if (customFileFilter != null) continue;
                customFileFilter = customFileFilter2;
            }
            catch (Throwable throwable) {
                EditixFactory.buildAndShowWarningDialog("Wrong zipbrowser preference value :" + string2 + " ??");
            }
        }
        if (customFileFilter != null && bl) {
            jFileChooser.setFileFilter(customFileFilter);
        }
    }

    public static boolean isFileArchive(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        String string3 = Preferences.getPreference("zipbrowser", "zip extensions", "[Default archive]-zip;[Java Files]-jar-sar-ear-par-ejb3-war;[Microsoft Office documents]-docx-xslx-pptx;[Open office documents]-odt-ods-odp-odg-odf");
        StringTokenizer stringTokenizer = new StringTokenizer(string3.toLowerCase(), ";-");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string2.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        BrowseZIPAction.addFileFilterForZipArchives(jFileChooser, true);
        if (jFileChooser.showOpenDialog(EditixFrame.ACCESSOR) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        this.browse(file);
    }

    public void browse(File file) {
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            String string = "zip:file://" + file.toString();
            ((ZIPBrowserPanel)this.preparePanel()).browse(string, null, null);
        }
        catch (FileSystemException fileSystemException) {
            EditixFactory.buildAndShowErrorDialog("Inner Error : " + fileSystemException.getMessage());
            return;
        }
        this.alwaysShown = true;
        super.actionPerformed(null);
    }

    static class CustomFileFilter
    extends FileFilter {
        private String description;
        private ArrayList exts = null;

        CustomFileFilter(String string) throws Throwable {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            String string2 = stringTokenizer.nextToken();
            this.description = string2.substring(1, string2.length() - 1);
            while (stringTokenizer.hasMoreTokens()) {
                if (this.exts == null) {
                    this.exts = new ArrayList();
                }
                String string3 = "." + stringTokenizer.nextToken().toLowerCase();
                this.exts.add(string3);
                this.description = this.description + " (*" + string3 + ")";
            }
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.toString().toLowerCase();
            if (this.exts != null) {
                for (int i = 0; i < this.exts.size(); ++i) {
                    if (!string.endsWith((String)this.exts.get(i))) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

