/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema.generator.transformer;

import com.japisoft.editix.action.dtdschema.generator.MetaAttribute;
import com.japisoft.editix.action.dtdschema.generator.MetaNode;
import com.japisoft.editix.action.dtdschema.generator.Transformer;
import com.japisoft.editix.action.dtdschema.generator.transformer.SchemaTransformer;
import java.util.ArrayList;
import java.util.Vector;

public class RelaxNGTransformer
implements Transformer {
    public String transform(MetaNode metaNode, ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\" datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\n");
        stringBuffer.append("\t<start>\n");
        stringBuffer.append("\t\t<ref name=\"").append(metaNode.getName()).append(".element\"/>\n");
        stringBuffer.append("\t</start>\n");
        for (int i = 0; i < arrayList.size(); ++i) {
            this.addElement((MetaNode)arrayList.get(i), stringBuffer);
        }
        stringBuffer.append("</grammar>\n");
        return stringBuffer.toString();
    }

    private void addElement(MetaNode metaNode, StringBuffer stringBuffer) {
        stringBuffer.append("\n\t<define name=\"").append(metaNode.getName()).append(".element\">\n");
        stringBuffer.append("\t\t<element name=\"").append(metaNode.getName()).append("\">\n");
        if (metaNode.acceptText()) {
            stringBuffer.append("\t\t\t<text/>\n");
        } else if (metaNode.getChildren().size() == 0) {
            stringBuffer.append("\t\t\t<empty/>\n");
        }
        if (metaNode.hasAttributes()) {
            Vector vector = metaNode.getAttributes();
            for (int i = 0; i < vector.size(); ++i) {
                MetaAttribute metaAttribute = (MetaAttribute)vector.get(i);
                if (!metaAttribute.isAlways()) {
                    stringBuffer.append("\t\t\t<optional>\n");
                }
                stringBuffer.append("\t\t\t\t<attribute name=\"").append(metaAttribute.getName()).append("\">\n");
                if (!metaAttribute.getType().equals("TEXT")) {
                    stringBuffer.append("\t\t\t\t\t<data type=\"").append(SchemaTransformer.translateType(metaAttribute.getType())).append("\"/>\n");
                } else {
                    stringBuffer.append("\t\t\t\t<text/>\n");
                }
                stringBuffer.append("\t\t\t\t</attribute>\n");
                if (metaAttribute.isAlways()) continue;
                stringBuffer.append("\t\t\t</optional>\n");
            }
        }
        if (metaNode.getChildren().size() > 0) {
            stringBuffer.append("\t\t\t<zeroOrMore>\n");
            stringBuffer.append("\t\t\t\t<choice>\n");
            for (int i = 0; i < metaNode.getChildren().size(); ++i) {
                MetaNode metaNode2 = (MetaNode)metaNode.getChildren().get(i);
                stringBuffer.append("\t\t\t\t\t<ref name=\"").append(metaNode2.getName()).append(".element\"/>\n");
            }
            stringBuffer.append("\t\t\t\t</choice>\n");
            stringBuffer.append("\t\t\t</zeroOrMore>\n");
        }
        stringBuffer.append("\t\t</element>\n");
        stringBuffer.append("\t</define>\n");
    }

    public String getType() {
        return "RNG";
    }

    public boolean hasVersion() {
        return true;
    }
}

