/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.xmlpad.XMLContainer;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.input.parse.sax.SAXParseInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.dtd.DtdOutputFormat;
import com.thaiopensource.relaxng.output.rnc.RncOutputFormat;
import com.thaiopensource.relaxng.output.rng.RngOutputFormat;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.ErrorHandler;

public class ConvertAction
extends AbstractAction {
    private final ErrorHandlerImpl eh = new ErrorHandlerImpl();

    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        if (EditixFactory.mustSaveDialog(xMLContainer)) {
            return;
        }
        ActionModel.activeActionById("save", actionEvent);
        if (!ActionModel.LAST_ACTION_STATE) {
            return;
        }
        String string = xMLContainer.getDocumentInfo().getType();
        boolean bl = "RNG".equals(string);
        Object object = null;
        object = bl ? new SAXParseInputFormat() : new DtdInputFormat();
        String string2 = (String)this.getValue("param");
        if (string2 == null) {
            return;
        }
        DtdOutputFormat dtdOutputFormat = null;
        if (string2.equalsIgnoreCase("dtd")) {
            dtdOutputFormat = new DtdOutputFormat();
        } else if (string2.equalsIgnoreCase("rng")) {
            dtdOutputFormat = new RngOutputFormat();
        } else if (string2.equalsIgnoreCase("xsd")) {
            dtdOutputFormat = new XsdOutputFormat();
        } else if (string2.equalsIgnoreCase("rnc")) {
            dtdOutputFormat = new RncOutputFormat();
        } else {
            System.err.println("UNKNOWN OUTPUT = " + string2);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Choose your result file");
        final String string3 = string2;
        final String string4 = "(*." + string3 + ")";
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().endsWith(string3);
            }

            public String getDescription() {
                return string4;
            }
        });
        File file = null;
        if (jFileChooser.showSaveDialog(xMLContainer.getView()) != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        try {
            if (xMLContainer.hasErrorMessage()) {
                xMLContainer.getErrorManager().notifyError("Cannot convert if the current document contains errors");
                return;
            }
            SchemaCollection schemaCollection = object.load(UriOrFile.toUri((String)xMLContainer.getCurrentDocumentLocation()), new String[0], string2, (ErrorHandler)this.eh);
            LocalOutputDirectory localOutputDirectory = new LocalOutputDirectory(schemaCollection.getMainUri(), file, string2, "ISO-8859-1", 72, 2);
            dtdOutputFormat.output(schemaCollection, (OutputDirectory)localOutputDirectory, new String[0], xMLContainer.getDocumentInfo().getType().toLowerCase(), (ErrorHandler)this.eh);
            ActionModel.activeActionById("open", actionEvent, file.toString());
        }
        catch (Exception exception) {
            xMLContainer.getErrorManager().initErrorProcessing();
            xMLContainer.getErrorManager().notifyError("Can't convert to " + string2 + " : Check your schema");
            xMLContainer.getErrorManager().stopErrorProcessing();
        }
    }
}

