/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.CommentParser;
import DTDDoc.DefinitionsMap;
import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDOutput;
import com.wutka.dtd.DTDParser;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ExtendedDTD {
    private DefinitionsMap definitionsMap;
    private File systemPath;
    private DTD dtd;
    private String title = null;
    private String encoding = null;
    private Map parents = null;
    private Hashtable attributesListMap;

    public String getEncoding() {
        return this.encoding;
    }

    public String getTitle() {
        return this.title;
    }

    public Vector getItems() {
        return this.dtd.items;
    }

    public Hashtable getElements() {
        return this.dtd.elements;
    }

    public Collection getElementsCollection() {
        return this.dtd.elements.values();
    }

    public DTDElement getElementByName(String string) {
        Object v = this.getElements().get(string);
        if (v != null) {
            return (DTDElement)v;
        }
        return null;
    }

    public DTDElement getElementByName(DTDName dTDName) {
        return this.getElementByName(dTDName.getValue());
    }

    public Hashtable getEntities() {
        return this.dtd.entities;
    }

    public DTDElement getRootElement() {
        return this.dtd.rootElement;
    }

    public void setRootElement(DTDElement dTDElement) {
        this.dtd.rootElement = dTDElement;
    }

    public File getSystemPath() {
        return this.systemPath;
    }

    public boolean isExternal(DTDElement dTDElement) {
        String string = (String)this.definitionsMap.elementsLocations.get(dTDElement.name);
        return !string.equals(this.getSystemPath().getPath());
    }

    public boolean isExternal(DTDAttlist dTDAttlist) {
        return this.isExternal((DTDElement)this.getElements().get(dTDAttlist.getName()));
    }

    public String getElementOrigin(DTDElement dTDElement) {
        String string = (String)this.definitionsMap.elementsLocations.get(dTDElement.name);
        return string;
    }

    public ExtendedDTD(File file) throws IOException {
        this.systemPath = file;
        if (!this.getSystemPath().canRead()) {
            throw new IOException("Can't read " + this.getSystemPath() + ". Be prepared to get tons of errors !");
        }
        this.definitionsMap = this.locateElements(this.getSystemPath().getPath());
        DTDParser dTDParser = new DTDParser(this.getSystemPath());
        this.dtd = dTDParser.parse(true);
        this.setRootElement();
        this.attributesListMap = this.makeAttributesListsMap();
        this.parents = this.findParents(this.dtd);
        this.guessRoots(this.parents);
    }

    private DefinitionsMap locateElements(String string) throws IOException {
        DTDOutput dTDOutput;
        Object object;
        DTD dTD = null;
        File file = new File(string);
        try {
            object = new DTDParser(file);
            dTD = ((DTDParser)object).parse(true);
        }
        catch (Exception exception) {
            return null;
        }
        object = new DefinitionsMap();
        Enumeration enumeration = dTD.entities.elements();
        while (enumeration.hasMoreElements()) {
            dTDOutput = (DTDEntity)enumeration.nextElement();
            String string2 = null;
            if (dTDOutput.getExternalID() != null) {
                string2 = dTDOutput.getExternalID().getSystem();
            }
            if (string2 == null || string2.startsWith("http:") || string2.startsWith("file:")) continue;
            string2 = string.substring(0, string.lastIndexOf(File.separatorChar) + 1) + string2;
            ((DefinitionsMap)object).merge(this.locateElements(string2));
        }
        enumeration = dTD.elements.elements();
        while (enumeration.hasMoreElements()) {
            dTDOutput = (DTDElement)enumeration.nextElement();
            if (((DefinitionsMap)object).elementsLocations.containsKey(((DTDElement)dTDOutput).name)) continue;
            ((DefinitionsMap)object).elementsLocations.put(((DTDElement)dTDOutput).name, string);
        }
        return object;
    }

    private String getFilename(String string) {
        int n = string.lastIndexOf(File.separator) + 1;
        return string.substring(n);
    }

    private String findRootTagValue() {
        String string = null;
        Enumeration enumeration = this.getItems().elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            Object e = enumeration.nextElement();
            if (!(e instanceof DTDComment)) continue;
            DTDComment dTDComment = (DTDComment)e;
            CommentParser commentParser = new CommentParser(dTDComment);
            String string3 = commentParser.getUniqueTagValue("@root");
            if (string3 != null && this.getElements().get(string3) != null && !this.isExternal((DTDElement)this.getElements().get(string3))) {
                string = string3;
            }
            if ((string2 = commentParser.getUniqueTagValue("@title")) == null) continue;
            this.title = string2;
        }
        if (this.title == null) {
            this.title = this.getFilename(this.systemPath.getName());
        }
        return string;
    }

    private void setRootElement() {
        String string = this.findRootTagValue();
        if (string != null && this.getElements().get(string) != null) {
            this.setRootElement((DTDElement)this.getElements().get(string));
        }
    }

    public String makeUniqueId(DTDAttlist dTDAttlist, DTDAttribute dTDAttribute) {
        return dTDAttlist.name + "_" + dTDAttribute.getName();
    }

    public String makeUniqueId(DTDElement dTDElement, DTDAttribute dTDAttribute) {
        return dTDElement.name + "_" + dTDAttribute.getName();
    }

    public String makeUniqueId(DTDElement dTDElement) {
        return dTDElement.getName();
    }

    public DTDAttlist locateAttributesList(DTDAttribute dTDAttribute) {
        return (DTDAttlist)this.attributesListMap.get(dTDAttribute);
    }

    private Hashtable makeAttributesListsMap() {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!(this.getItems().get(i) instanceof DTDAttlist)) continue;
            DTDAttlist dTDAttlist = (DTDAttlist)this.getItems().get(i);
            for (int j = 0; j < dTDAttlist.attributes.size(); ++j) {
                hashtable.put(dTDAttlist.attributes.get(j), dTDAttlist);
            }
        }
        return hashtable;
    }

    private Collection guessRoots(Map map) {
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() != null) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    private Map findParents(DTD dTD) {
        HashMap<String, HashSet<DTDElement>> hashMap = new HashMap<String, HashSet<DTDElement>>();
        for (DTDElement dTDElement : dTD.elements.values()) {
            String string = dTDElement.getName();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, null);
            }
            DTDItem dTDItem = dTDElement.getContent();
            Set set = this.collectDeclaredChildren(dTDElement);
            if (set == null) continue;
            for (Object e : set) {
                if (!(e instanceof DTDName)) continue;
                String string2 = ((DTDName)e).getValue();
                if (dTDElement.getName().equals(string2)) continue;
                HashSet<DTDElement> hashSet = (HashSet<DTDElement>)hashMap.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<DTDElement>();
                }
                hashSet.add(dTDElement);
                hashMap.put(string2, hashSet);
            }
        }
        return hashMap;
    }

    public Set getParents(String string) {
        return (HashSet)this.parents.get(string);
    }

    public boolean isRoot(DTDElement dTDElement) {
        Set set = this.getParents(dTDElement.getName());
        return set == null || set.size() == 0;
    }

    public Set collectDeclaredChildren(DTDElement dTDElement) {
        return this.collectDeclaredChildrenHelper(dTDElement.getContent());
    }

    private Set collectDeclaredChildrenHelper(DTDItem dTDItem) {
        if (dTDItem instanceof DTDContainer) {
            Enumeration enumeration = ((DTDContainer)dTDItem).getItemsVec().elements();
            HashSet hashSet = null;
            while (enumeration.hasMoreElements()) {
                Set set = this.collectDeclaredChildrenHelper((DTDItem)enumeration.nextElement());
                if (set == null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.addAll(set);
            }
            return hashSet;
        }
        if (dTDItem instanceof DTDName) {
            return Collections.singleton(dTDItem);
        }
        return null;
    }
}

