/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestTransfer
extends FTPTestCase {
    private static String cvsId = "@(#)$Id: TestTransfer.java,v 1.4 2004/05/01 17:05:43 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestTransfer;

    protected String getLogName() {
        return "TestTransfer.log";
    }

    public void testTransferBinary() throws Exception {
        this.log.debug("testTransferBinary()");
        this.connect();
        this.login();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 2048L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(this.localBinaryFile, filename);
        this.ftp.get(filename, filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            TestTransfer.fail((String)(filename + " should not be found"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.assertIdentical(this.localBinaryFile, filename);
        File local = new File(filename);
        local.delete();
        this.ftp.quit();
    }

    public void testTransferText() throws Exception {
        this.log.debug("testTransferText()");
        this.connect();
        this.login();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 2048L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.ASCII);
        String filename = this.generateRandomFilename();
        this.ftp.put(this.localTextFile, filename);
        this.ftp.get(filename, filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            TestTransfer.fail((String)(filename + " should not be found"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.assertIdentical(this.localTextFile, filename);
        File local = new File(filename);
        local.delete();
        this.ftp.quit();
    }

    public void testGetBytes() throws Exception {
        this.log.debug("testGetBytes()");
        this.connect();
        this.login();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 2048L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename1 = this.generateRandomFilename();
        this.ftp.get(filename1, this.remoteBinaryFile);
        File file1 = new File(filename1);
        long len = file1.length();
        byte[] result = this.ftp.get(this.remoteBinaryFile);
        TestTransfer.assertTrue(((long)result.length == len ? 1 : 0) != 0);
        String filename2 = this.generateRandomFilename();
        this.ftp.put(result, filename2);
        this.ftp.get(filename2, filename2);
        this.ftp.delete(filename2);
        File file2 = new File(filename2);
        this.assertIdentical(file1, file2);
        file1.delete();
        file2.delete();
        this.ftp.quit();
    }

    public void testTransferStream() throws Exception {
        this.log.debug("testTransferStream()");
        this.connect();
        this.login();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 2048L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.ftp.get(out, this.remoteBinaryFile);
        byte[] result1 = out.toByteArray();
        String filename = this.generateRandomFilename();
        this.ftp.put(new ByteArrayInputStream(result1), filename);
        byte[] result2 = this.ftp.get(filename);
        this.ftp.delete(filename);
        this.assertIdentical(result1, result2);
        this.ftp.quit();
    }

    public void testPutAppend() throws Exception {
        this.log.debug("testPutAppend()");
        this.connect();
        this.login();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 2048L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(this.localBinaryFile, filename);
        this.ftp.put(this.localBinaryFile, filename, true);
        this.ftp.get(filename, filename);
        this.ftp.delete(filename);
        File file1 = new File(this.localBinaryFile);
        File file2 = new File(filename);
        TestTransfer.assertTrue((file1.length() * 2L == file2.length() ? 1 : 0) != 0);
        file2.delete();
        this.ftp.quit();
    }

    public void testTransferEmpty() throws Exception {
        this.log.debug("testTransferEmpty()");
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        this.ftp.get(this.remoteEmptyFile, this.remoteEmptyFile);
        File empty = new File(this.remoteEmptyFile);
        TestTransfer.assertTrue((boolean)empty.exists());
        TestTransfer.assertTrue((empty.length() == 0L ? 1 : 0) != 0);
        empty.delete();
        this.ftp.put(this.localEmptyFile, this.localEmptyFile);
        String filename = this.generateRandomFilename();
        this.ftp.get(filename, this.localEmptyFile);
        empty = new File(filename);
        TestTransfer.assertTrue((boolean)empty.exists());
        TestTransfer.assertTrue((empty.length() == 0L ? 1 : 0) != 0);
        empty.delete();
        this.ftp.delete(this.localEmptyFile);
        this.ftp.quit();
    }

    public void testTransferNonExistent() throws Exception {
        this.log.debug("testTransferNonExistent()");
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        String filename = this.generateRandomFilename();
        try {
            this.ftp.get(filename, filename);
            TestTransfer.fail((String)(filename + " should not be found"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
            File file = new File(filename);
            TestTransfer.assertFalse((boolean)file.exists());
        }
        filename = this.generateRandomFilename();
        try {
            this.ftp.put(filename, filename);
            TestTransfer.fail((String)(filename + " should not be found"));
        }
        catch (FileNotFoundException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestTransfer == null ? (class$com$enterprisedt$net$ftp$test$TestTransfer = TestTransfer.class$("com.enterprisedt.net.ftp.test.TestTransfer")) : class$com$enterprisedt$net$ftp$test$TestTransfer);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestTransfer.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TestProgressMonitor
    implements FTPProgressMonitor {
        TestProgressMonitor() {
        }

        public void bytesTransferred(long count) {
            TestTransfer.this.log.debug(count + " bytes transferred");
        }
    }
}

