/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.util.UTF8;
import org.exist.util.XMLChar;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.GDayValue;
import org.exist.xquery.value.GMonthDayValue;
import org.exist.xquery.value.GMonthValue;
import org.exist.xquery.value.GYearMonthValue;
import org.exist.xquery.value.GYearValue;
import org.exist.xquery.value.HexBinary;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.YearMonthDurationValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    private static final String langRegex = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    private static final Pattern langPattern = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
    protected int type = 22;
    protected String value;

    public StringValue(String string, int type) throws XPathException {
        this.type = type;
        string = StringValue.expand(string);
        if (type == 22) {
            this.value = string;
        } else if (type == 61) {
            this.value = StringValue.normalizeWhitespace(string);
        } else {
            this.value = StringValue.collapseWhitespace(string);
            this.checkType();
        }
    }

    public StringValue(String string) {
        this.value = string;
    }

    public StringValue expand() throws XPathException {
        this.value = StringValue.expand(this.value);
        return this;
    }

    private void checkType() throws XPathException {
        switch (this.type) {
            case 60: 
            case 61: {
                return;
            }
            case 62: {
                Matcher matcher = langPattern.matcher(this.value);
                if (!matcher.matches()) {
                    throw new XPathException("Type error: string " + this.value + " is not valid for type xs:language");
                }
                return;
            }
            case 64: {
                if (!QName.isQName(this.value)) {
                    throw new XPathException("Type error: string " + this.value + " is not a valid xs:Name");
                }
                return;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                if (!XMLChar.isValidNCName(this.value)) {
                    throw new XPathException("Type error: string " + this.value + " is not a valid " + Type.getTypeName(this.type));
                }
            }
            case 63: {
                if (XMLChar.isValidNmtoken(this.value)) break;
                throw new XPathException("Type error: string " + this.value + " is not a valid xs:NMTOKEN");
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public String getStringValue() {
        return this.getStringValue(false);
    }

    public String getStringValue(boolean bmpCheck) {
        if (bmpCheck) {
            StringBuffer buf = new StringBuffer(this.value.length());
            for (int i = 0; i < this.value.length(); ++i) {
                char ch = this.value.charAt(i);
                if (XMLChar.isSurrogate(ch)) {
                    int suppChar = XMLChar.supplemental(ch, this.value.charAt(++i));
                    buf.append("&#");
                    buf.append(Integer.toString(suppChar));
                    buf.append(";");
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        return this.value;
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 22: {
                return this;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return new StringValue(this.value, requiredType);
            }
            case 25: {
                return new AnyURIValue(this.value);
            }
            case 23: {
                String trimmed = StringValue.trimWhitespace(this.value);
                if (trimmed.equals("0") || trimmed.equals("false")) {
                    return BooleanValue.FALSE;
                }
                if (trimmed.equals("1") || trimmed.equals("true")) {
                    return BooleanValue.TRUE;
                }
                throw new XPathException("cannot convert string '" + this.value + "' to boolean");
            }
            case 33: {
                return new FloatValue(this.value);
            }
            case 30: 
            case 34: {
                return new DoubleValue(this);
            }
            case 32: {
                return new DecimalValue(this.value);
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(this.value, requiredType);
            }
            case 26: {
                return new Base64Binary(this.value);
            }
            case 27: {
                return new HexBinary(this.value);
            }
            case 50: {
                return new DateTimeValue(this.value);
            }
            case 52: {
                return new TimeValue(this.value);
            }
            case 51: {
                return new DateValue(this.value);
            }
            case 53: {
                return new DurationValue(this.value);
            }
            case 54: {
                return new YearMonthDurationValue(this.value);
            }
            case 55: {
                return new DayTimeDurationValue(this.value);
            }
            case 56: {
                return new GYearValue(this.value);
            }
            case 57: {
                return new GMonthValue(this.value);
            }
            case 58: {
                return new GDayValue(this.value);
            }
            case 59: {
                return new GYearMonthValue(this.value);
            }
            case 71: {
                return new GMonthDayValue(this.value);
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 24: {
                return new QNameValue(null, new QName(this.value));
            }
        }
        throw new XPathException("FORG0001: cannot cast '" + Type.getTypeName(this.getItemType()) + "(\"" + this.getStringValue() + "\")' to " + Type.getTypeName(requiredType));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(StringValue.class)) {
            return 0;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 1;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(StringValue.class)) {
            return this;
        }
        if (target == Object.class || target == String.class || target == CharSequence.class) {
            return this.value;
        }
        if (target == Double.TYPE || target == Double.class) {
            DoubleValue v = (DoubleValue)this.convertTo(34);
            return new Double(v.getValue());
        }
        if (target == Float.TYPE || target == Float.class) {
            FloatValue v = (FloatValue)this.convertTo(33);
            return new Float(v.value);
        }
        if (target == Long.TYPE || target == Long.class) {
            IntegerValue v = (IntegerValue)this.convertTo(37);
            return new Long(v.getInt());
        }
        if (target == Integer.TYPE || target == Integer.class) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer(v.getInt());
        }
        if (target == Short.TYPE || target == Short.class) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getInt());
        }
        if (target == Byte.TYPE || target == Byte.class) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getInt());
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        if (target == Character.TYPE || target == Character.class) {
            if (this.value.length() > 1 || this.value.length() == 0) {
                throw new XPathException("cannot convert string with length = 0 or length > 1 to Java character");
            }
            return new Character(this.value.charAt(0));
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.type) + " to Java object of type " + target.getName());
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.isEmpty()) {
            return false;
        }
        if (Type.subTypeOf(other.getType(), 25)) {
            other = other.convertTo(22);
        }
        if (Type.subTypeOf(other.getType(), 22)) {
            int cmp = Collations.compare(collator, this.value, other.getStringValue());
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operand to string value");
        }
        throw new XPathException("XPTY0004: can not compare xs:string('" + this.value + "') with " + Type.getTypeName(other.getType()) + "('" + other.getStringValue() + "')");
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 30)) {
            if (((NumericValue)other).isNaN()) {
                return -1;
            }
            if (((NumericValue)other).isInfinite()) {
                return -1;
            }
        }
        return Collations.compare(collator, this.value, other.getStringValue());
    }

    public boolean startsWith(Collator collator, AtomicValue other) throws XPathException {
        return Collations.startsWith(collator, this.value, other.getStringValue());
    }

    public boolean endsWith(Collator collator, AtomicValue other) throws XPathException {
        return Collations.endsWith(collator, this.value, other.getStringValue());
    }

    public boolean contains(Collator collator, AtomicValue other) throws XPathException {
        return Collations.indexOf(collator, this.value, other.getStringValue()) != -1;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value.length() > 0;
    }

    public String toString() {
        return this.value;
    }

    public static final String normalizeWhitespace(CharSequence seq) {
        if (seq == null) {
            return "";
        }
        StringBuffer copy = new StringBuffer(seq.length());
        block3: for (int i = 0; i < seq.length(); ++i) {
            char ch = seq.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    copy.append(' ');
                    continue block3;
                }
                default: {
                    copy.append(ch);
                }
            }
        }
        return copy.toString();
    }

    public static String collapseWhitespace(CharSequence in) {
        char c;
        int i;
        if (in == null) {
            return "";
        }
        if (in.length() == 0) {
            return ((Object)in).toString();
        }
        for (i = 0; !(i >= in.length() || XMLChar.isSpace(c = in.charAt(i)) && i + 1 < in.length() && XMLChar.isSpace(in.charAt(i + 1))); ++i) {
        }
        if (i == in.length()) {
            return ((Object)in).toString();
        }
        StringBuffer sb = new StringBuffer(in.length());
        sb.append(((Object)in.subSequence(0, i + 1)).toString());
        boolean inWhitespace = true;
        while (i < in.length()) {
            char c2 = in.charAt(i);
            if (XMLChar.isSpace(c2)) {
                if (!inWhitespace) {
                    sb.append(' ');
                    inWhitespace = true;
                }
            } else {
                sb.append(c2);
                inWhitespace = false;
            }
            ++i;
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final String trimWhitespace(String in) {
        if (in == null) {
            return "";
        }
        if (in.length() == 0) {
            return in;
        }
        int first = 0;
        int last = in.length() - 1;
        while (in.charAt(first) <= ' ') {
            if (first++ < last) continue;
            return "";
        }
        while (in.charAt(last) <= ' ') {
            --last;
        }
        return in.substring(first, last + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static final String expand(CharSequence seq) throws XPathException {
        if (seq == null) {
            return "";
        }
        buf = new StringBuffer(seq.length());
        entityRef = null;
        block4: for (i = 0; i < seq.length(); ++i) {
            ch = seq.charAt(i);
            switch (ch) {
                case '&': {
                    if (entityRef == null) {
                        entityRef = new StringBuffer();
                    } else {
                        entityRef.setLength(0);
                    }
                    if (i + 1 == seq.length()) {
                        throw new XPathException("XPST0003 : Ampersands (&) must be escaped.");
                    }
                    if (i + 2 == seq.length()) {
                        throw new XPathException("XPST0003 : Ampersands (&) must be escaped (missing ;).");
                    }
                    ch = seq.charAt(i + 1);
                    if (ch != '#') {
                        if (!Character.isLetter(ch)) {
                            throw new XPathException("XPST0003 : Ampersands (&) must be escaped (following character was not a name start character).");
                        }
                        entityRef.append(ch);
                        found = false;
                        for (j = i + 2; j < seq.length(); ++j) {
                            ch = seq.charAt(j);
                            if (ch == ';' || ch != '.' && ch != '_' && ch != '-' && !Character.isLetterOrDigit(ch)) {
                                if (ch != ';') break;
                                found = true;
                                i = j;
                                break;
                            }
                            entityRef.append(ch);
                        }
                        if (found) {
                            buf.append((char)StringValue.expandEntity(entityRef.toString()));
                            continue block4;
                        }
                        throw new XPathException("XPST0003 : Invalid character in entity name (" + ch + ") or missing ;");
                    }
                    entityRef.append(ch);
                    ch = seq.charAt(i + 2);
                    found = false;
                    if (ch != 'x') ** GOTO lbl58
                    entityRef.append(ch);
                    for (j = i + 3; j < seq.length(); ++j) {
                        ch = seq.charAt(j);
                        if (ch != ';' && (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9' || ch == 'a' || ch == 'b' || ch == 'c' || ch == 'd' || ch == 'e' || ch == 'f' || ch == 'A' || ch == 'B' || ch == 'C' || ch == 'D' || ch == 'E' || ch == 'F')) ** GOTO lbl54
                        if (ch == ';') {
                            found = true;
                            i = j;
                        }
                        ** GOTO lbl69
lbl54:
                        // 1 sources

                        entityRef.append(ch);
                    }
                    ** GOTO lbl69
lbl58:
                    // 2 sources

                    for (j = i + 2; j < seq.length(); ++j) {
                        ch = seq.charAt(j);
                        if (ch != ';' && (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9')) ** GOTO lbl66
                        if (ch == ';') {
                            found = true;
                            i = j;
                        }
                        break;
lbl66:
                        // 1 sources

                        entityRef.append(ch);
                    }
lbl69:
                    // 4 sources

                    if (found) {
                        charref = StringValue.expandEntity(entityRef.toString());
                        if (XMLChar.isSupplemental(charref)) {
                            buf.append(XMLChar.highSurrogate(charref));
                            buf.append(XMLChar.lowSurrogate(charref));
                            continue block4;
                        }
                        buf.append((char)charref);
                        continue block4;
                    }
                    throw new XPathException("XPST0003 : Invalid character in character reference (" + ch + ") or missing ;");
                }
                case '\r': {
                    if (i + 1 == seq.length() || (ch = seq.charAt(i + 1)) == '\n') continue block4;
                    buf.append('\n');
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    private static final int expandEntity(String buf) throws XPathException {
        if (buf.equals("amp")) {
            return 38;
        }
        if (buf.equals("lt")) {
            return 60;
        }
        if (buf.equals("gt")) {
            return 62;
        }
        if (buf.equals("quot")) {
            return 34;
        }
        if (buf.equals("apos")) {
            return 39;
        }
        if (buf.length() > 1 && buf.charAt(0) == '#') {
            return StringValue.expandCharRef(buf.substring(1));
        }
        throw new XPathException("Unknown entity reference: " + buf);
    }

    private static final int expandCharRef(String buf) throws XPathException {
        try {
            int charNumber = buf.length() > 1 && buf.charAt(0) == 'x' ? Integer.parseInt(buf.substring(1), 16) : Integer.parseInt(buf);
            if (charNumber == 0) {
                throw new XPathException("XQST0090 : Character number zero (0) is not allowed.");
            }
            return charNumber;
        }
        catch (NumberFormatException e) {
            throw new XPathException("Unknown character reference: " + buf);
        }
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 22)) {
            return Collations.compare(collator, this.value, ((StringValue)other).value) > 0 ? this : other;
        }
        return Collations.compare(collator, this.value, ((StringValue)other.convertTo((int)this.getType())).value) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 22)) {
            return Collations.compare(collator, this.value, ((StringValue)other).value) < 0 ? this : other;
        }
        return Collations.compare(collator, this.value, ((StringValue)other.convertTo((int)this.getType())).value) < 0 ? this : other;
    }

    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 22)) {
            return this.value.compareTo(((StringValue)other).value);
        }
        return this.getType() > other.getType() ? 1 : -1;
    }

    public byte[] serializeValue(int offset, boolean caseSensitive) {
        String val = caseSensitive ? this.value : this.value.toLowerCase();
        byte[] data = new byte[offset + 1 + UTF8.encoded(val)];
        data[offset] = (byte)this.type;
        UTF8.encode(val, data, offset + 1);
        return data;
    }
}

